/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.javascript.jslint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class JSLintReader {

	static private final String JSLINT_FILENAME = "resources/jslint.js";
	
	
	/*
	 * Checks to see if the jslint.js file has been installed
	 */
	static public boolean isJSLintAvailable(){
		return FileLocator.find(JSLintPlugin.getDefault().getBundle(), new Path(JSLINT_FILENAME), null) != null;
	}

	static public Reader getJSLintReader() throws IOException {
		Bundle bundle = JSLintPlugin.getDefault().getBundle();
		
		InputStream stream =
			FileLocator.openStream(bundle, new Path(JSLINT_FILENAME), false);

		return new BufferedReader(new InputStreamReader(stream, "US-ASCII")); // encoding should match whatever is used in jslint.js
	}
	
	static public String getJSLintFileName () {
		return JSLINT_FILENAME;
	}
	
}
