/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.javascript.internal.validation;

import java.io.IOException;
import java.io.Reader;

import org.eclipse.atf.javascript.internal.validation.jslint.JSLint;
import org.eclipse.atf.javascript.internal.validation.jslint.JSLintError;
import org.eclipse.atf.javascript.jslint.JSLintReader;
import org.eclipse.atf.javascript.validator.JavaScriptValidatorPlugin;
import org.eclipse.atf.util.ErrorStatusUtilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Bundle;

public class JSLintValidator extends JSAbstractValidator {
/*
	static private Scriptable _scope, _options;
	static private Function _lintFunction;
	
	static {
		// Create lint function once and cache as many objects as possible.
		Context cx = Context.enter();
		Reader reader = null;
		try {
			
			//check for jslint.js and pop a dialog if not available
			if( !isJSLintAvailable() ){
				
				IStatus status = new Status(IStatus.ERROR, JavaScriptValidatorPlugin.getDefault().getBundle().getSymbolicName(), IStatus.ERROR, 
						"The jslint.js file is not installed. Refer to installation instructions on how to install jslint.js.", null);
				throw new CoreException( status );
			}			
			
			reader = getJSLintReader();
			Script lintScript = cx.compileReader(reader, "jslint", 0, null);
			_scope = cx.initStandardObjects(null);
			lintScript.exec(cx, _scope);
			//Object jslint = _scope.get("jslint", _scope);
			Object jslint = cx.evaluateString(_scope, "var jslint,JSLINT;(jslint || JSLINT)", "_internal_jslint_lookup_", 1, null);
			if (!(jslint instanceof Function)) {
				if (Platform.inDebugMode()) {
					Bundle bundle = JavaScriptValidatorPlugin.getDefault().getBundle();
					IStatus status = new Status(IStatus.ERROR, bundle.getSymbolicName(), IStatus.ERROR, 
							"lint is undefined or not a function.", null);
					Platform.getLog(bundle).log(status);
				}
			    //throw new ExceptionInInitializerError("Unable to initialize jslint");
				IStatus status = new Status(IStatus.ERROR, JavaScriptValidatorPlugin.getDefault().getBundle().getSymbolicName(), IStatus.ERROR, 
						"Could not find the function \"jslint\" inside "+JSLintReader.getJSLintFileName() +".", null);
				throw new CoreException( status );
			}
			_lintFunction = (Function)jslint;

			_options = new ScriptableObject(_scope, null) {
				public String getClassName() {return "options";};
			};
			_options.put("debug", _options, Boolean.TRUE); // allow the "debugger" keyword
			_options.put("evil", _options, Boolean.TRUE); // allow use of eval()
		} catch(IOException ioe) {
			ioe.printStackTrace();
		} 
		catch( CoreException ce ){
			//open a dialog
			ErrorStatusUtilities.showErrorDialog("ATF Installation Error Detected", 
					"JSLint syntax validation will be disabled.", 
					ce.getStatus() );
			
		}
		finally {
			Context.exit();
			if (reader != null)
				try {
					reader.close();
				} catch (IOException ioe) {
					ioe.printStackTrace();
				}
		}
	}
*/
	
	public JSLintValidator() {
		super(JSValidationMessages.MESSAGE_JSLINT_VALIDATION_MESSAGE);
	}

	public void cleanup(IReporter reporter) {
		super.cleanup(reporter);
	}

	public void validateString(String script, int lineno, String uri, IReporter reporter) throws ValidationException {
//System.err.println("JSLintValidator: lineno="+lineno+" script="+script);

		long start = System.currentTimeMillis();
		
		JSLint jslint = JSLint.getInstance();
		JSLintError [] errors = null;
		synchronized ( jslint ) {
			if( jslint.isReady() ){
				errors = jslint.lint( script );	
			}
		}
		
		if( errors != null ){
			
			for (int i = 0; i < errors.length; i++) {
				
				if (errors[i] == null) {
		    		// do nothing; we already looked ahead to put this in the severity of
		    		// the previous marker
//System.err.println("LINT fatal error i="+i+" length="+length);
		    		//TODO: is that what jslint intended? can there be more errors in the list to process?
		    		continue;
		    	}
				
				int severity = ((i + 1 < errors.length) && (errors[i + 1] == null)) ?
						IMessage.NORMAL_SEVERITY : IMessage.LOW_SEVERITY;
				
				IMessage messageObject = new LocalizedMessage(severity, errors[i].getReason());
				messageObject.setLineNo(errors[i].getLine()+lineno);
				messageObject.setOffset(getLineOffset(errors[i].getLine()+lineno));
				messageObject.setLength(errors[i].getCharacter());
				messageObject.setTargetObject(uri);
				reporter.addMessage(this, messageObject);
			}
		}
		
		
		long end = System.currentTimeMillis();
		if (Platform.inDebugMode()) {
			Bundle bundle = JavaScriptValidatorPlugin.getDefault().getBundle();
			IStatus status = new Status(IStatus.INFO, bundle.getSymbolicName(), IStatus.INFO, 
					"Javascript Lint time elapsed=" + (end - start), null);
			Platform.getLog(bundle).log(status);
		}
	}

	/**
	 * Run JSLint in Rhino, passing in the script source via a JS function call.
	 * Flag errors and warnings through the reporter.  Most of what JSLint reports is
	 * valid JavaScript, so lower severity levels to NORMAL and LOW for errors and
	 * warnings, respectively.
	 * 
	 * @param script script to be parsed
	 * @param uri uri of the script, for annotation only
	 * @param lineno beginning line number reference, for annotation only
	 * @throws ValidationException if an internal error occurs running the jslint script
	 */
	/*
	private void lint(String source, String uri, int lineno, IReporter reporter) throws ValidationException {
		if (_lintFunction != null) {
			Context cx = Context.enter();
			try {
			    Object functionArgs[] = { source, _options };
			    Object result = _lintFunction.call(cx, _scope, _scope, functionArgs);
			    boolean lintFree = Context.toBoolean(result);
			    if (!lintFree) {
			    	Scriptable lint = (Scriptable)_lintFunction.get("errors", _lintFunction);
			    	Object lengthObject = lint.get("length", lint);
			    	if (!(lengthObject instanceof Double)) {
			    		return;
			    	}
			    	int length = ((Double)lengthObject).intValue();
			    	for (int i = 0; i < length; i++) {
			    		if (reporter.isCancelled())
			    			return;

			    		Scriptable error = (Scriptable)lint.get(i, lint);
				    	if (error == null) {
				    		// do nothing; we already looked ahead to put this in the severity of
				    		// the previous marker
//System.err.println("LINT fatal error i="+i+" length="+length);
				    		//TODO: is that what jslint intended? can there be more errors in the list to process?
				    		continue;
				    	}

				    	int line = ((Double)error.get("line", error)).intValue() + lineno;
				    	int character = ((Double)error.get("character", error)).intValue();
				    	String reason = (String)error.get("reason", error);
				    	String evidence = (String)error.get("evidence", error);
						int severity = ((i + 1 < length) && (lint.get(i + 1, lint) == null)) ?
								IMessage.NORMAL_SEVERITY : IMessage.LOW_SEVERITY;
//System.err.println("LINT line="+line+" sev="+severity+" character="+character+" reason="+reason+" evidence="+evidence);
						IMessage messageObject = new LocalizedMessage(severity, reason);
						messageObject.setLineNo(line);
						messageObject.setOffset(getLineOffset(line));
						messageObject.setLength(character);
						messageObject.setTargetObject(uri);
						reporter.addMessage(this, messageObject);
			    	}
			    } else {
			    	//TODO use jslint.report()?
//			    	Scriptable report = (Scriptable)_lintFunction.get("report", _lintFunction);
//				    Object output = ((Function)report).call(cx, _scope, _scope, functionArgs);
//				    System.out.println("jslint.report() = "+output);
			    }
			} catch(RhinoException rhinoe) {
				if (Platform.inDebugMode()) {
					Bundle bundle = JavaScriptValidatorPlugin.getDefault().getBundle();
					IStatus status = new Status(IStatus.ERROR, bundle.getSymbolicName(), IStatus.ERROR, 
							"Error running jslint script, file: " + rhinoe.sourceName() + " line: " +
							rhinoe.lineNumber(), rhinoe);
					Platform.getLog(bundle).log(status);
				}
				throw new ValidationException(new LocalizedMessage(IMessage.NORMAL_SEVERITY, "JSLint internal error: "+rhinoe.details()));
//			} catch(RuntimeException re) {
//				re.printStackTrace();
//				throw re;
			} finally {
				Context.exit();
			}
		}
	}
	*/
	
	/*
	 * Checks to see if the jslint.js file has been installed
	 *
	static private boolean isJSLintAvailable(){
		return JSLintReader.isJSLintAvailable();
	}

	static private Reader getJSLintReader() throws IOException {
		return JSLintReader.getJSLintReader();
	}
	*/
}