/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
package org.eclipse.atf.javascript.internal.validation;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.osgi.util.NLS;

/**
 * Strings used by Javascript Validator
 */
public class JSValidationMessages extends NLS {
	private static final String BUNDLE_NAME = "org.eclipse.atf.javascript.internal.validation.JSValidationMessages";//$NON-NLS-1$
	private static ResourceBundle fResourceBundle;

	static {
		// load message values from bundle file
		NLS.initializeMessages(BUNDLE_NAME, JSValidationMessages.class);
	}
	
	private JSValidationMessages() {
		// cannot create new instance of this class
	}
	
	public static ResourceBundle getResourceBundle() {
		try {
			if (fResourceBundle == null)
				fResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
		}
		catch (MissingResourceException x) {
			fResourceBundle = null;
		}
		return fResourceBundle;
	}
	
	public static String MESSAGE_JSSYNTAX_VALIDATION_MESSAGE;
	public static String MESSAGE_JSLINT_VALIDATION_MESSAGE;
}
