/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.javascript.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;

public class JSValidationWorkbenchHelper extends WorkbenchContext {
	/**
	 */
	public JSValidationWorkbenchHelper() {
		super();
	}

	/**
	 * Given an Object, if the object has a corresponding IFile in the workbench, return the IFile.
	 * Otherwise return null.
	 * 
	 * This method is used by the WorkbenchReporter. In eclipse, in order to add or remove a task
	 * list entry, the IResource, to which the entry applies, must be identified. The IReporter
	 * interface passes in an Object in these methods:
	 * 
	 * addValidationMessage(IValidator, IMessage) // Object is a part of IMessage
	 * 
	 * removeAllMessages(IValidator, Object),
	 * 
	 * Thus, the WorkbenchReporter needs to know how, given the Object, which IFile that the Object
	 * represents in the workbench, in order to be able to add the task list entry.
	 * 
	 * If this method returns null, then the WorkbenchReporter will add the message to the IProject
	 * instead of an IFile.
	 *  
	 */
	public IFile getFile(Object obj) {
		if (obj instanceof String) {
			return ResourcesPlugin.getWorkspace().getRoot().getFile(new Path((String)obj));
		}

		return null;
	}

	/**
	 * When an IValidator associates a target object with an IMessage, the
	 * WorkbenchReporter eventually resolves that target object with an
	 * IResource. Sometimes more than one target object resolves to the same
	 * IResource (usually the IProject, which is the default IResource when an
	 * IFile cannot be found). This method is called, by the
	 * WorkbenchReporter, so that the WorkbenchReporter can distinguish
	 * between the IMessages which are on the same IResource, but refer to
	 * different target objects. This is needed for the
	 * removeAllMessages(IValidator, Object) method, so that when one target
	 * object removes all of its messages, that it doesn't remove another
	 * target object's messages.
	 * 
	 * This method may return null only if object is null. Otherwise, an id
	 * which can uniquely identify a particular object must be returned. The
	 * id needs to be unique only within one particular IValidator.
	 */
	public String getTargetObjectName(Object object) {
		if (object == null)
			return null;
		if (object instanceof IFile)
			return getPortableName((IFile) object);
		return object.toString();
	}
}