/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.javascript.internal.validation.jslint;

import org.mozilla.javascript.Scriptable;

/*
 * Java object for a JSLint error
 */
public class JSLintError {

	protected int line;
	protected int character;
	protected String reason;
	protected String evidence;
	
	public JSLintError( Scriptable error ){
		
		line = ((Double)error.get("line", error)).intValue();
    	character = ((Double)error.get("character", error)).intValue();
    	
    	//newer versions of JSLint have something that causes the following to return NativeString
    	
    	reason = error.get("reason", error).toString();
    	evidence = error.get("evidence", error).toString();
		
	}
	
	public int getCharacter() {
		return character;
	}
	public String getEvidence() {
		return evidence;
	}
	public int getLine() {
		return line;
	}
	public String getReason() {
		return reason;
	}
	
	
	
}
