/*******************************************************************************
 * Copyright (c) 2009 Zend Technologies Ltd. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Zend Technologies Ltd. - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.mozilla.debug.e4.internal.jsdi;

import java.util.Map;

import org.eclipse.e4.languages.javascript.debug.connect.JSONConstants;
import org.eclipse.e4.languages.javascript.jsdi.NumberValue;

/**
 * Mozilla implementation of {@link NumberValue}
 * 
 * @since 1.0
 */
public class NumberValueImpl extends MirrorImpl implements NumberValue {

	/**
	 * The underlying value
	 */
	private Number value;

	/**
	 * Constructor
	 * 
	 * @param vm
	 * @param body
	 */
	public NumberValueImpl(VirtualMachineImpl vm, Map body) {
		this(vm, (Number) body.get(JSONConstants.VALUE));
	}

	/**
	 * Constructor
	 * 
	 * @param vm
	 * @param number
	 */
	public NumberValueImpl(VirtualMachineImpl vm, Number number) {
		super(vm);
		this.value = number;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.e4.languages.javascript.jsdi.NumberValue#value()
	 */
	public Number value() {
		return value;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.e4.languages.javascript.jsdi.Value#getValueTypeName()
	 */
	public String getValueTypeName() {
		return JSONConstants.NUMBER;
	}

	public boolean isNaN() {
		return value == null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		if (value == null)
			return JSONConstants.NAN;

		return value.toString();
	}
}
