/*******************************************************************************
 * Copyright (c) 2009 Zend Technologies Ltd. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Zend Technologies Ltd. - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.mozilla.debug.e4.internal.jsdi;

import org.eclipse.e4.languages.javascript.debug.connect.JSONConstants;
import org.eclipse.e4.languages.javascript.jsdi.UndefinedValue;

/**
 * Rhino implementation of {@link UndefinedValue}
 * 
 * @since 1.0
 */
public class UndefinedValueImpl extends MirrorImpl implements UndefinedValue {

	/**
	 * Constructor
	 * 
	 * @param vm
	 */
	public UndefinedValueImpl(VirtualMachineImpl vm) {
		super(vm);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return JSONConstants.UNDEFINED;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.e4.languages.javascript.jsdi.Value#getValueTypeName()
	 */
	public String getValueTypeName() {
		return JSONConstants.UNDEFINED;
	}
}
