/*******************************************************************************
 * Copyright (c) 2009 Zend Technologies Ltd. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Zend Technologies Ltd. - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.mozilla.debug.e4.internal.jsdi;

import java.util.Collections;
import java.util.List;

import org.eclipse.atf.mozilla.debug.e4.internal.jsdi.event.EventQueueImpl;
import org.eclipse.atf.mozilla.debug.e4.internal.jsdi.request.EventRequestManagerImpl;
import org.eclipse.atf.mozilla.debug.e4.internal.mozilla.MozillaDebuggerService;
import org.eclipse.debug.core.DebugException;
import org.eclipse.e4.languages.javascript.debug.connect.DebugSession;
import org.eclipse.e4.languages.javascript.jsdi.BooleanValue;
import org.eclipse.e4.languages.javascript.jsdi.NullValue;
import org.eclipse.e4.languages.javascript.jsdi.NumberValue;
import org.eclipse.e4.languages.javascript.jsdi.StringValue;
import org.eclipse.e4.languages.javascript.jsdi.UndefinedValue;
import org.eclipse.e4.languages.javascript.jsdi.VirtualMachine;
import org.eclipse.e4.languages.javascript.jsdi.event.EventQueue;
import org.eclipse.e4.languages.javascript.jsdi.request.EventRequestManager;

public class VirtualMachineImpl implements VirtualMachine {
	
	private DebugSession session;
	private MozillaDebuggerService mozillaDebugger;
	private ThreadReferenceImpl thread;
	private NullValue nullValue = new NullValueImpl(this);
	private UndefinedValue undefinedValue = new UndefinedValueImpl(this);
	private EventRequestManagerImpl eventRequestManager = new EventRequestManagerImpl(this);
	private EventQueue eventQueue = new EventQueueImpl(this, eventRequestManager);
	
	public VirtualMachineImpl(DebugSession debugSession) throws DebugException {
		this.session = debugSession;
		
		mozillaDebugger = new MozillaDebuggerService(this);
		thread = new ThreadReferenceImpl(this);
	}
	
	public List allScripts() {
		return mozillaDebugger.allScripts();
	}

	public List allThreads() {
		return Collections.singletonList(thread);
	}

	public String description() {
		return mozillaDebugger.getImplementationString();
	}

	public void dispose() {
		mozillaDebugger.dispose();
	}

	public EventQueue eventQueue() {
		return eventQueue;
	}

	public EventRequestManager eventRequestManager() {
		return eventRequestManager;
	}

	public BooleanValue mirrorOf(boolean bool) {
		return new BooleanValueImpl(this, bool);
	}

	public NumberValue mirrorOf(Number number) {
		return new NumberValueImpl(this, number);
	}

	public StringValue mirrorOf(String string) {
		return new StringValueImpl(this, string);
	}

	public NullValue mirrorOfNull() {
		return nullValue;
	}

	public UndefinedValue mirrorOfUndefined() {
		return undefinedValue;
	}

	public String name() {
		return description();
	}

	public void resume() {
		// TODO Auto-generated method stub

	}

	public void suspend() {
		// TODO Auto-generated method stub

	}

	public void terminate() {
		// TODO Auto-generated method stub

	}

	public String version() {
		// TODO Auto-generated method stub
		return null;
	}

}
