/*******************************************************************************
 * Copyright (c) 2009 Zend Technologies Ltd. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Zend Technologies Ltd. - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.mozilla.debug.e4.internal.mozilla;

import java.util.List;

import org.eclipse.atf.mozilla.debug.e4.internal.jsdi.VirtualMachineImpl;
import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.core.XPCOMThreadProxy;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.swt.widgets.Display;
import org.mozilla.interfaces.jsdIDebuggerService;

public class MozillaDebuggerService {

	// gateway to Mozilla debugger
	private jsdIDebuggerService debuggerService;
	private ScriptHook scriptHook;
	private ExecutionHook executionHook;
	private CallHook callHook;
	private ErrorHook errorHook;

	// helper to call Mozilla methods from Display thread
	private IXPCOMThreadProxyHelper proxyHelper;

	public MozillaDebuggerService(VirtualMachineImpl vm) throws DebugException {

		proxyHelper = new IXPCOMThreadProxyHelper() {

			public void syncExec(Runnable runnable) {
				Display.getDefault().asyncExec(runnable);
			}

			public Thread getThread() {
				return Display.getDefault().getThread();
			}
		};

		// creates proxy that invokes all methods calls in Display.syncExec 
		debuggerService = (jsdIDebuggerService) XPCOMThreadProxy.createProxy(MozillaDebugPlugin.createDebuggerService(), proxyHelper);
		debuggerService.setFlags(jsdIDebuggerService.ENABLE_NATIVE_FRAMES);
		
		scriptHook = new ScriptHook(vm);
		debuggerService.setScriptHook(scriptHook);
		
		errorHook = new ErrorHook();
		debuggerService.setErrorHook(errorHook);
		
		executionHook = new ExecutionHook();
		debuggerService.setDebuggerHook(executionHook);
		debuggerService.setBreakpointHook(executionHook);
		//debuggerService.setInterruptHook(executionHook);
		
		callHook = new CallHook();
		debuggerService.setTopLevelHook(callHook);
		debuggerService.setFunctionHook(callHook);
	}

	public void dispose() {
		debuggerService.setScriptHook(null);
		debuggerService.setErrorHook(null);
		debuggerService.setDebuggerHook(null);
		debuggerService.setBreakpointHook(null);
		debuggerService.setInterruptHook(null);
		debuggerService.setTopLevelHook(null);
		debuggerService.setFunctionHook(null);
	}

	public List allScripts() {
		return scriptHook.getScripts();
	}

	public String getImplementationString() {
		return debuggerService.getImplementationString();
	}
	
}
