/*******************************************************************************
 * Copyright (c) 2009 Zend Technologies Ltd. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Zend Technologies Ltd. - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.mozilla.debug.e4.internal.mozilla;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.atf.mozilla.debug.e4.internal.jsdi.ScriptReferenceImpl;
import org.eclipse.atf.mozilla.debug.e4.internal.jsdi.VirtualMachineImpl;
import org.mozilla.interfaces.jsdIScript;
import org.mozilla.interfaces.jsdIScriptHook;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;

public class ScriptHook implements jsdIScriptHook {

	private Map scripts;
	private VirtualMachineImpl vm;

	public void onScriptCreated(jsdIScript script) {
		scripts.put(script.getFileName(), new ScriptReferenceImpl(vm, script));
	}

	public void onScriptDestroyed(jsdIScript script) {
		scripts.remove(script.getFileName());
	}
	
	public ScriptHook(VirtualMachineImpl vm) {
		scripts = new HashMap();
		this.vm = vm;
	}


	public nsISupports queryInterface(String id) {
		return Mozilla.queryInterface(this, id);
	}
	
	public List getScripts() {
		return new ArrayList(scripts.values());
	}
}
