/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.personality.dojo.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.atf.runtime.installer.FileCopyRuntimeInstaller;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class DojoFileCopyRuntimeInstaller extends FileCopyRuntimeInstaller {
	
	protected String [] excludeDir ;
	
	protected void copyTree(File sourceDir, IPath targetPath, IWorkspaceRoot workspaceRoot, IProgressMonitor monitor ) {
		
		// Quick and dirty code not copy certain directories in Dojo. 
		// This should really be done using the extension point


		File baseLocation = new File(instanceLocationURL.getPath());
		String basePath = baseLocation.getPath();
		String sourcePath = sourceDir.getPath();
		if (!sourcePath.equals(basePath) && sourcePath.startsWith(basePath)) {
			String sourceName = sourcePath.substring(basePath.length()+1);
			for (int i=0; i<excludeDir.length; i++) {
				if (sourceName.replace("\\", "/").equals(excludeDir[i])) return;
			}
		}
		
		super.copyTree(sourceDir, targetPath, workspaceRoot, monitor );
	}

}
