/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.personality.zimbra.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.atf.personality.zimbra.core.preferences.IPreferenceConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class ZimbraCorePlugin extends AbstractUIPlugin /*implements IStartup*/ {
	//The shared instance.
	private static ZimbraCorePlugin plugin;
	//The plugin id
	public static final String PLUGIN_ID = "org.eclipse.atf.personality.zimbra.core";
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public ZimbraCorePlugin() {
		super();
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		try {
			super.start(context);
			getPreferenceStore().setDefault(IPreferenceConstants.HI_IMAGE_RESOLUTION, true);
		} catch(Exception e) {
			log(e);
		}
	}
	
	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
		resourceBundle = null;
		savePluginPreferences();
	}

	/**
	 * Returns the shared instance.
	 */
	public static ZimbraCorePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = ZimbraCorePlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		try {
			if (resourceBundle == null)
				resourceBundle = ResourceBundle.getBundle("org.eclipse.atf.personality.zimbra.core.LiquidCorePluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
		return resourceBundle;
	}
	
	public static void log(Throwable t, String message) {
		IStatus status= new Status(
			IStatus.ERROR,
			PLUGIN_ID,
			IStatus.ERROR,
			message,
			t);
		t.printStackTrace();
		getDefault().getLog().log(status);
	}

	public static void log(Throwable t) {
		t.printStackTrace();
		log(t, t.getMessage());
	}
}
