/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.personality.zimbra.core.builders;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;


public class ImageBuilderExtensionReader {

	public static final String PLUGIN_ID = "org.eclipse.atf.personality.zimbra.core";
	public static final String EXTENSION_POINT_ID = "imageProcessor";
	private static final String CLASS_ATTRIBUTE = "class";
	private static final String FOR_NATURE_ATTRIBUTE = "requiredNature";
	
	public ImageBuilderExtensionReader() {
		super();
	}
	
	protected IExtensionPoint getExtensionPoint(){
		IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
		IExtensionPoint point = extensionRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
		
		return point;
	}
	
	public IZimbraImageProcessor getImageProcessor(String forNature) {
		
		IExtensionPoint point =  getExtensionPoint();
		
		if( point == null ){
			System.err.println( "ERROR: No contributions to the " + PLUGIN_ID + "." + EXTENSION_POINT_ID + " Extension loaded!");
			return null;
		}
		
		//contributions made to the extension point
		IConfigurationElement [] configElements = point.getConfigurationElements();
		String className = null;
		String natureName = null;
		IConfigurationElement element = null;
		for( int i=0; i<configElements.length; i++ ){
			element = configElements[i];
			className = configElements[i].getAttribute(CLASS_ATTRIBUTE);
			natureName = configElements[i].getAttribute(FOR_NATURE_ATTRIBUTE);
		
			if(className != null && element != null && natureName.equals(forNature)) {
				try {
					Object obj = element.createExecutableExtension(CLASS_ATTRIBUTE);
					if(obj instanceof IZimbraImageProcessor)
						return (IZimbraImageProcessor)obj;
					else {
						System.err.println("ERROR: Extension point, " + PLUGIN_ID + "." + EXTENSION_POINT_ID + ", must have class defined that implements " + IZimbraImageProcessor.class);
					}
				}
				catch(CoreException e) {
					e.printStackTrace();
					
				}
			}
		}
		return null;
		
		
	}
}
