/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.personality.zimbra.ui.templates;

import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContextType;

public class ZimbraTemplateContextTypes extends TemplateContextType {
	public ZimbraTemplateContextTypes() {
		super();
		addResolver(new Module());
		addResolver(new CssImports());
		addResolver(new ImageResolution());
		addResolver(new WebAppName());
		addResolver(new WebAppDir());
		addResolver(new JsFileName());
		addResolver(new JsIncludes());
		
	}
	
	private class Module extends SimpleTemplateVariableResolver {
		
		/** Name of the module variable, value= {@value} */
		public static final String NAME= "module"; //$NON-NLS-1$
		
		/**
		 * Creates a new module variable
		 */
		public Module() {
			super(NAME, "The current J2EE module"); //$NON-NLS-1$
			setEvaluationString(""); //$NON-NLS-1$
		}
	}
	
	private class WebAppName extends SimpleTemplateVariableResolver {
		
		/** Name of the module variable, value= {@value} */
		public static final String NAME= "webappname"; //$NON-NLS-1$
		
		/**
		 * Creates a new module variable
		 */
		public WebAppName() {
			super(NAME, "The current web application name"); //$NON-NLS-1$
			setEvaluationString(""); //$NON-NLS-1$
		}
	}	
	
	private class WebAppDir extends SimpleTemplateVariableResolver {
		
		/** Name of the module variable, value= {@value} */
		public static final String NAME= "webappdir"; //$NON-NLS-1$
		
		/**
		 * Creates a new module variable
		 */
		public WebAppDir() {
			super(NAME, "The current web application path"); //$NON-NLS-1$
			setEvaluationString(""); //$NON-NLS-1$
		}
	}	
	
	private class JsFileName extends SimpleTemplateVariableResolver {
		
		/** Name of the module variable, value= {@value} */
		public static final String NAME= "js_filename"; //$NON-NLS-1$
		
		/**
		 * Creates a new module variable
		 */
		public JsFileName() {
			super(NAME, "The JavaScript file name"); //$NON-NLS-1$
			setEvaluationString(""); //$NON-NLS-1$
		}
	}	
	
	private class JsIncludes extends SimpleTemplateVariableResolver {
		
		/** Name of the module variable, value= {@value} */
		public static final String NAME= "jsincludes"; //$NON-NLS-1$
		
		/**
		 * Creates a new module variable
		 */
		public JsIncludes() {
			super(NAME, "The JavaScript imports"); //$NON-NLS-1$
			setEvaluationString(""); //$NON-NLS-1$
		}
	}
	
	
	
	private class CssImports extends SimpleTemplateVariableResolver {
		
		/** Name of the cssImports variable, value= {@value} */
		public static final String NAME= "cssimports"; //$NON-NLS-1$
		
		/**
		 * Creates a new cssimports variable
		 */
		public CssImports() {
			super(NAME, "The css imports"); //$NON-NLS-1$
			setEvaluationString(""); //$NON-NLS-1$
		}
	}

	private class ImageResolution extends SimpleTemplateVariableResolver {
		
		/** Name of the resolution variable, value= {@value} */
		public static final String NAME= "image_resolution"; //$NON-NLS-1$
		
		/**
		 * Creates a new module variable
		 */
		public ImageResolution() {
			super(NAME, "The resolution of the images"); //$NON-NLS-1$
			setEvaluationString(""); //$NON-NLS-1$
		}
	}
}
