/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.personality.zimbra.ui.wizard;

import org.eclipse.atf.personality.zimbra.core.preferences.IPreferenceConstants;
import org.eclipse.atf.personality.zimbra.ui.UiPlugin;
import org.eclipse.atf.personality.zimbra.ui.templates.ZimbraResolverTypes;
import org.eclipse.atf.ui.templates.TemplateRegistry;
import org.eclipse.atf.ui.util.CssUtils;
import org.eclipse.atf.ui.util.ErrorStatusDisplayUtilities;
import org.eclipse.atf.ui.util.JsUtils;
import org.eclipse.atf.ui.wizard.WebApplicationDataModel;
import org.eclipse.atf.ui.wizard.WebApplicationWizard;
import org.eclipse.atf.util.Utils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;



public class ZimbraApplicationWizard extends WebApplicationWizard {

	protected static String JSP_TEMPLATE_ID = "org.eclipse.atf.personality.zimbra.j2ee.ui.templates.zimbrajsp";
	protected static String HTML_TEMPLATE_ID = "org.eclipse.atf.personality.zimbra.j2ee.ui.templates.zimbrahtml";
	protected static String JS_TEMPLATE_ID = "org.eclipse.atf.personality.zimbra.j2ee.ui.templates.zimbrajs";
	protected static String CSS_TEMPLATE_ID = "org.eclipse.atf.personality.zimbra.j2ee.ui.templates.zimbracss";
	protected static String JSP_TEMPLATE_CONTEXT_ID = "zimbrajsp_new";
	protected static String HTML_TEMPLATE_CONTEXT_ID = "zimbrahtml_new";
	protected static String JS_TEMPLATE_CONTEXT_ID = "zimbrajs_new";
	protected static String CSS_TEMPLATE_CONTEXT_ID = "zimbracss_new";
		
	
	public ZimbraApplicationWizard() {
		super();
	    setNeedsProgressMonitor(true);
	    setDefaultPageImageDescriptor(UiPlugin.getImageDescriptor("icons/full/wizban/zimbra_wizard.gif"));
	    setWindowTitle("New Zimbra Application"); //$NON-NLS-1$
	}
	
	public boolean performFinish() {
		
//		try {
//			IProject project = getSelectedProject();
//			IFacetedProject fProject = ProjectFacetsManager.create(project);
//			IProjectFacet facet = ProjectFacetsManager.getProjectFacet("zimbra");
//			IProjectFacetVersion facetVersion = facet.getLatestVersion();
//			if(!fProject.hasProjectFacet(facetVersion)) {
//				IStatus status = facetVersion.getConstraint().check(fProject.getProjectFacets());
//				if(status.getSeverity() == IStatus.OK) {
//					fProject.installProjectFacet(facetVersion, null, null);
//				} else if(status instanceof MultiStatus){
//					ErrorDialog.openError(getShell(), "Error adding facet", "Zimbra prerequisite facet constraints were not satisfied.", (MultiStatus)status);	
//					return false;
//				}
//			}	
//		} catch(CoreException e) {
//			ErrorStatusDisplayUtilities.showErrorDialog(e, "Zimbra Application Create Error", "Error adding Zimbra facet to project", this.getClass(), "org.eclipse.atf.personality.zimbra.ui");
//			org.eclipse.atf.ui.UIPlugin.log(e);
//		}
		
		
		//@GINO: TODO Add support to add the ATF facet and Zimbra runtime if not installed
		return super.performFinish();
	}
		
	protected void addTemplateContextTypes() {
		TemplateRegistry.getInstance().addTemplateContextType(JSP_TEMPLATE_CONTEXT_ID);
	    TemplateRegistry.getInstance().addTemplateContextType(JS_TEMPLATE_CONTEXT_ID);
	    TemplateRegistry.getInstance().addTemplateContextType(HTML_TEMPLATE_CONTEXT_ID);
	    TemplateRegistry.getInstance().addTemplateContextType(CSS_TEMPLATE_CONTEXT_ID);
	}
	
	protected String getCssTemplateId() {
		return CSS_TEMPLATE_ID;
	}
	
	protected String getJsTemplateId() {
		return JS_TEMPLATE_ID;
	}
	
	protected String getJspTemplateId() {
		return JSP_TEMPLATE_ID;
	}
	
	protected String getHtmlTemplateId() {
		return HTML_TEMPLATE_ID;
	}
	
	public void addPages()
	{
	  mDataModel = new WebApplicationDataModel();
	  mFrontPage = new ZimbraApplicationFrontPage(mDataModel );
	  mJsPage = new ZimbraJsWizardPage(mDataModel);
	  mCssPage = new ZimbraCssImportWizardPage(mDataModel);
	  addPage(mFrontPage);
	  addPage(mJsPage);
	  addPage(mCssPage);
	  
	  
	}
		
	protected void setResolverEvaluationString(SimpleTemplateVariableResolver resolver) {
		
		//Module resolver
		if(resolver.getType().equals(ZimbraResolverTypes.MODULE)) {
			resolver.setEvaluationString(mDataModel.getModuleName());
		}
		//Application name resolver
		else if(resolver.getType().equals(ZimbraResolverTypes.WEBAPP_NAME)) {
			resolver.setEvaluationString(Utils.capitalize(mDataModel.getAppName().replaceAll(" ", "")));
		}
		else if(resolver.getType().equals(ZimbraResolverTypes.WEBAPP_DIR)) {
			resolver.setEvaluationString(mDataModel.getAppDir());
		}
		else if(resolver.getType().equals(ZimbraResolverTypes.JS_FILENAME)) {
			resolver.setEvaluationString(mDataModel.getJavaScriptFileName());
		}
		else if(resolver.getType().equals(ZimbraResolverTypes.JS_INCLUDES)) {
			String includeString = JsUtils.constructJsIncludeString(getSelectedProject(), mDataModel.getJavaScriptIncludes());
			resolver.setEvaluationString(includeString);
		}
		//Images resolver
		else if(resolver.getType().equals(ZimbraResolverTypes.CSS_IMPORTS)) {
			String importString = CssUtils.constructCssImportString(getSelectedProject(), mDataModel.getCssImports());
			if(mDataModel.getCssFileName() != null) {
				importString += "@import url(" + mDataModel.getCssFileName() + ");";
			}
			resolver.setEvaluationString(importString);
		}
		//Image resolution resolver
		else if(resolver.getType().equals(ZimbraResolverTypes.IMAGE_RESOLUTION)) {
			resolver.setEvaluationString(UiPlugin.getDefault().getPreferenceStore().getBoolean(IPreferenceConstants.HI_IMAGE_RESOLUTION) ? "hiRes" : "loRes");
		}
	}

}
