/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.personality.zimbra.ui.wizard;

import org.eclipse.atf.personality.zimbra.core.preferences.IPreferenceConstants;
import org.eclipse.atf.personality.zimbra.ui.UiPlugin;
import org.eclipse.atf.project.FlexibleProjectUtils;
import org.eclipse.atf.ui.wizard.CssWizardPage;
import org.eclipse.atf.ui.wizard.FileIncludeContentProvider;
import org.eclipse.atf.ui.wizard.FileIncludeFilter;
import org.eclipse.atf.ui.wizard.FileIncludeInfo;
import org.eclipse.atf.ui.wizard.FileIncludeLabelProvider;
import org.eclipse.atf.ui.wizard.FileIncludeSorter;
import org.eclipse.atf.ui.wizard.WebApplicationDataModel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ZimbraCssImportWizardPage extends CssWizardPage {

	private Button fHiResButton = null;
	private boolean isHiRes = true;
		
	public ZimbraCssImportWizardPage(WebApplicationDataModel dataModel) {
		super(dataModel); //$NON-NLS-1$
		
	}
	
	private class ImageStyleSheetSorter extends FileIncludeSorter {
		
		public int compare(Viewer viewer, Object object1, Object object2) {
			if ((object1 instanceof FileIncludeInfo) && (object2 instanceof FileIncludeInfo)) {
				FileIncludeInfo left = (FileIncludeInfo) object1;
				FileIncludeInfo right = (FileIncludeInfo) object2;
				if(isPathInSelectedFolderTree(new Path(left.getLocation())) && !isPathInSelectedFolderTree(new Path(right.getLocation())))
					return - 1;
				else if(!isPathInSelectedFolderTree(new Path(left.getLocation())) && isPathInSelectedFolderTree(new Path(right.getLocation())))
					return 1;
				else if(isPathInSelectedFolderCssTree(new Path(left.getLocation())) && !isPathInSelectedFolderCssTree(new Path(right.getLocation())))
					return -1;
				else if(!isPathInSelectedFolderCssTree(new Path(left.getLocation())) && isPathInSelectedFolderCssTree(new Path(right.getLocation())))
					return 1;
				else
					return super.compare(viewer, object1, object2);
			}
			return super.compare(viewer, object1, object2);
		}
		
		public boolean isSorterProperty(Object element, String property) {
			return true;
		}
	}
	
	private class ImageStyleSheetFilter extends FileIncludeFilter {

		public boolean select(Viewer viewer, Object parentElement, Object element) {
			String ignoreDir = isHiRes ? "loRes" : "hiRes";
			String ignoreFile = "dwtImgs.css";
			FileIncludeInfo info = (FileIncludeInfo)element;
			Path infoPath = new Path(info.getLocation());
			IPath webContentPath = getWebContentPath();
			String webContentPathString = webContentPath.segmentCount() > 0 ? webContentPath.addTrailingSeparator().toString() : "";
			int segmentCountToIgnore = webContentPath.segmentCount() + 3;
			if(infoPath.lastSegment().toLowerCase().equals(ignoreFile.toLowerCase())) {
				if(infoPath.matchingFirstSegments(new Path(fWebModuleName + "/" + webContentPathString + "zimbraAjax/js")) == segmentCountToIgnore)
					return false;
				if(infoPath.matchingFirstSegments(new Path(fWebModuleName + "/" + webContentPathString + "zimbraAjax/imgs")) == segmentCountToIgnore)
					return false;
				
			}
			String[] segments = infoPath.segments();
			for(int i=0; i<segments.length; i++) {
				if(segments[i].equals(ignoreDir)) {
					return false;
				}
			}
			return true;
		}
		
		private IPath getWebContentPath() {
			try {
				return FlexibleProjectUtils.getWebContentFolder(fFolder.getProject()).getProjectRelativePath();
			} catch(Exception e) {
				e.printStackTrace();
				return null;
			}
			
		}
	}
	
	protected void createAdvancedGroup(Composite parent) {
		
		fAdvancedButton = new Button(parent, SWT.PUSH);
		fAdvancedButton.setText("Advanced >>");
		fAdvancedButton.addSelectionListener(this);
		
		advancedOptionsGroup = new Group(parent, SWT.NONE);
		advancedOptionsGroup.setText("Css Imports");
		advancedOptionsGroup.setLayout(new GridLayout());
		advancedOptionsGroup.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		//create checkbox for hiRes images
		fHiResButton = new Button(advancedOptionsGroup, SWT.CHECK);
		fHiResButton.setText("Use high resolution images");
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		fHiResButton.setLayoutData(data);
		fHiResButton.addSelectionListener(this);
		
		//Create table
		Table table = new Table(advancedOptionsGroup, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI | SWT.CHECK | SWT.H_SCROLL | SWT.V_SCROLL);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		//Create column1
		TableColumn column1 = new TableColumn(table, SWT.NONE);
		column1.setText("Filename");
		
		//Create column2
		TableColumn column2 = new TableColumn(table, SWT.NONE);
		column2.setText("Location");
		
		GridData tableData = new GridData(GridData.FILL_BOTH);
		tableData.widthHint = 500;
		tableData.heightHint = 200;
		table.setLayoutData(tableData);
				
		configureTableResizing(advancedOptionsGroup, table, column1, column2);
		
		fTableViewer = new CheckboxTableViewer(table);
		fTableViewer.addCheckStateListener(this);
		fTableViewer.setLabelProvider(new FileIncludeLabelProvider());
		fTableViewer.setContentProvider(new FileIncludeContentProvider());
		fTableViewer.setSorter(new ImageStyleSheetSorter());
		fTableViewer.addFilter(new ImageStyleSheetFilter());
	}
	
	protected void initializeCssPageControlsContent() {
		
		isHiRes = UiPlugin.getDefault().getPreferenceStore().getBoolean(IPreferenceConstants.HI_IMAGE_RESOLUTION);
		fHiResButton.setSelection(isHiRes);
		super.initializeCssPageControlsContent();
		
	}
	
	public boolean useHiResImages() {
		return isHiRes;
	}
	
	public void widgetSelected(SelectionEvent e) {
		super.widgetSelected(e);
		Widget w = e.widget;
		if(w.equals(fHiResButton)) {
			try {
				isHiRes = fHiResButton.getSelection();
				updateTableContents();
				UiPlugin.getDefault().getPreferenceStore().setValue(IPreferenceConstants.HI_IMAGE_RESOLUTION, isHiRes);
			} catch(Exception ex) {
				ex.printStackTrace();
			}
		}
		setPageComplete(validatePage());
		
	}
	
}
