/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.personality.zimbra.ui.wizard;

import org.eclipse.atf.project.FlexibleProjectUtils;
import org.eclipse.atf.ui.wizard.FileIncludeFilter;
import org.eclipse.atf.ui.wizard.FileIncludeInfo;
import org.eclipse.atf.ui.wizard.FileIncludeSorter;
import org.eclipse.atf.ui.wizard.JsWizardPage;
import org.eclipse.atf.ui.wizard.WebApplicationDataModel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class ZimbraJsWizardPage extends JsWizardPage {

	private class JsStyleSheetSorter extends FileIncludeSorter {
		
		public int compare(Viewer viewer, Object object1, Object object2) {
			if ((object1 instanceof FileIncludeInfo) && (object2 instanceof FileIncludeInfo)) {
				FileIncludeInfo left = (FileIncludeInfo) object1;
				FileIncludeInfo right = (FileIncludeInfo) object2;
				if(isPathInSelectedFolderTree(new Path(left.getLocation())) && !isPathInSelectedFolderTree(new Path(right.getLocation())))
					return - 1;
				else if(!isPathInSelectedFolderTree(new Path(left.getLocation())) && isPathInSelectedFolderTree(new Path(right.getLocation())))
					return 1;
				else
					return super.compare(viewer, object1, object2);
			}
			return super.compare(viewer, object1, object2);
		}
		
		public boolean isSorterProperty(Object element, String property) {
			return true;
		}
	}
	
	private class JsStyleSheetFilter extends FileIncludeFilter {

		public boolean select(Viewer viewer, Object parentElement, Object element) {
			FileIncludeInfo info = (FileIncludeInfo)element;
			Path infoPath = new Path(info.getLocation());
			IPath webContentPath = getWebContentPath();
			String webContentPathString = webContentPath.segmentCount() > 0 ? webContentPath.addTrailingSeparator().toString() : "";
			int segmentCountToIgnore = webContentPath.segmentCount() + 2;
			if(infoPath.matchingFirstSegments(new Path(fWebModuleName + "/" + webContentPathString + "zimbraAjax")) == segmentCountToIgnore)
				return false;
			return true;
		}
		private IPath getWebContentPath() {
			try {
				return FlexibleProjectUtils.getWebContentFolder(fFolder.getProject()).getProjectRelativePath();
			} catch(Exception e) {
				e.printStackTrace();
				return null;
			}
		}
	}
	
	public ZimbraJsWizardPage(WebApplicationDataModel dataModel) {
		super(dataModel); //$NON-NLS-1$
		
	}
	
	protected void createAdvancedGroup(Composite parent) {
		super.createAdvancedGroup(parent);
		fTableViewer.setSorter(new JsStyleSheetSorter());
		fTableViewer.addFilter(new JsStyleSheetFilter());
	}
	
	
	

}
