package org.eclipse.atf.rest.core.internal;

import java.util.ArrayList;
import java.util.List;

public class JSONEventsFactory implements JSONEventProvider {

	private static JSONEventsFactory instance;
	
	private List<JSONEventProvider> fProviders = new ArrayList<JSONEventProvider>();
	private List<JSONListener>fListeners = new ArrayList<JSONListener>();
	
	public void addProvider(JSONEventProvider provider) {
		fProviders.add(provider);
		JSONListener[] listeners = fListeners.toArray(new JSONListener[0]);
		for (int i = 0; i < listeners.length; i++) {
			provider.addListener(listeners[i]);
		}
	}
	
	public void removeProvider(JSONEventProvider provider) {
		fProviders.remove(provider);
		JSONListener[] listeners = fListeners.toArray(new JSONListener[0]);
		for (int i = 0; i < listeners.length; i++) {
			provider.removeListener(listeners[i]);
		}
	}
	
	@Override
	public void addListener(JSONListener listener) {
		fListeners.add(listener);
		JSONEventProvider[] providers = fProviders.toArray(new JSONEventProvider[0]);
		for (int i = 0; i < providers.length; i++) {
			providers[i].addListener(listener);
		}
	}

	@Override
	public void removeListener(JSONListener listener) {
		fListeners.remove(listener);
		JSONEventProvider[] providers = fProviders.toArray(new JSONEventProvider[0]);
		for (int i = 0; i < providers.length; i++) {
			providers[i].removeListener(listener);
		}
	}

	public static JSONEventsFactory getDefault() {
		if (instance == null) {
			instance = new JSONEventsFactory();
		}
		return instance;
	}

}
