/** Zend Studio jQuery source.
 *
 * http://jquery.com/
 * jQuery 1.3.2
 */

/** <p>
 * This function accepts a string containing a CSS selector which is then used to match a set of elements.</p>
 * <p>
 * The core functionality of jQuery centers around this function. Everything in jQuery is based upon this, or uses this in some way. The most basic use of this function is to pass in an expression (usually consisting of CSS), which then finds all matching elements.

By default, if no context is specified, $() looks for DOM elements within the context of the current HTML document. If you do specify a context, such as a DOM element or jQuery object, the expression will be matched against the contents of that context.

See &lt;a href='Selectors'&gt;Selectors&lt;/a&gt; for the allowed CSS syntax for expressions. <br>
</p>
 * 
 * 
 * Example:
 * Finds all p elements that are children of a div element.
 * <pre>$("div &gt; p").css("border", "1px solid gray");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;one&lt;/p&gt; &lt;div&gt;&lt;p&gt;two&lt;/p&gt;&lt;/div&gt; &lt;p&gt;three&lt;/p&gt;</pre>
 * 
 * Result:
 * <pre>[ &lt;p&gt;two&lt;/p&gt; ]</pre>
 * 
 * Example:
 * Finds all inputs of type radio within the first form in the document.
 * <pre>$("input:radio", document.forms[0]);</pre>
 * 
 * Example:
 * Finds all div elements within an XML document from an AJAX response.
 * <pre>$("div", xml.responseXML);</pre>
 * 
 * 
 * @param expression A string of characters.String. An expression to search with..
 * @param context Element, jQuery. A DOM Element, Document or jQuery to use as context.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
function jQuery(expression, context) {
  return new jQuery();
};

/** <p>
 * This function accepts a string containing a CSS selector which is then used to match a set of elements.</p>
 * <p>
 * The core functionality of jQuery centers around this function. Everything in jQuery is based upon this, or uses this in some way. The most basic use of this function is to pass in an expression (usually consisting of CSS), which then finds all matching elements.

By default, if no context is specified, $() looks for DOM elements within the context of the current HTML document. If you do specify a context, such as a DOM element or jQuery object, the expression will be matched against the contents of that context.

See &lt;a href='Selectors'&gt;Selectors&lt;/a&gt; for the allowed CSS syntax for expressions. <br>
</p>
 * 
 * 
 * Example:
 * Finds all p elements that are children of a div element.
 * <pre>$("div &gt; p").css("border", "1px solid gray");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;one&lt;/p&gt; &lt;div&gt;&lt;p&gt;two&lt;/p&gt;&lt;/div&gt; &lt;p&gt;three&lt;/p&gt;</pre>
 * 
 * Result:
 * <pre>[ &lt;p&gt;two&lt;/p&gt; ]</pre>
 * 
 * Example:
 * Finds all inputs of type radio within the first form in the document.
 * <pre>$("input:radio", document.forms[0]);</pre>
 * 
 * Example:
 * Finds all div elements within an XML document from an AJAX response.
 * <pre>$("div", xml.responseXML);</pre>
 * 
 * 
 * @param expression A string of characters.String. An expression to search with..
 * @param context Element, jQuery. A DOM Element, Document or jQuery to use as context.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
function $(expression, context) {
  return new jQuery();
}; 
window.$ = $;

window.jQuery = jQuery;

/** <p>
 * Create DOM elements on-the-fly from the provided String of raw HTML.</p>
 * <p>
 * You can pass in plain HTML Strings written by hand, create them using some template engine or plugin, or load them via AJAX. There are limitations when creating input elements, see the second example. Also when passing strings that may include slashes (such as an image path), escape the slashes.  When creating single elements use the closing tag or XHTML format.  For example, to create a span use $("&lt;span/&gt;") or $("&lt;span&gt;&lt;/span&gt;") instead of without the closing slash/tag.<br>
</p>
 * 
 * 
 * Example:
 * Creates a div element (and all of its contents) dynamically, and appends it to the body element. Internally, an element is created and its innerHTML property set to the given markup. It is therefore both quite flexible and limited.
 * <pre>$("&lt;div&gt;&lt;p&gt;Hello&lt;/p&gt;&lt;/div&gt;").appendTo("body")</pre>
 * 
 * Example:
 * Do not create &amp;lt;input&amp;gt;-Elements without a type-attribute, due to Microsofts read/write-once-rule for the type-attribute of &amp;lt;input&amp;gt;-elements, see this [http://msdn2.microsoft.com/en-us/library/ms534700.aspx official statement] for details.
 * <pre>// Does NOT work in IE:
$("&lt;input/&gt;").attr("type", "checkbox");
// Does work in IE:
$("&lt;input type='checkbox'/&gt;");</pre>
 * 
 * 
 * @param html A string of characters.String. A string of HTML to create on the fly..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
function jQuery(html) {
  return new jQuery();
};

/** <p>
 * Create DOM elements on-the-fly from the provided String of raw HTML.</p>
 * <p>
 * You can pass in plain HTML Strings written by hand, create them using some template engine or plugin, or load them via AJAX. There are limitations when creating input elements, see the second example. Also when passing strings that may include slashes (such as an image path), escape the slashes.  When creating single elements use the closing tag or XHTML format.  For example, to create a span use $("&lt;span/&gt;") or $("&lt;span&gt;&lt;/span&gt;") instead of without the closing slash/tag.<br>
</p>
 * 
 * 
 * Example:
 * Creates a div element (and all of its contents) dynamically, and appends it to the body element. Internally, an element is created and its innerHTML property set to the given markup. It is therefore both quite flexible and limited.
 * <pre>$("&lt;div&gt;&lt;p&gt;Hello&lt;/p&gt;&lt;/div&gt;").appendTo("body")</pre>
 * 
 * Example:
 * Do not create &amp;lt;input&amp;gt;-Elements without a type-attribute, due to Microsofts read/write-once-rule for the type-attribute of &amp;lt;input&amp;gt;-elements, see this [http://msdn2.microsoft.com/en-us/library/ms534700.aspx official statement] for details.
 * <pre>// Does NOT work in IE:
$("&lt;input/&gt;").attr("type", "checkbox");
// Does work in IE:
$("&lt;input type='checkbox'/&gt;");</pre>
 * 
 * 
 * @param html A string of characters.String. A string of HTML to create on the fly..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
function $(html) {
  return new jQuery();
}; 
/** <p>
 * Wrap jQuery functionality around a single or multiple DOM Element(s).</p>
 * <p>
 * This function also accepts XML Documents and Window objects as valid arguments (even though they are not DOM Elements).<br>
</p>
 * 
 * 
 * Example:
 * Sets the background color of the page to black.
 * <pre>$(document.body).css( "background", "black" );</pre>
 * 
 * Example:
 * Hides all the input elements within a form.
 * <pre>$(myForm.elements).hide()</pre>
 * 
 * 
 * @param elements Element, Array&lt;Element&gt;. DOM element(s) to be encapsulated by a jQuery object..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
function jQuery(elements) {
  return new jQuery();
};

/** <p>
 * Wrap jQuery functionality around a single or multiple DOM Element(s).</p>
 * <p>
 * This function also accepts XML Documents and Window objects as valid arguments (even though they are not DOM Elements).<br>
</p>
 * 
 * 
 * Example:
 * Sets the background color of the page to black.
 * <pre>$(document.body).css( "background", "black" );</pre>
 * 
 * Example:
 * Hides all the input elements within a form.
 * <pre>$(myForm.elements).hide()</pre>
 * 
 * 
 * @param elements Element, Array&lt;Element&gt;. DOM element(s) to be encapsulated by a jQuery object..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
function $(elements) {
  return new jQuery();
};
/** <p>
 * A shorthand for $(document).ready().</p>
 * <p>
 * Allows you to bind a function to be executed when the DOM document has finished loading. This function behaves just like $(document).ready(), in that it should be used to wrap other $() operations on your page that depend on the DOM being ready to be operated on. While this function is, technically, chainable - there really isn't much use for chaining against it.

You can have as many $(document).ready events on your page as you like.

See ready(Function) for details about the ready event. <br>
</p>
 * 
 * 
 * Example:
 * Executes the function when the DOM is ready to be used.
 * <pre>$(function(){
  // Document is ready
});</pre>
 * 
 * Example:
 * Uses both the shortcut for $(document).ready() and the argument to write failsafe jQuery code using the $ alias, without relying on the global alias.
 * <pre>jQuery(function($) {
  // Your code using failsafe $ alias here...
});</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute when the DOM is ready..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
function jQuery(callback) {
  return new jQuery();
};

/** <p>
 * A shorthand for $(document).ready().</p>
 * <p>
 * Allows you to bind a function to be executed when the DOM document has finished loading. This function behaves just like $(document).ready(), in that it should be used to wrap other $() operations on your page that depend on the DOM being ready to be operated on. While this function is, technically, chainable - there really isn't much use for chaining against it.

You can have as many $(document).ready events on your page as you like.

See ready(Function) for details about the ready event. <br>
</p>
 * 
 * 
 * Example:
 * Executes the function when the DOM is ready to be used.
 * <pre>$(function(){
  // Document is ready
});</pre>
 * 
 * Example:
 * Uses both the shortcut for $(document).ready() and the argument to write failsafe jQuery code using the $ alias, without relying on the global alias.
 * <pre>jQuery(function($) {
  // Your code using failsafe $ alias here...
});</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute when the DOM is ready..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
function $(callback) {
  return new jQuery();
};

/** <p>
 * Execute a function within the context of every matched element.</p>
 * <p>
 * This means that every time the passed-in function is executed (which is once for every element matched) the 'this' keyword points to the specific DOM element.

Additionally, the function, when executed, is passed a single argument representing the position of the element in the matched set (integer, zero-index).

Returning 'false' from within the each function completely stops the loop through all of the elements (this is like using a 'break' with a normal loop). Returning 'true' from within the loop skips to the next iteration (this is like using a 'continue' with a normal loop). <br>
</p>
 * 
 * 
 * Example:
 * Iterates over three divs and sets their color property.
 * <pre>
    $(document.body).click(function () {
      $("div").each(function (i) {
        if (this.style.color != "blue") {
          this.style.color = "blue";
        } else {
          this.style.color = "";
        }
      });
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;Click here&lt;/div&gt;

  &lt;div&gt;to iterate through&lt;/div&gt;
  &lt;div&gt;these divs.&lt;/div&gt;</pre>
 * 
 * Example:
 * If you want to have the jQuery object instead of the regular DOM element, use the $(this) function, for example:
 * <pre>
    $("span").click(function () {
      $("li").each(function(){
        $(this).toggleClass("example");
      });
    });

</pre>
 * 
 * HTML:
 * <pre>To do list: &lt;span&gt;(click here to change)&lt;/span&gt;
  &lt;ul&gt;
    &lt;li&gt;Eat&lt;/li&gt;
    &lt;li&gt;Sleep&lt;/li&gt;

    &lt;li&gt;Be merry&lt;/li&gt;
  &lt;/ul&gt;</pre>
 * 
 * Example:
 * You can use 'return' to break out of each() loops early.
 * <pre>
    $("button").click(function () {
      $("div").each(function (index, domEle) {
        // domEle == this
        $(domEle).css("backgroundColor", "yellow"); 
        if ($(this).is("#stop")) {
          $("span").text("Stopped at div index #" + index);
          return false;
        }
      });
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Change colors&lt;/button&gt; 
  &lt;span&gt;&lt;/span&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div id="stop"&gt;Stop here&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The callback to execute for each matched element.

&lt;pre&gt;function callback(index, domElement) {
  this; // this == domElement
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.each = function (callback) {
  return new jQuery();
};
/** <p>
 * The number of elements in the jQuery object.</p>
 * <p>
 * This returns the same number as the '&lt;a href='Core/length'&gt;length&lt;/a&gt;' property of the jQuery object.<br>
</p>
 * 
 * 
 * Example:
 * Count the divs.  Click to add more.
 * <pre> 
    $(document.body).click(function () {
      $(document.body).append($("&lt;div&gt;"));
      var n = $("div").size();
      $("span").text("There are " + n + " divs." +
                     "Click to add more.");
    }).click(); // trigger the click to start

</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;&lt;/span&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @return A valid numeric.Number
 * @since 1.0
 */
jQuery.size = function () {
  return 0;
};
/** <p>
 * The number of elements in the jQuery object.</p>
 * <p>
 * In a The number of elements currently matched. The &lt;a href='Core/size'&gt;size&lt;/a&gt; function will return the same value.<br>
</p>
 * 
 * 
 * Example:
 * Count the divs.  Click to add more.
 * <pre> 
    $(document.body).click(function () {
      $(document.body).append($("&lt;div&gt;"));
      var n = $("div").length;
      $("span").text("There are " + n + " divs." +
                     "Click to add more.");
    }).trigger('click'); // trigger the click to start

</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;&lt;/span&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @return A valid numeric.Number
 */
jQuery.length = 0;
/** <p>
 * Reduce the set of matched elements to a single element.</p>
 * <p>
 * The position of the element in the set of matched elements starts at 0 and goes to length - 1.<br>
</p>
 * 
 * 
 * Example:
 * Reduces the selection to the second selected element.
 * <pre>$("p").eq(1)</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;This is just a test.&lt;/p&gt;&lt;p&gt;So is this&lt;/p&gt;</pre>
 * 
 * Result:
 * <pre>[ &lt;p&gt;So is this&lt;/p&gt; ]</pre>
 * 
 * 
 * @param position A valid numeric.Number. The index of the element to select..
 * @return A jQuery object.jQuery
 * @since 1.0
 * @removed 1.2
 * @deprecated &lt;a href='Traversing/slice'&gt;slice&lt;/a&gt;
 */
jQuery.eq = function (position) {
  return new jQuery();
};
/** <p>
 * Access all matched DOM elements.</p>
 * <p>
 * This serves as a backwards-compatible way of accessing all matched elements (other than the jQuery object itself, which is, in fact, an array of elements).

It is useful if you need to operate on the DOM elements themselves instead of using built-in jQuery functions. <br>
</p>
 * 
 * 
 * Example:
 * Selects all divs in the document and returns the DOM Elements as an Array, then uses the built-in reverse-method to reverse that array.
 * <pre>

    function disp(divs) {
      var a = [];
      for (var i = 0; i &lt; divs.length; i++) {
        a.push(divs[i].innerHTML);
      }
      $("span").text(a.join(" "));
    }
    
    disp( $("div").get().reverse() );
</pre>
 * 
 * HTML:
 * <pre>Reversed - &lt;span&gt;&lt;/span&gt;

  &lt;div&gt;One&lt;/div&gt;
  &lt;div&gt;Two&lt;/div&gt;
  &lt;div&gt;Three&lt;/div&gt;</pre>
 * 
 * 
 * @return An Array of DOM Elements.Array&lt;Element&gt;
 * @since 1.0
 */
jQuery.get = function () {
  return [];
};
/** <p>
 * Access a single matched DOM element at a specified index in the matched set.</p>
 * <p>
 * This allows you to extract the actual DOM element and operate on it directly without necessarily using jQuery functionality on it. This function called as $(this).get(0) is the equivalent of using square bracket notation on the jQuery object itself like $(this)[0].<br>
</p>
 * 
 * 
 * Example:
 * Gives the tag name of the element clicked on.
 * <pre>

    $("*", document.body).click(function (e) {
      e.stopPropagation();
      var domEl = $(this).get(0);
      $("span:first").text("Clicked on - " + domEl.tagName);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;&amp;nbsp;&lt;/span&gt;
  &lt;p&gt;In this paragraph is an &lt;span&gt;important&lt;/span&gt; section&lt;/p&gt;

  &lt;div&gt;&lt;input type="text" /&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param index A valid numeric.Number. Access the element in the Nth position..
 * @return The Javascript object representation of a DOM Element.Element
 * @since 1.0
 */
jQuery.get = function (index) {
  return new Element();
};
/** <p>
 * Searches every matched element for the object and returns the index of the element, if found, starting with zero.</p>
 * <p>
 * Returns -1 if the object wasn't found.<br>
</p>
 * 
 * 
 * Example:
 * On click, returns the index (based zero) of that div in the page.
 * <pre>
    $("div").click(function () {
      // this is the dom element clicked
      var index = $("div").index(this);
      $("span").text("That was div index #" + index);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;Click a div!&lt;/span&gt;
  &lt;div&gt;First div&lt;/div&gt;
  &lt;div&gt;Second div&lt;/div&gt;

  &lt;div&gt;Third div&lt;/div&gt;</pre>
 * 
 * Example:
 * Returns the index for the element with ID foobar.
 * <pre>$("*").index( $('#foobar')[0] )</pre>
 * 
 * HTML:
 * <pre>&lt;div id="foobar"&gt;&lt;b&gt;&lt;/b&gt;&lt;span id="foo"&gt;&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Returns the index for the element with ID foo within another element.
 * <pre>$("*").index( $('#foo')[0] )</pre>
 * 
 * HTML:
 * <pre>&lt;div id="foobar"&gt;&lt;b&gt;&lt;/b&gt;&lt;span id="foo"&gt;&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Returns the index for the element clicked within a collection.
 * <pre>var mainNavLinks = $('ul#mainNav li a');
mainNavLinks.click(function(){alert(mainNavLinks.index(this)0;});</pre>
 * 
 * Example:
 * Returns -1, as there is no element with ID bar.
 * <pre>$("*").index( $('#bar')[0] )</pre>
 * 
 * HTML:
 * <pre>&lt;div id="foobar"&gt;&lt;b&gt;&lt;/b&gt;&lt;span id="foo"&gt;&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param subject Element . Object to search for..
 * @return A valid numeric.Number
 * @since 1.0
 */
jQuery.index = function (subject) {
  return 0;
};
/** <p>
 * Extends the jQuery element set to provide new methods (used to make a typical jQuery plugin).</p>
 * <p>
 * Can be used to add functions into the to add &lt;a href='Plugins/Authoring'&gt;plugin methods (plugins)&lt;/a&gt;. <br>
</p>
 * 
 * 
 * Example:
 * Adds two plugin methods.
 * <pre>jQuery.fn.extend({
  check: function() {
    return this.each(function() { this.checked = true; });
  },
  uncheck: function() {
    return this.each(function() { this.checked = false; });
  }
});</pre>
 * 
 * Result:
 * <pre>$("input[@type=checkbox]").check();
$("input[@type=radio]").uncheck();</pre>
 * 
 * 
 * @param object A simple Javascript object..Object. The object that will be merged into the jQuery object..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.fn.extend = function (object) {
  return new jQuery();
};
/** <p>
 * Extends the jQuery object itself.</p>
 * <p>
 * Can be used to add functions into the jQuery namespace. See &lt;a href='Core/jQuery.fn.extend'&gt;jQuery.fn.extend&lt;/a&gt; for more information on using this method to add &lt;a href='Plugins/Authoring'&gt;Plugins&lt;/a&gt;.<br>
</p>
 * 
 * 
 * Example:
 * Adds two functions into the jQuery namespace.
 * <pre>jQuery.extend({
  min: function(a, b) { return a &lt; b ? a : b; },
  max: function(a, b) { return a &gt; b ? a : b; }
});</pre>
 * 
 * Result:
 * <pre>jQuery.min(2,3); // =&gt; 2
jQuery.max(4,5); // =&gt; 5</pre>
 * 
 * 
 * @param object A simple Javascript object..Object. The object that will be merged into the jQuery object..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.extend = function (object) {
  return new jQuery();
};
/** <p>
 * Run this function to give control of the $ variable back to whichever library first implemented it.</p>
 * <p>
 * This helps to make sure that jQuery doesn't conflict with the $ object of other libraries.

By using this function, you will only be able to access jQuery using the 'jQuery' variable. For example, where you used to do $("div p"), you now must do jQuery("div p").<br>
</p>
 * 
 * 
 * Example:
 * Maps the original object that was referenced by $ back to $.
 * <pre>jQuery.noConflict();
// Do something with jQuery
jQuery("div p").hide();
// Do something with another library's $()
$("content").style.display = 'none';</pre>
 * 
 * Example:
 * Reverts the $ alias and then creates and executes a function to provide the $ as a jQuery alias inside the functions scope. Inside the function the original $ object is not available. This works well for most plugins that don't rely on any other library.
 * <pre>jQuery.noConflict();
(function($) { 
  $(function() {
    // more code using $ as alias to jQuery
  });
})(jQuery);
// other code using $ as an alias to the other library</pre>
 * 
 * Example:
 * Creates a different alias instead of jQuery to use in the rest of the script.
 * <pre>var j = jQuery.noConflict();
// Do something with jQuery
j("div p").hide();
// Do something with another library's $()
$("content").style.display = 'none';</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.noConflict = function () {
  return new jQuery();
};
/** <p>
 * Revert control of both the $ and jQuery variables to their original owners. '''Use with discretion.'''</p>
 * <p>
 * This is a more-extreme version of the simple &lt;a href='Core/jQuery.noConflict'&gt;noConflict&lt;/a&gt; method, as this one will completely undo what jQuery has introduced. This is to be used in an extreme case where you'd like to embed jQuery into a high-conflict environment. '''NOTE:''' It's very likely that plugins won't work after this particular method has been called.<br>
</p>
 * 
 * 
 * Example:
 * Completely move jQuery to a new namespace in another object.
 * <pre>var dom = {};
dom.query = jQuery.noConflict(true);</pre>
 * 
 * Result:
 * <pre>// Do something with the new jQuery
dom.query("div p").hide();
// Do something with another library's $()
$("content").style.display = 'none';
// Do something with another version of jQuery
jQuery("div &gt; p").hide();</pre>
 * 
 * 
 * @param extreme true or false.Boolean. Set to true to enable the extreme rollback of jQuery and it's variables..
 * @return A jQuery object.jQuery
 * @since 1.1.4
 */
jQuery.noConflict = function (extreme) {
  return new jQuery();
};

/** <p>
 * Access a property on the first matched element. This method makes it easy to retrieve a property value from the first matched element. If the element does not have an attribute with such a name, undefined is returned.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Finds the title attribute of the first &lt;em&gt; in the page.
 * <pre>

    var title = $("em").attr("title");
    $("div").text(title);
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Once there was a &lt;em title="huge, gigantic"&gt;large&lt;/em&gt; dinosaur...
  &lt;/p&gt;

  The title of the emphasis is:&lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param name A string of characters.String. The name of the property to access..
 * @return A simple Javascript object..Object
 */
jQuery.attr = function (name) {
  return new Object();
};
/** <p>
 * Set a key/value object as properties to all matched elements.</p>
 * <p>
 * This serves as the best way to set a large number of properties on all matched elements. Note that you must use 'className' as key if you want to set the class-Attribute. Or use .addClass( class ) or .removeClass( class ).<br>
</p>
 * 
 * 
 * Example:
 * Set some attributes for all &lt;img&gt;s in the page.
 * <pre>
    $("img").attr({ 
          src: "/images/hat.gif",
          title: "jQuery",
          alt: "jQuery Logo"

        });
    $("div").text($("img").attr("alt"));
</pre>
 * 
 * HTML:
 * <pre>&lt;img /&gt;
  &lt;img /&gt;
  &lt;img /&gt;

  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param properties A Javascript object that contains key/value pairs in the form of properties and values.Map. Key/value pairs to set as object properties..
 * @return A jQuery object.jQuery
 */
jQuery.attr = function (properties) {
  return new jQuery();
};
/** <p>
 * Set a single property to a value, on all matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Disables buttons greater than the 0th button.
 * <pre>$("button:gt(0)").attr("disabled","disabled");</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;0th Button&lt;/button&gt;

  &lt;button&gt;1st Button&lt;/button&gt;
  &lt;button&gt;2nd Button&lt;/button&gt;</pre>
 * 
 * 
 * @param key A string of characters.String. The name of the property to set..
 * @param value A simple Javascript object..Object. The value to set the property to..
 * @return A jQuery object.jQuery
 */
jQuery.attr = function (key, value) {
  return new jQuery();
};
/** <p>
 * Set a single property to a computed value, on all matched elements.</p>
 * <p>
 * Instead of supplying a string value as described  &lt;a href='#keyvalue'&gt;above&lt;/a&gt;, a function is provided that computes the value.<br>
</p>
 * 
 * 
 * Example:
 * Sets id for divs based on the position in the page.
 * <pre>

    $("div").attr("id", function (arr) {
          return "div-id" + arr[0];
        })
        .each(function () {
          $("span", this).html("(ID = '&lt;b&gt;" + this.id + "&lt;/b&gt;')");
        });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;Zero-th &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;First &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;Second &lt;span&gt;&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Sets src attribute from title attribute on the image.
 * <pre>

    $("img").attr("src", function() { 
          return "/images/" + this.title; 
        });
</pre>
 * 
 * HTML:
 * <pre>&lt;img title="hat.gif"/&gt;
  &lt;img title="hat-old.gif"/&gt;

  &lt;img title="hat2-old.gif"/&gt;</pre>
 * 
 * 
 * @param key A string of characters.String. The name of the property to set..
 * @param fn A reference to a Javascript function.Function. A function returning the value to set. Scope: Current element, argument: Index of current element
&lt;pre&gt;function callback(indexArray) {
  // indexArray[0] == position in the jQuery object
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.attr = function (key, fn) {
  return new jQuery();
};
/** <p>
 * Remove an attribute from each of the matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Clicking the button enables the input next to it.
 * <pre>
    $("button").click(function () {
      $(this).next().removeAttr("disabled")
             .focus()
             .val("editable now");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Enable&lt;/button&gt;

  &lt;input type="text" disabled="disabled" value="can't edit this" /&gt;</pre>
 * 
 * 
 * @param name A string of characters.String. The name of the property to remove..
 * @return A jQuery object.jQuery
 */
jQuery.removeAttr = function (name) {
  return new jQuery();
};
/** <p>
 * Adds the specified class(es) to each of the set of matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Adds the class 'selected' to the matched elements.
 * <pre>$("p:last").addClass("selected");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;p&gt;and&lt;/p&gt;
  &lt;p&gt;Goodbye&lt;/p&gt;</pre>
 * 
 * Example:
 * Adds the classes 'selected' and 'highlight' to the matched elements.
 * <pre>$("p:last").addClass("selected highlight");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;p&gt;and&lt;/p&gt;
  &lt;p&gt;Goodbye&lt;/p&gt;</pre>
 * 
 * 
 * @param class A string of characters.String. One or more CSS classes to add to the elements, these are separated by spaces..
 * @return A jQuery object.jQuery
 */
jQuery.addClass = function (class) {
  return new jQuery();
};
/** <p>
 * Removes all or the specified class(es) from the set of matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Remove the class 'blue' from the matched elements.
 * <pre>$("p:even").removeClass("blue");</pre>
 * 
 * HTML:
 * <pre>&lt;p class="blue under"&gt;Hello&lt;/p&gt;
  &lt;p class="blue under highlight"&gt;and&lt;/p&gt;
  &lt;p class="blue under"&gt;then&lt;/p&gt;

  &lt;p class="blue under"&gt;Goodbye&lt;/p&gt;</pre>
 * 
 * Example:
 * Remove the class 'blue' and 'under' from the matched elements.
 * <pre>$("p:odd").removeClass("blue under");</pre>
 * 
 * HTML:
 * <pre>&lt;p class="blue under"&gt;Hello&lt;/p&gt;

  &lt;p class="blue under highlight"&gt;and&lt;/p&gt;
  &lt;p class="blue under"&gt;then&lt;/p&gt;
  &lt;p class="blue under"&gt;Goodbye&lt;/p&gt;</pre>
 * 
 * Example:
 * Remove all the classes from the matched elements.
 * <pre>$("p:eq(1)").removeClass();</pre>
 * 
 * HTML:
 * <pre>&lt;p class="blue under"&gt;Hello&lt;/p&gt;
  &lt;p class="blue under highlight"&gt;and&lt;/p&gt;
  &lt;p class="blue under"&gt;then&lt;/p&gt;

  &lt;p class="blue under"&gt;Goodbye&lt;/p&gt;</pre>
 * 
 * 
 * @param class String ''(optional)''. One or more CSS classes to remove from the elements, these are separated by spaces..
 * @return A jQuery object.jQuery
 */
jQuery.removeClass = function (class) {
  return new jQuery();
};
/** <p>
 * Adds the specified class if it is not present, removes the specified class if it is present.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Toggle the class 'highlight' when a paragraph is clicked.
 * <pre>
    $("p").click(function () {
      $(this).toggleClass("highlight");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p class="blue"&gt;Click to toggle&lt;/p&gt;

  &lt;p class="blue highlight"&gt;highlight&lt;/p&gt;
  &lt;p class="blue"&gt;on these&lt;/p&gt;
  &lt;p class="blue"&gt;paragraphs&lt;/p&gt;</pre>
 * 
 * 
 * @param class A string of characters.String. A CSS class to toggle on the elements..
 * @return A jQuery object.jQuery
 */
jQuery.toggleClass = function (class) {
  return new jQuery();
};
/** <p>
 * Get the html contents (innerHTML) of the first matched element. This property is not available on XML documents (although it will work for XHTML documents).</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Click a paragraph to convert it from html to text.
 * <pre>

    $("p").click(function () {
      var htmlStr = $(this).html();
      $(this).text(htmlStr);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    &lt;b&gt;Click&lt;/b&gt; to change the &lt;span id="tag"&gt;html&lt;/span&gt;

  &lt;/p&gt;
  &lt;p&gt;
    to a &lt;span id="text"&gt;text&lt;/span&gt; node.
  &lt;/p&gt;
  &lt;p&gt;

    This &lt;button name="nada"&gt;button&lt;/button&gt; does nothing.
  &lt;/p&gt;</pre>
 * 
 * 
 * @return A string of characters.String
 */
jQuery.html = function () {
  return "";
};
/** <p>
 * Set the html contents of every matched element. This property is not available on XML documents (although it will work for XHTML documents).</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Add some html to each div.
 * <pre>$("div").html("&lt;span class='red'&gt;Hello &lt;b&gt;Again&lt;/b&gt;&lt;/span&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;Hello&lt;/span&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Add some html to each div then immediately do further manipulations to the inserted html.
 * <pre>

    $("div").html("&lt;b&gt;Wow!&lt;/b&gt; Such excitement...");
    $("div b").append(document.createTextNode("!!!"))
              .css("color", "red");

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param val string. Set the html contents to the specified value..
 * @return A jQuery object.jQuery
 */
jQuery.html = function (val) {
  return new jQuery();
};
/** <p>
 * Get the combined text contents of all matched elements.</p>
 * <p>
 * The result is a string that contains the combined text contents of all matched elements. This method works on both HTML and XML documents.<br>
</p>
 * 
 * 
 * Example:
 * Find the text in the first paragraph (stripping out the html), then set the html of the last paragraph to show it is just text (the red bold is gone).
 * <pre>

    var str = $("p:first").text();
    $("p:last").html(str);
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;&lt;b&gt;Test&lt;/b&gt; Paragraph.&lt;/p&gt;

  &lt;p&gt;&lt;/p&gt;</pre>
 * 
 * 
 * @return A string of characters.String
 */
jQuery.text = function () {
  return "";
};
/** <p>
 * Set the text contents of all matched elements.</p>
 * <p>
 * Similar to html(), but escapes HTML (replace "&lt;" and "&gt;" with their HTML entities).<br>
</p>
 * 
 * 
 * Example:
 * Add text to the paragraph (notice the bold tag is escaped).
 * <pre>$("p").text("&lt;b&gt;Some&lt;/b&gt; new text.");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Test Paragraph.&lt;/p&gt;</pre>
 * 
 * 
 * @param val A string of characters.String. The text value to set the contents of the element to..
 * @return A jQuery object.jQuery
 */
jQuery.text = function (val) {
  return new jQuery();
};
/** <p>
 * Get the content of the value attribute of the first matched element.</p>
 * <p>
 * In jQuery 1.2, a value is now returned for all elements, including selects. For multiple selects an array of values is returned.

For older versions of jQuery use the [http://www.malsup.com/jquery/form/#fields fieldValue function of the Form Plugin].<br>
</p>
 * 
 * 
 * Example:
 * Get the single value from a single select and an array of values from a multiple select and display their values.
 * <pre>
    function displayVals() {
      var singleValues = $("#single").val();
      var multipleValues = $("#multiple").val() || [];
      $("p").html("&lt;b&gt;Single:&lt;/b&gt; " + 
                  singleValues +
                  " &lt;b&gt;Multiple:&lt;/b&gt; " + 
                  multipleValues.join(", "));
    }

    $("select").change(displayVals);
    displayVals();

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;&lt;/p&gt;
  &lt;select id="single"&gt;
    &lt;option&gt;Single&lt;/option&gt;
    &lt;option&gt;Single2&lt;/option&gt;

  &lt;/select&gt;
  &lt;select id="multiple" multiple="multiple"&gt;
    &lt;option selected="selected"&gt;Multiple&lt;/option&gt;
    &lt;option&gt;Multiple2&lt;/option&gt;

    &lt;option selected="selected"&gt;Multiple3&lt;/option&gt;
  &lt;/select&gt;</pre>
 * 
 * Example:
 * Find the value of an input box.
 * <pre>
    $("input").keyup(function () {
      var value = $(this).val();
      $("p").text(value);
    }).keyup();
</pre>
 * 
 * HTML:
 * <pre>&lt;input type="text" value="some text"/&gt;
  &lt;p&gt;&lt;/p&gt;</pre>
 * 
 * 
 * @return String, Array
 * @since 1.0
 */
jQuery.val = function () {
  return ;
};
/** <p>
 * Set the value attribute of every matched element.</p>
 * <p>
 * In jQuery 1.2, this is also able to set the value of select elements, but selecting the appropriate options.<br>
</p>
 * 
 * 
 * Example:
 * Set the value of an input box.
 * <pre>

    $("button").click(function () {
      var text = $(this).text();
      $("input").val(text);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;
    &lt;button&gt;Feed&lt;/button&gt;
    &lt;button&gt;the&lt;/button&gt;

    &lt;button&gt;Input&lt;/button&gt;
  &lt;/div&gt;
  &lt;input type="text" value="click a button" /&gt;</pre>
 * 
 * 
 * @param val A string of characters.String. The value to set on the matched element..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.val = function (val) {
  return new jQuery();
};
/** <p>
 * Checks, or selects, all the radio buttons, checkboxes, and select options that match the set of values.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Get the single value from a single select and an array of values from a multiple select and display their values.
 * <pre>

    $("#single").val("Single2");
    $("#multiple").val(["Multiple2", "Multiple3"]);
    $("input").val(["check2", "radio1"]);

</pre>
 * 
 * HTML:
 * <pre>&lt;select id="single"&gt;
    &lt;option&gt;Single&lt;/option&gt;
    &lt;option&gt;Single2&lt;/option&gt;
  &lt;/select&gt;

  &lt;select id="multiple" multiple="multiple"&gt;
    &lt;option selected="selected"&gt;Multiple&lt;/option&gt;
    &lt;option&gt;Multiple2&lt;/option&gt;

    &lt;option selected="selected"&gt;Multiple3&lt;/option&gt;
  &lt;/select&gt;&lt;br/&gt;
  &lt;input type="checkbox" value="check1"/&gt; check1
  &lt;input type="checkbox" value="check2"/&gt; check2
  &lt;input type="radio" name="r" value="radio1"/&gt; radio1
  &lt;input type="radio" name="r" value="radio2"/&gt; radio2</pre>
 * 
 * 
 * @param val An Array of strings.Array&lt;String&gt;. The set of values to check/select..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.val = function (val) {
  return new jQuery();
};
/** <p>
 * Reduce the set of matched elements to a single element. </p>
 * <p>
 * The position of the element in the set of matched elements starts at 0 and goes to length - 1.<br>
</p>
 * 
 * 
 * Example:
 * Turn the div with index 2 red by adding an appropriate class.
 * <pre>

    $("div").eq(2).addClass("red");
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param index Integer. The index of the element in the jQuery object..
 * @return A jQuery object.jQuery
 * @since 1.1.2
 */
jQuery.eq = function (index) {
  return new jQuery();
};
/** <p>
 * Checks the current selection against a class and returns true, if at least one element of the selection has the given class.</p>
 * <p>
 * This is an alternative to is("." + class).<br>
</p>
 * 
 * 
 * Example:
 * Check to see if an element has a specific class, and if so, perform an action.
 * <pre>

    $("div").click(function(){
      if ( $(this).hasClass("protected") )
        $(this).animate({ left: -10 }, 75)
               .animate({ left: 10 }, 75)
               .animate({ left: -10 }, 75)
               .animate({ left: 10 }, 75)
               .animate({ left: 0 }, 75);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;&lt;/span&gt;&lt;div class="protected"&gt;&lt;/div&gt;
  &lt;span&gt;&lt;/span&gt;&lt;div&gt;&lt;/div&gt;

  &lt;span&gt;&lt;/span&gt;&lt;div&gt;&lt;/div&gt;
  &lt;span&gt;&lt;/span&gt;&lt;div class="protected"&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param class A string of characters.String. The class to match..
 * @return true or false.Boolean
 * @since 1.2
 */
jQuery.hasClass = function (class) {
  return false;
};
/** <p>
 * Removes all elements from the set of matched elements that do not match the specified expression(s). </p>
 * <p>
 * This method is used to narrow down the results of a search.

Provide a comma-separated list of expressions to apply multiple filters at once.<br>
</p>
 * 
 * 
 * Example:
 * Change the color of all divs then put a border around only some of them.
 * <pre>

    $("div").css("background", "#c8ebcc")
            .filter(".middle")
            .css("border-color", "red");
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;

  &lt;div class="middle"&gt;&lt;/div&gt;
  &lt;div class="middle"&gt;&lt;/div&gt;
  &lt;div class="middle"&gt;&lt;/div&gt;
  &lt;div class="middle"&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Selects all paragraphs and removes those without a class "selected".
 * <pre>$("p").filter(".selected")</pre>
 * 
 * Example:
 * Selects all paragraphs and removes those that aren't of class "selected" or the first one.
 * <pre>$("p").filter(".selected, :first")</pre>
 * 
 * 
 * @param expr Expression. An expression to pass into the filter.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.filter = function (expr) {
  return new jQuery();
};
/** <p>
 * Removes all elements from the set of matched elements that does not match the specified function. </p>
 * <p>
 * The function is called with a context equal to the current element (just like &lt;a href='Core/each'&gt;$.each&lt;/a&gt;). If the function returns false, then the element is removed - anything else and the element is kept.<br>
</p>
 * 
 * 
 * Example:
 * Change the color of all divs then put a border two specific ones.
 * <pre>
    $("div").css("background", "#b4b0da")
            .filter(function (index) {
                  return index == 1 || $(this).attr("id") == "fourth";
                })
            .css("border", "3px double red");

</pre>
 * 
 * HTML:
 * <pre>&lt;div id="first"&gt;&lt;/div&gt;
  &lt;div id="second"&gt;&lt;/div&gt;
  &lt;div id="third"&gt;&lt;/div&gt;

  &lt;div id="fourth"&gt;&lt;/div&gt;
  &lt;div id="fifth"&gt;&lt;/div&gt;
  &lt;div id="sixth"&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Remove all elements that have a descendant ol element
 * <pre> $("p").filter(function(index) {
   return $("ol", this).length == 0;
 });</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to pass into the filter

&lt;pre&gt;function callback(indexInJQueryObject) {
  var keepItBoolean = true;

  this; // dom element

  return keepItBoolean;
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.filter = function (fn) {
  return new jQuery();
};
/** <p>
 * Checks the current selection against an expression and returns true, if at least one element of the selection fits the given expression.</p>
 * <p>
 * If no element fits, or the expression is not valid, then the response will be 'false'.


&lt;a href='Traversing/filter'&gt;filter&lt;/a&gt; is used internally, therefore all rules that apply there apply here, as well. <br>
</p>
 * 
 * 
 * Example:
 * Shows a few ways is() can be used inside an event handler.
 * <pre>
    $("div").one('click', function () {
      if ($(this).is(":first-child")) {
        $("p").text("It's the first div.");
      } else if ($(this).is(".blue,.red")) {
        $("p").text("It's a blue or red div.");
      } else if ($(this).is(":contains('Peter')")) {
        $("p").text("It's Peter!");
      } else {
        $("p").html("It's nothing &lt;em&gt;special&lt;/em&gt;.");
      }
      $("p").hide().slideDown("slow");
      $(this).css({"border-style": "inset", cursor:"default"});
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div class="blue"&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div class="red"&gt;&lt;/div&gt;

  &lt;div&gt;&lt;br/&gt;&lt;span&gt;Peter&lt;/span&gt;&lt;/div&gt;
  &lt;div class="blue"&gt;&lt;/div&gt;
  &lt;p&gt;&amp;nbsp;&lt;/p&gt;</pre>
 * 
 * Example:
 * Returns true, because the parent of the input is a form element
 * <pre>

    var isFormParent = $("input[@type='checkbox']").parent().is("form")
    $("div").text("isFormParent = " + isFormParent);
</pre>
 * 
 * HTML:
 * <pre>&lt;form&gt;&lt;input type="checkbox" /&gt;&lt;/form&gt;

  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Returns false, because the parent of the input is a p element
 * <pre>
    var isFormParent = $("input[@type='checkbox']").parent().is("form")
    $("div").text("isFormParent = " + isFormParent);
</pre>
 * 
 * HTML:
 * <pre>&lt;form&gt;&lt;p&gt;&lt;input type="checkbox" /&gt;&lt;/p&gt;&lt;/form&gt;

  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. The expression with which to filter.
 * @return true or false.Boolean
 * @since 1.0
 */
jQuery.is = function (expr) {
  return false;
};
/** <p>
 * Translate a set of elements in the jQuery object into another set of values in an array (which may, or may not, be elements).</p>
 * <p>
 * You could use this to build lists of values, attributes, css values - or even perform special, custom, selector transformations.

This is provided as a convenience method for using &lt;a href='Utilities/jQuery.map'&gt;$.map()&lt;/a&gt;.<br>
</p>
 * 
 * 
 * Example:
 * Build a list of all the values within a form.
 * <pre>
    $("p").append( $("input").map(function(){
      return $(this).val();
    }).get().join(", ") );

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;&lt;b&gt;Values: &lt;/b&gt;&lt;/p&gt;
  &lt;form&gt;
    &lt;input type="text" name="name" value="John"/&gt;

    &lt;input type="text" name="password" value="password"/&gt;
    &lt;input type="text" name="url" value="http://ejohn.org/"/&gt;

  &lt;/form&gt;</pre>
 * 
 * Example:
 * A contrived example to show some functionality.
 * <pre>
    var mappedItems = $("li").map(function (index) {
      var replacement = $("&lt;li&gt;").text($(this).text()).get(0);
      if (index == 0) {
        // make the first item all caps
        $(replacement).text($(replacement).text().toUpperCase());
      } else if (index == 1 || index == 3) {
        // delete the second and fourth items
        replacement = null;
      } else if (index == 2) {
        // make two of the third item and add some text
        replacement = [replacement,$("&lt;li&gt;").get(0)];
        $(replacement[0]).append("&lt;b&gt; - A&lt;/b&gt;");
        $(replacement[1]).append("Extra &lt;b&gt; - B&lt;/b&gt;");
      }

      // replacment will be an dom element, null, 
      // or an array of dom elements
      return replacement;
    });
    $("#results").append(mappedItems);

</pre>
 * 
 * HTML:
 * <pre>&lt;ul&gt;
    &lt;li&gt;First&lt;/li&gt;
    &lt;li&gt;Second&lt;/li&gt;
    &lt;li&gt;Third&lt;/li&gt;

    &lt;li&gt;Fourth&lt;/li&gt;
    &lt;li&gt;Fifth&lt;/li&gt;
  &lt;/ul&gt;
  &lt;ul id="results"&gt;

  &lt;/ul&gt;</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute on each element in the set.
&lt;pre&gt;function callback(index, domElement) {
  var replacement;

  this; // also dom element

  // replacement == null : delete spot
  // replacement == array : insert the elements of the array
  // else replace the spot with replacement
  return replacement;
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.map = function (callback) {
  return new jQuery();
};
/** <p>
 * Removes elements matching the specified expression from the set of matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Adds a border to divs that are not green or blue.
 * <pre>
    $("div").not(".green, #blueone")
            .css("border-color", "red");

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div id="blueone"&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div class="green"&gt;&lt;/div&gt;

  &lt;div class="green"&gt;&lt;/div&gt;
  &lt;div class="gray"&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Removes the element with the ID "selected" from the set of all paragraphs.
 * <pre>$("p").not( $("#selected")[0] )</pre>
 * 
 * Example:
 * Removes the element with the ID "selected" from the set of all paragraphs.
 * <pre>$("p").not("#selected")</pre>
 * 
 * Example:
 * Removes all elements that match "div p.selected" from the total set of all paragraphs.
 * <pre>$("p").not($("div p.selected"))</pre>
 * 
 * 
 * @param expr String, DOMElement, Array&lt;DOMElement&gt;. An expression with which to remove matching elements, an element to remove from the set or a set of elements to remove from the jQuery set of matched elements..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.not = function (expr) {
  return new jQuery();
};
/** <p>
 * Selects a subset of the matched elements.</p>
 * <p>
 * Behaves exactly like the built-in Array slice method. <br>
</p>
 * 
 * 
 * Example:
 * Turns divs yellow based on a random slice.
 * <pre>

    function colorEm() {
      var $div = $("div");
      var start = Math.floor(Math.random() *
                             $div.length);
      var end = Math.floor(Math.random() *
                           ($div.length - start)) +
                           start + 1;
      if (end == $div.length) end = undefined;
      $div.css("background", "");
      if (end) 
        $div.slice(start, end).css("background", "yellow");   
       else
        $div.slice(start).css("background", "yellow");
      
      $("span").text('$("div").slice(' + start +
                     (end ? ', ' + end : '') +
                     ').css("background", "yellow");');
    }

    $("button").click(colorEm);

</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Turn slice yellow&lt;/button&gt;
  &lt;span&gt;Click the button!&lt;/span&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Selects all paragraphs, then slices the selection to include only the first element.
 * <pre>$("p").slice(0, 1).wrapInner("&lt;b&gt;&lt;/b&gt;");</pre>
 * 
 * Example:
 * Selects all paragraphs, then slices the selection to include only the first and second element.
 * <pre>$("p").slice(0, 2).wrapInner("&lt;b&gt;&lt;/b&gt;");</pre>
 * 
 * Example:
 * Selects all paragraphs, then slices the selection to include only the second element.
 * <pre>$("p").slice(1, 2).wrapInner("&lt;b&gt;&lt;/b&gt;");</pre>
 * 
 * Example:
 * Selects all paragraphs, then slices the selection to include only the second and third element.
 * <pre>$("p").slice(1).wrapInner("&lt;b&gt;&lt;/b&gt;");</pre>
 * 
 * Example:
 * Selects all paragraphs, then slices the selection to include only the third element.
 * <pre>$("p").slice(-1).wrapInner("&lt;b&gt;&lt;/b&gt;");</pre>
 * 
 * 
 * @param start Integer. Where to start the subset. The first element is at zero. Can be negative to start from the end of the selection..
 * @param end Integer. Where to end the subset. If unspecified, ends at the end of the selection..
 * @return A jQuery object.jQuery
 * @since 1.1.4
 */
jQuery.slice = function (start, end) {
  return new jQuery();
};
/** <p>
 * Adds more elements, matched by the given expression, to the set of matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Finds all divs and makes a border.  Then adds all paragraphs to the jQuery object to set their backgrounds yellow.
 * <pre>

    $("div").css("border", "2px solid red")
            .add("p")
            .css("background", "yellow");
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;p&gt;Added this... (notice no border)&lt;/p&gt;</pre>
 * 
 * Example:
 * Adds more elements, matched by the given expression, to the set of matched elements.
 * <pre>$("p").add("span").css("background", "yellow");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;&lt;span&gt;Hello Again&lt;/span&gt;</pre>
 * 
 * Example:
 * Adds more elements, created on the fly, to the set of matched elements.
 * <pre>$("p").clone().add("&amp;lt;span&gt;Again&amp;lt;/span&gt;").appendTo(document.body);</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;</pre>
 * 
 * Example:
 * Adds one or more Elements to the set of matched elements.
 * <pre>$("p").add(document.getElementById("a")).css("background", "yellow");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;&lt;span id="a"&gt;Hello Again&lt;/span&gt;</pre>
 * 
 * 
 * @param expr String, DOMElement, Array&lt;DOMElement&gt;. An expression whose matched elements are added for String, a string of HTML to create on the fly for DOMElement or one or more Elements to add if an Array..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.add = function (expr) {
  return new jQuery();
};
/** <p>
 * Get a set of elements containing all of the unique immediate children of each of the matched set of elements.</p>
 * <p>
 * This set can be filtered with an optional expression that will cause only elements matching the selector to be collected. Also note: while parents() will look at all ancestors, children() will only consider immediate child elements.<br>
</p>
 * 
 * 
 * Example:
 * Find all children of the clicked element.
 * <pre>

    $("#container").click(function (e) {
      $("*").removeClass("hilite");
      var $kids = $(e.target).children();
      var len = $kids.addClass("hilite").length;

      $("#results span:first").text(len);
      $("#results span:last").text(e.target.tagName);

      e.preventDefault();
      return false;
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;div id="container"&gt;

    &lt;div&gt;
      &lt;p&gt;This &lt;span&gt;is the &lt;em&gt;way&lt;/em&gt; we&lt;/span&gt; 
      write &lt;em&gt;the&lt;/em&gt; demo,&lt;/p&gt;

    &lt;/div&gt;
    &lt;div&gt;
      &lt;a href="#"&gt;&lt;b&gt;w&lt;/b&gt;rit&lt;b&gt;e&lt;/b&gt;&lt;/a&gt; the &lt;span&gt;demo,&lt;/span&gt; &lt;button&gt;write 
      the&lt;/button&gt; demo,
    &lt;/div&gt;

    &lt;div&gt;
      This &lt;span&gt;the way we &lt;em&gt;write&lt;/em&gt; the &lt;em&gt;demo&lt;/em&gt; so&lt;/span&gt;

      &lt;input type="text" value="early" /&gt; in
    &lt;/div&gt;
    &lt;p&gt;
      &lt;span&gt;t&lt;/span&gt;he &lt;span&gt;m&lt;/span&gt;orning.
      &lt;span id="results"&gt;Found &lt;span&gt;0&lt;/span&gt; children in &lt;span&gt;TAG&lt;/span&gt;.&lt;/span&gt;

    &lt;/p&gt;
  &lt;/div&gt;</pre>
 * 
 * Example:
 * Find all children of each div.
 * <pre>$("div").children().css("border-bottom", "3px double red");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello (this is a paragraph)&lt;/p&gt;

  &lt;div&gt;&lt;span&gt;Hello Again (this span is a child of the a div)&lt;/span&gt;&lt;/div&gt;
  &lt;p&gt;And &lt;span&gt;Again&lt;/span&gt; (in another paragraph)&lt;/p&gt;

  &lt;div&gt;And One Last &lt;span&gt;Time&lt;/span&gt; (most text directly in a div)&lt;/div&gt;</pre>
 * 
 * Example:
 * Find all children with a class "selected" of each div.
 * <pre>$("div").children(".selected").css("color", "blue");</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;
    &lt;span&gt;Hello&lt;/span&gt;
    &lt;p class="selected"&gt;Hello Again&lt;/p&gt;
    &lt;div class="selected"&gt;And Again&lt;/div&gt;

    &lt;p&gt;And One Last Time&lt;/p&gt;
  &lt;/div&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression to filter the child Elements with..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.children = function (expr) {
  return new jQuery();
};
/** <p>
 * Find all the child nodes inside the matched elements (including text nodes), or the content document, if the element is an iframe.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Find all the text nodes inside a paragraph and wrap them with a bold tag.
 * <pre>$("p").contents().not("[nodeType=1]").wrap("&lt;b/&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello &lt;a href="http://ejohn.org/"&gt;John&lt;/a&gt;, how are you doing?&lt;/p&gt;</pre>
 * 
 * Example:
 * Append some new content into an empty iframe.
 * <pre>$("iframe").contents().find("body").append("I'm in an iframe!");</pre>
 * 
 * HTML:
 * <pre>&lt;iframe src="/index-blank.html" width="300" height="100"&gt;&lt;/iframe&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.contents = function () {
  return new jQuery();
};
/** <p>
 * Searches for all elements that match the specified &lt;a href='Selectors'&gt;expression&lt;/a&gt;. This method is a good way to find additional descendant elements with which to process.</p>
 * <p>
 * All searching is done using a &lt;a href='Selectors'&gt;jQuery expression&lt;/a&gt;. The expression can be written using CSS 1-3 Selector syntax. <br>
</p>
 * 
 * 
 * Example:
 * Starts with all paragraphs and searches for descendant span elements, same as $("p span")
 * <pre>$("p").find("span").css('color','red');</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;&lt;span&gt;Hello&lt;/span&gt;, how are you?&lt;/p&gt;

  &lt;p&gt;Me? I'm &lt;span&gt;good&lt;/span&gt;.&lt;/p&gt;</pre>
 * 
 * Example:
 * Add spans around each word then add a hover and italicize words with the letter '''t'''.
 * <pre>
    var newText = $("p").text().split(" ").join("&lt;/span&gt; &lt;span&gt;");
    newText = "&lt;span&gt;" + newText + "&lt;/span&gt;";

    $("p").html(newText)
          .find("span")
            .hover(function () { $(this).addClass("hilite"); },
                   function () { $(this).removeClass("hilite"); })
          .end()
          .find(":contains('t')")
            .css({"font-style":"italic", "font-weight":"bolder"});

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    When the day is short
    find that which matters to you
    or stop believing
  &lt;/p&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression to search with..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.find = function (expr) {
  return new jQuery();
};
/** <p>
 * Get a set of elements containing the unique next siblings of each of the given set of elements.</p>
 * <p>
 * next only returns the very next sibling for each element, not all next siblings (see nextAll).

You may provide an optional expression to filter the returned set. <br>
</p>
 * 
 * 
 * Example:
 * Find the very next sibling of each disabled button and change its text "this button is disabled".
 * <pre>$("button[disabled]").next().text("this button is disabled");</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;button disabled="disabled"&gt;First&lt;/button&gt; - &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;&lt;button&gt;Second&lt;/button&gt; - &lt;span&gt;&lt;/span&gt;&lt;/div&gt;

  &lt;div&gt;&lt;button disabled="disabled"&gt;Third&lt;/button&gt; - &lt;span&gt;&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Find the very next sibling of each paragraph that has a class "selected".
 * <pre>$("p").next(".selected").css("background", "yellow");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;

  &lt;p class="selected"&gt;Hello Again&lt;/p&gt;
  &lt;div&gt;&lt;span&gt;And Again&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression with which to filter the returned set..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.next = function (expr) {
  return new jQuery();
};
/** <p>
 * Find all sibling elements after the current element.</p>
 * <p>
 * Use an optional expression to filter the matched set. <br>
</p>
 * 
 * 
 * Example:
 * Locate all the divs after the first and give them a class.
 * <pre>$("div:first").nextAll().addClass("after");</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Locate all the paragraphs after the second child in the body and give them a class.
 * <pre>

    $(":nth-child(1)").nextAll("p").addClass("after");
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;p&lt;/p&gt;
  &lt;div&gt;div&lt;/div&gt;

  &lt;p&gt;p&lt;/p&gt;
  &lt;p&gt;p&lt;/p&gt;
  &lt;div&gt;div&lt;/div&gt;
  &lt;p&gt;p&lt;/p&gt;

  &lt;div&gt;div&lt;/div&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression to filter the next Elements with..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.nextAll = function (expr) {
  return new jQuery();
};
/** <p>
 * Get a set of elements containing the unique parents of the matched set of elements.</p>
 * <p>
 * You may use an optional expression to filter the set of parent elements that will match. <br>
</p>
 * 
 * 
 * Example:
 * Shows the parent of each element as (parent &gt; child).  Check the View Source to see the raw html.
 * <pre>
    $("*", document.body).each(function () {
      var parentTag = $(this).parent().get(0).tagName;
      $(this).prepend(document.createTextNode(parentTag + " &gt; "));
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;div, 
    &lt;span&gt;span, &lt;/span&gt;
    &lt;b&gt;b &lt;/b&gt;
  &lt;/div&gt;

  &lt;p&gt;p, 
    &lt;span&gt;span, 
      &lt;em&gt;em &lt;/em&gt;
    &lt;/span&gt;
  &lt;/p&gt;
  &lt;div&gt;div, 
    &lt;strong&gt;strong, 
      &lt;span&gt;span, &lt;/span&gt;

      &lt;em&gt;em, 
        &lt;b&gt;b, &lt;/b&gt;
      &lt;/em&gt;
    &lt;/strong&gt;
    &lt;b&gt;b &lt;/b&gt;

  &lt;/div&gt;</pre>
 * 
 * Example:
 * Find the parent element of each paragraph with a class "selected".
 * <pre>$("p").parent(".selected").css("background", "yellow");</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;p&gt;Hello&lt;/p&gt;&lt;/div&gt;

  &lt;div class="selected"&gt;&lt;p&gt;Hello Again&lt;/p&gt;&lt;/div&gt;
</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression to filter the parents with..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.parent = function (expr) {
  return new jQuery();
};
/** <p>
 * Get a set of elements containing the unique ancestors of the matched set of elements (except for the root element).

The matched elements can be filtered with an optional expression. </p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Find all parent elements of each span.
 * <pre>
    var parentEls = $("b").parents()
                          .map(function () { 
                                return this.tagName; 
                              })
                          .get().join(", ");
    $("b").append("&lt;strong&gt;" + parentEls + "&lt;/strong&gt;");

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;
    &lt;p&gt;
      &lt;span&gt;
        &lt;b&gt;My parents are: &lt;/b&gt;
      &lt;/span&gt;

    &lt;/p&gt;
  &lt;/div&gt;</pre>
 * 
 * Example:
 * Click to find all unique div parent elements of each span.
 * <pre>
    function showParents() {
      $("div").css("border-color", "white");
      var len = $("span.selected")
                       .parents("div")
                       .css("border", "2px red solid")
                       .length;
      $("b").text("Unique div parents: " + len);
    }
    $("span").click(function () {
      $(this).toggleClass("selected");
      showParents();
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    &lt;div&gt;
      &lt;div&gt;&lt;span&gt;Hello&lt;/span&gt;&lt;/div&gt;
      &lt;span&gt;Hello Again&lt;/span&gt;

    &lt;/div&gt;
    &lt;div&gt;
      &lt;span&gt;And Hello Again&lt;/span&gt;
    &lt;/div&gt;
  &lt;/p&gt;

  &lt;b&gt;Click Hellos to toggle their parents.&lt;/b&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression to filter the ancestors with.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.parents = function (expr) {
  return new jQuery();
};
/** <p>
 * Get a set of elements containing the unique previous siblings of each of the matched set of elements.</p>
 * <p>
 * Use an optional expression to filter the matched set.

Only the immediately previous sibling is returned, not all previous siblings. <br>
</p>
 * 
 * 
 * Example:
 * Find the very previous sibling of each div.
 * <pre>
    var $curr = $("#start");
    $curr.css("background", "#f99");
    $("button").click(function () {
      $curr = $curr.prev();
      $("div").css("background", "");
      $curr.css("background", "#f99");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;span&gt;has child&lt;/span&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div id="start"&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;p&gt;&lt;button&gt;Go to Prev&lt;/button&gt;&lt;/p&gt;</pre>
 * 
 * Example:
 * Find the very previous sibling of each paragraph that has a class "selected".
 * <pre>$("p").prev(".selected").css("background", "yellow");</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;span&gt;Hello&lt;/span&gt;&lt;/div&gt;

  &lt;p class="selected"&gt;Hello Again&lt;/p&gt;
  &lt;p&gt;And Again&lt;/p&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression to filter the previous Elements with..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.prev = function (expr) {
  return new jQuery();
};
/** <p>
 * Find all sibling elements before the current element.</p>
 * <p>
 * Use an optional expression to filter the matched set. <br>
</p>
 * 
 * 
 * Example:
 * Locate all the divs before the last and give them a class.
 * <pre>$("div:last").prevAll().addClass("before");</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression to filter the previous Elements with..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.prevAll = function (expr) {
  return new jQuery();
};
/** <p>
 * Get a set of elements containing all of the unique siblings of each of the matched set of elements.

Can be filtered with an optional expressions. </p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Find the unique siblings of all yellow li elements in the 3 lists (including other yellow li elements if appropriate).
 * <pre>

    var len = $(".hilite").siblings()
                          .css("color", "red")
                          .length;
    $("b").text(len);
</pre>
 * 
 * HTML:
 * <pre>&lt;ul&gt;
    &lt;li&gt;One&lt;/li&gt;

    &lt;li&gt;Two&lt;/li&gt;
    &lt;li class="hilite"&gt;Three&lt;/li&gt;
    &lt;li&gt;Four&lt;/li&gt;
  &lt;/ul&gt;

  &lt;ul&gt;
    &lt;li&gt;Five&lt;/li&gt;
    &lt;li&gt;Six&lt;/li&gt;
    &lt;li&gt;Seven&lt;/li&gt;

  &lt;/ul&gt;
  &lt;ul&gt;
    &lt;li&gt;Eight&lt;/li&gt;
    &lt;li class="hilite"&gt;Nine&lt;/li&gt;

    &lt;li&gt;Ten&lt;/li&gt;
    &lt;li class="hilite"&gt;Eleven&lt;/li&gt;
  &lt;/ul&gt;
  &lt;p&gt;Unique siblings: &lt;b&gt;&lt;/b&gt;&lt;/p&gt;</pre>
 * 
 * Example:
 * Find all siblings with a class "selected" of each div.
 * <pre>$("p").siblings(".selected").css("background", "yellow");</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;span&gt;Hello&lt;/span&gt;&lt;/div&gt;

  &lt;p class="selected"&gt;Hello Again&lt;/p&gt;
  &lt;p&gt;And Again&lt;/p&gt;</pre>
 * 
 * 
 * @param expr A string of characters.String. An expression to filter the sibling Elements with.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.siblings = function (expr) {
  return new jQuery();
};
/** <p>
 * Add the previous selection to the current selection.</p>
 * <p>
 * Useful for traversing elements, and then adding something that was matched before the last traversion.<br>
</p>
 * 
 * 
 * Example:
 * Find all divs, and all the paragraphs inside of them, and give them both classnames.  Notice the div doesn't have the yellow background color since it didn't use andSelf().
 * <pre>
    $("div").find("p").andSelf().addClass("border");
    $("div").find("p").addClass("background");

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;
    &lt;p&gt;First Paragraph&lt;/p&gt;
    &lt;p&gt;Second Paragraph&lt;/p&gt;
  &lt;/div&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.andSelf = function () {
  return new jQuery();
};
/** <p>
 * Revert the most recent 'destructive' operation, changing the set of matched elements to its previous state (right before the destructive operation).</p>
 * <p>
 * If there was no destructive operation before, an empty set is returned.

A 'destructive' operation is any operation that changes the set of matched jQuery elements, which means any Traversing function that returns a jQuery object - including &lt;a href='Traversing/add'&gt;add&lt;/a&gt;, &lt;a href='Traversing/andSelf'&gt;andSelf&lt;/a&gt;, &lt;a href='Traversing/children'&gt;children&lt;/a&gt;, &lt;a href='Traversing/filter'&gt;filter&lt;/a&gt;, &lt;a href='Traversing/find'&gt;find&lt;/a&gt;, &lt;a href='Traversing/map'&gt;map&lt;/a&gt;, &lt;a href='Traversing/next'&gt;next&lt;/a&gt;, &lt;a href='Traversing/nextAll'&gt;nextAll&lt;/a&gt;, &lt;a href='Traversing/not'&gt;not&lt;/a&gt;, &lt;a href='Traversing/parent'&gt;parent&lt;/a&gt;, &lt;a href='Traversing/parents'&gt;parents&lt;/a&gt;, &lt;a href='Traversing/prev'&gt;prev&lt;/a&gt;, &lt;a href='Traversing/prevAll'&gt;prevAll&lt;/a&gt;, &lt;a href='Traversing/siblings'&gt;siblings&lt;/a&gt; and &lt;a href='Traversing/slice'&gt;slice&lt;/a&gt; - plus the &lt;a href='Manipulation/clone'&gt;clone&lt;/a&gt; function (from Manipulation). <br>
</p>
 * 
 * 
 * Example:
 * Selects all paragraphs, finds span elements inside these, and reverts the selection back to the paragraphs.
 * <pre>

    jQuery.fn.showTags = function (n) {
      var tags = this.map(function () { 
                              return this.tagName; 
                            })
                        .get().join(", ");
      $("b:eq(" + n + ")").text(tags);
      return this;
    };

    $("p").showTags(0)
          .find("span")
          .showTags(1)
          .css("background", "yellow")
          .end()
          .showTags(2)
          .css("font-style", "italic");

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Hi there &lt;span&gt;how&lt;/span&gt; are you &lt;span&gt;doing&lt;/span&gt;?
  &lt;/p&gt;

  &lt;p&gt;
    This &lt;span&gt;span&lt;/span&gt; is one of 
    several &lt;span&gt;spans&lt;/span&gt; in this
    &lt;span&gt;sentence&lt;/span&gt;.
  &lt;/p&gt;

  &lt;div&gt;
    Tags in jQuery object initially: &lt;b&gt;&lt;/b&gt;
  &lt;/div&gt;
  &lt;div&gt;
    Tags in jQuery object after find: &lt;b&gt;&lt;/b&gt;

  &lt;/div&gt;
  &lt;div&gt;
    Tags in jQuery object after end: &lt;b&gt;&lt;/b&gt;
  &lt;/div&gt;</pre>
 * 
 * Example:
 * Selects all paragraphs, finds span elements inside these, and reverts the selection back to the paragraphs.
 * <pre>$("p").find("span").end().css("border", "2px red solid");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;&lt;span&gt;Hello&lt;/span&gt;, how are you?&lt;/p&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.end = function () {
  return new jQuery();
};
/** <p>
 * Get the html contents (innerHTML) of the first matched element. This property is not available on XML documents (although it will work for XHTML documents).</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Click a paragraph to convert it from html to text.
 * <pre>

    $("p").click(function () {
      var htmlStr = $(this).html();
      $(this).text(htmlStr);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    &lt;b&gt;Click&lt;/b&gt; to change the &lt;span id="tag"&gt;html&lt;/span&gt;

  &lt;/p&gt;
  &lt;p&gt;
    to a &lt;span id="text"&gt;text&lt;/span&gt; node.
  &lt;/p&gt;
  &lt;p&gt;

    This &lt;button name="nada"&gt;button&lt;/button&gt; does nothing.
  &lt;/p&gt;</pre>
 * 
 * 
 * @return A string of characters.String
 */
jQuery.html = function () {
  return "";
};
/** <p>
 * Set the html contents of every matched element. This property is not available on XML documents (although it will work for XHTML documents).</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Add some html to each div.
 * <pre>$("div").html("&lt;span class='red'&gt;Hello &lt;b&gt;Again&lt;/b&gt;&lt;/span&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;Hello&lt;/span&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Add some html to each div then immediately do further manipulations to the inserted html.
 * <pre>

    $("div").html("&lt;b&gt;Wow!&lt;/b&gt; Such excitement...");
    $("div b").append(document.createTextNode("!!!"))
              .css("color", "red");

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param val string. Set the html contents to the specified value..
 * @return A jQuery object.jQuery
 */
jQuery.html = function (val) {
  return new jQuery();
};
/** <p>
 * Get the combined text contents of all matched elements.</p>
 * <p>
 * The result is a string that contains the combined text contents of all matched elements. This method works on both HTML and XML documents.<br>
</p>
 * 
 * 
 * Example:
 * Find the text in the first paragraph (stripping out the html), then set the html of the last paragraph to show it is just text (the red bold is gone).
 * <pre>

    var str = $("p:first").text();
    $("p:last").html(str);
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;&lt;b&gt;Test&lt;/b&gt; Paragraph.&lt;/p&gt;

  &lt;p&gt;&lt;/p&gt;</pre>
 * 
 * 
 * @return A string of characters.String
 */
jQuery.text = function () {
  return "";
};
/** <p>
 * Set the text contents of all matched elements.</p>
 * <p>
 * Similar to html(), but escapes HTML (replace "&lt;" and "&gt;" with their HTML entities).<br>
</p>
 * 
 * 
 * Example:
 * Add text to the paragraph (notice the bold tag is escaped).
 * <pre>$("p").text("&lt;b&gt;Some&lt;/b&gt; new text.");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Test Paragraph.&lt;/p&gt;</pre>
 * 
 * 
 * @param val A string of characters.String. The text value to set the contents of the element to..
 * @return A jQuery object.jQuery
 */
jQuery.text = function (val) {
  return new jQuery();
};
/** <p>
 * Append content to the inside of every matched element.</p>
 * <p>
 * This operation is similar to doing an appendChild to all the specified elements, adding them into the document.<br>
</p>
 * 
 * 
 * Example:
 * Appends some HTML to all paragraphs.
 * <pre>$("p").append("&lt;b&gt;Hello&lt;/b&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;I would like to say: &lt;/p&gt;</pre>
 * 
 * Example:
 * Appends an Element to all paragraphs.
 * <pre>$("p").append(document.createTextNode("Hello"));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;I would like to say: &lt;/p&gt;</pre>
 * 
 * Example:
 * Appends a jQuery object (similar to an Array of DOM Elements) to all paragraphs.
 * <pre>$("p").append( $("b") );</pre>
 * 
 * HTML:
 * <pre>&lt;b&gt;Hello&lt;/b&gt;&lt;p&gt;I would like to say: &lt;/p&gt;</pre>
 * 
 * 
 * @param content String, Element, jQuery. Content to append to the target..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.append = function (content) {
  return new jQuery();
};
/** <p>
 * Append all of the matched elements to another, specified, set of elements.</p>
 * <p>
 * This operation is, essentially, the reverse of doing a regular $(A).append(B), in that instead of appending B to A, you're appending A to B.<br>
</p>
 * 
 * 
 * Example:
 * Appends all spans to the element with the ID "foo"
 * <pre>$("span").appendTo("#foo"); // check append() examples</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;I have nothing more to say... &lt;/span&gt;

  &lt;div id="foo"&gt;FOO! &lt;/div&gt;</pre>
 * 
 * 
 * @param content A string of characters.String. target to which the content will be appended..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.appendTo = function (content) {
  return new jQuery();
};
/** <p>
 * Prepend content to the inside of every matched element.</p>
 * <p>
 * This operation is the best way to insert elements inside, at the beginning, of all matched elements.<br>
</p>
 * 
 * 
 * Example:
 * Prepends some HTML to all paragraphs.
 * <pre>$("p").prepend("&lt;b&gt;Hello &lt;/b&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;there friend!&lt;/p&gt;

  &lt;p&gt;amigo!&lt;/p&gt;</pre>
 * 
 * Example:
 * Prepends a DOM Element to all paragraphs.
 * <pre>$("p").prepend(document.createTextNode("Hello "));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;is what I'd say&lt;/p&gt;
  &lt;p&gt;is what I said&lt;/p&gt;</pre>
 * 
 * Example:
 * Prepends a jQuery object (similar to an Array of DOM Elements) to all paragraphs.
 * <pre>$("p").prepend( $("b") );</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt; is what was said.&lt;/p&gt;&lt;b&gt;Hello&lt;/b&gt;</pre>
 * 
 * 
 * @param content String, Element, jQuery. Content to prepend to the target..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.prepend = function (content) {
  return new jQuery();
};
/** <p>
 * Prepend all of the matched elements to another, specified, set of elements.</p>
 * <p>
 * This operation is, essentially, the reverse of doing a regular $(A).prepend(B), in that instead of prepending B to A, you're prepending A to B.<br>
</p>
 * 
 * 
 * Example:
 * Prepends all spans to the element with the ID "foo"
 * <pre>$("span").prependTo("#foo"); // check prepend() examples</pre>
 * 
 * HTML:
 * <pre>&lt;div id="foo"&gt;FOO!&lt;/div&gt;

  &lt;span&gt;I have something to say... &lt;/span&gt;</pre>
 * 
 * 
 * @param content A string of characters.String. target to which the content will be prepended..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.prependTo = function (content) {
  return new jQuery();
};
/** <p>
 * Insert content after each of the matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Inserts some HTML after all paragraphs.
 * <pre>$("p").after("&lt;b&gt;Hello&lt;/b&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;I would like to say: &lt;/p&gt;</pre>
 * 
 * Example:
 * Inserts a DOM element after all paragraphs.
 * <pre>$("p").after( document.createTextNode("Hello") );</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;I would like to say: &lt;/p&gt;</pre>
 * 
 * Example:
 * Inserts a jQuery object (similar to an Array of DOM Elements) after all paragraphs.
 * <pre>$("p").after( $("b") );</pre>
 * 
 * HTML:
 * <pre>&lt;b&gt;Hello&lt;/b&gt;

  &lt;p&gt;I would like to say: &lt;/p&gt;</pre>
 * 
 * 
 * @param content String, Element, jQuery. Content to insert after each target..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.after = function (content) {
  return new jQuery();
};
/** <p>
 * Insert content before each of the matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Inserts some HTML before all paragraphs.
 * <pre>$("p").before("&lt;b&gt;Hello&lt;/b&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt; is what I said...&lt;/p&gt;</pre>
 * 
 * Example:
 * Inserts a DOM element before all paragraphs.
 * <pre>$("p").before( document.createTextNode("Hello") );</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt; is what I said...&lt;/p&gt;</pre>
 * 
 * Example:
 * Inserts a jQuery object (similar to an Array of DOM Elements) before all paragraphs.
 * <pre>$("p").before( $("b") );</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt; is what I said...&lt;/p&gt;&lt;b&gt;Hello&lt;/b&gt;</pre>
 * 
 * 
 * @param content String, Element, jQuery. Content to insert before each target..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.before = function (content) {
  return new jQuery();
};
/** <p>
 * Insert all of the matched elements after another, specified, set of elements.</p>
 * <p>
 * This operation is, essentially, the reverse of doing a regular $(A).after(B), in that instead of inserting B after A, you're inserting A after B.<br>
</p>
 * 
 * 
 * Example:
 * Inserts all paragraphs after an element with id of "foo". Same as $("#foo").after("p")
 * <pre>$("p").insertAfter("#foo"); // check after() examples</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt; is what I said... &lt;/p&gt;&lt;div id="foo"&gt;FOO!&lt;/div&gt;</pre>
 * 
 * 
 * @param content A string of characters.String. Content after which the selected element(s) is inserted..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.insertAfter = function (content) {
  return new jQuery();
};
/** <p>
 * Insert all of the matched elements before another, specified, set of elements.</p>
 * <p>
 * This operation is, essentially, the reverse of doing a regular $(A).before(B), in that instead of inserting B before A, you're inserting A before B.<br>
</p>
 * 
 * 
 * Example:
 * Inserts all paragraphs before an element with id of "foo". Same as $("#foo").before("p")
 * <pre>$("p").insertBefore("#foo"); // check before() examples</pre>
 * 
 * HTML:
 * <pre>&lt;div id="foo"&gt;FOO!&lt;/div&gt;&lt;p&gt;I would like to say: &lt;/p&gt;</pre>
 * 
 * 
 * @param content A string of characters.String. Content after which the selected element(s) is inserted..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.insertBefore = function (content) {
  return new jQuery();
};
/** <p>
 * Wrap all matched elements with a structure of other elements.</p>
 * <p>
 * This wrapping process is most useful for injecting additional structure into a document, without ruining the original semantic qualities of a document.

This works by going through the first element provided (which is generated, on the fly, from the provided HTML) and finds the deepest ancestor element within its structure -- it is that element that will enwrap everything else.

This does not work with elements that contain text. Any necessary text must be added after the wrapping is done.<br>
</p>
 * 
 * 
 * Example:
 * Wraps a newly created div around all paragraphs.
 * <pre>$("p").wrap("&lt;div class='wrap'&gt;&lt;/div&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Test Paragraph.&lt;/p&gt;</pre>
 * 
 * Example:
 * Wraps a newly created tree of objects around each span.
 * <pre>$("span").wrap("&lt;div&gt;&lt;div&gt;&lt;p&gt;&lt;em&gt;&lt;b&gt;&lt;/b&gt;&lt;/em&gt;&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;Span Text&lt;/span&gt;
  &lt;span&gt;Another One&lt;/span&gt;</pre>
 * 
 * 
 * @param html A string of characters.String. A string of HTML that will be created on the fly and wrapped around the target..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.wrap = function (html) {
  return new jQuery();
};
/** <p>
 * Wrap all matched elements with a structure of other elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Wraps an element with id of "content" around all paragraphs.
 * <pre>$("p").wrap(document.getElementById('content'));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Test Paragraph.&lt;/p&gt;&lt;div id="content"&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Wraps a jQuery object (in this case a div) around all paragraphs.
 * <pre>$("p").wrap($("&lt;div&gt;"));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Test Paragraph.&lt;/p&gt;

  &lt;p&gt;Another Paragraph.&lt;/p&gt;</pre>
 * 
 * 
 * @param elem The Javascript object representation of a DOM Element.Element. A DOM element that will be wrapped around the target..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.wrap = function (elem) {
  return new jQuery();
};
/** <p>
 * Wrap all the elements in the matched set into a single wrapper element.</p>
 * <p>
 * This is different from &lt;a href='Manipulation/wrap'&gt;.wrap()&lt;/a&gt; where each element in the matched set would get wrapped with an element.

This wrapping process is most useful for injecting additional structure into a document, without ruining the original semantic qualities of a document.

This works by going through the first element provided (which is generated, on the fly, from the provided HTML) and finds the deepest ancestor element within its structure -- it is that element that will enwrap everything else.<br>
</p>
 * 
 * 
 * Example:
 * Wrap a new div around all of the paragraphs.
 * <pre>$("p").wrapAll("&lt;div&gt;&lt;/div&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;</pre>
 * 
 * Example:
 * Wraps a newly created tree of objects around the spans.  Notice anything in between the spans gets left out like the &lt;strong&gt; (red text) in this example.  Even the white space between spans is left out.  Click View Source to see the original html.
 * <pre>$("span").wrapAll("&lt;div&gt;&lt;div&gt;&lt;p&gt;&lt;em&gt;&lt;b&gt;&lt;/b&gt;&lt;/em&gt;&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;Span Text&lt;/span&gt;
  &lt;strong&gt;What about me?&lt;/strong&gt;
  &lt;span&gt;Another One&lt;/span&gt;</pre>
 * 
 * 
 * @param html A string of characters.String. A string of HTML that will be created on the fly and wrapped around the target..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.wrapAll = function (html) {
  return new jQuery();
};
/** <p>
 * Wrap all the elements in the matched set into a single wrapper element.</p>
 * <p>
 * This is different from &lt;a href='Manipulation/wrap'&gt;.wrap()&lt;/a&gt; where each element in the matched set would get wrapped with an element.<br>
</p>
 * 
 * 
 * Example:
 * Wrap a new div around all of the paragraphs.
 * <pre>$("p").wrapAll(document.createElement("div"));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;</pre>
 * 
 * Example:
 * Wrap a jQuery object double depth div around all of the paragraphs.  Notice it doesn't move the object but just clones it to wrap around its target.
 * <pre>$("p").wrapAll($(".doublediv"));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;
  &lt;div class="doublediv"&gt;&lt;div&gt;&lt;/div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param elem The Javascript object representation of a DOM Element.Element. A DOM element that will be wrapped around the target..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.wrapAll = function (elem) {
  return new jQuery();
};
/** <p>
 * Wrap the inner child contents of each matched element (including text nodes) with an HTML structure.</p>
 * <p>
 * This wrapping process is most useful for injecting additional structure into a document, without ruining the original semantic qualities of a document.

This works by going through the first element provided (which is generated, on the fly, from the provided HTML) and finds the deepest ancestor element within its structure -- it is that element that will enwrap everything else.<br>
</p>
 * 
 * 
 * Example:
 * Selects all paragraphs and wraps a bold tag around each of its contents.
 * <pre>$("p").wrapInner("&lt;b&gt;&lt;/b&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;

  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;</pre>
 * 
 * Example:
 * Wraps a newly created tree of objects around the inside of the body.
 * <pre>$("body").wrapInner("&lt;div&gt;&lt;div&gt;&lt;p&gt;&lt;em&gt;&lt;b&gt;&lt;/b&gt;&lt;/em&gt;&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;");</pre>
 * 
 * HTML:
 * <pre>Plain old text, or is it?</pre>
 * 
 * 
 * @param html A string of characters.String. A string of HTML that will be created on the fly and wrapped around the target..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.wrapInner = function (html) {
  return new jQuery();
};
/** <p>
 * Wrap the inner child contents of each matched element (including text nodes) with a DOM element.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Selects all paragraphs and wraps a bold tag around each of its contents.
 * <pre>$("p").wrapInner(document.createElement("b"));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;

  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;</pre>
 * 
 * Example:
 * Selects all paragraphs and wraps a jQuery object around each of its contents.
 * <pre>$("p").wrapInner($("&lt;span class='red'&gt;&lt;/span&gt;"));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;</pre>
 * 
 * 
 * @param elem The Javascript object representation of a DOM Element.Element. A DOM element that will be wrapped around the target..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.wrapInner = function (elem) {
  return new jQuery();
};
/** <p>
 * Replaces all matched elements with the specified HTML or DOM elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * On click, replace the button with a div containing the same word.
 * <pre>

    $("button").click(function () {
      $(this).replaceWith("&lt;div&gt;" + $(this).text() + "&lt;/div&gt;");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;First&lt;/button&gt;
  &lt;button&gt;Second&lt;/button&gt;

  &lt;button&gt;Third&lt;/button&gt;</pre>
 * 
 * Example:
 * Replace all the paragraphs with bold words.
 * <pre>$("p").replaceWith("&lt;b&gt;Paragraph. &lt;/b&gt;");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;p&gt;cruel&lt;/p&gt;

  &lt;p&gt;World&lt;/p&gt;</pre>
 * 
 * Example:
 * Replace all the paragraphs with empty div elements.
 * <pre>$("p").replaceWith(document.createElement("div"));</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;

  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;</pre>
 * 
 * Example:
 * On click, replace each paragraph with a jQuery div object that is already in the DOM.  Notice it doesn't clone the object but rather moves it to replace the paragraph.
 * <pre>
    $("p").click(function () {
      $(this).replaceWith($("div"));
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;

  &lt;div&gt;Replaced!&lt;/div&gt;</pre>
 * 
 * 
 * @param content String, Element, jQuery. Content to replace the matched elements with..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.replaceWith = function (content) {
  return new jQuery();
};
/** <p>
 * Replaces the elements matched by the specified selector with the matched elements.</p>
 * <p>
 * This function is the complement to replaceWith() which does the same task with the parameters reversed.<br>
</p>
 * 
 * 
 * Example:
 * Replace all the paragraphs with bold words.
 * <pre>$("&lt;b&gt;Paragraph. &lt;/b&gt;").replaceAll("p"); // check replaceWith() examples</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;

  &lt;p&gt;cruel&lt;/p&gt;
  &lt;p&gt;World&lt;/p&gt;</pre>
 * 
 * 
 * @param selector Selector. The elements to find and replace the matched elements with..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.replaceAll = function (selector) {
  return new jQuery();
};
/** <p>
 * Remove all child nodes from the set of matched elements.</p>
 * <p>
 * Note that this function starting with 1.2.2 will also remove all event handlers and internally cached data.<br>
</p>
 * 
 * 
 * Example:
 * Removes all child nodes (including text nodes) from all paragraphs
 * <pre>
    $("button").click(function () {
      $("p").empty();
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Hello, &lt;span&gt;Person&lt;/span&gt; &lt;a href="javascript:;"&gt;and person&lt;/a&gt;
  &lt;/p&gt;

  &lt;button&gt;Call empty() on above paragraph&lt;/button&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.empty = function () {
  return new jQuery();
};
/** <p>
 * Removes all matched elements from the DOM. </p>
 * <p>
 * This does NOT remove them from the jQuery object, allowing you to use the matched elements further.  Note that this function starting with 1.2.2 will also remove all event handlers and internally cached data.  So:

&lt;code&gt;
$("#foo").remove().appendTo("#bar");
&lt;/code&gt;

should be written as

&lt;code&gt;
$("#foo").appendTo("#bar");
&lt;/code&gt;

to avoid losing the event handlers.

Can be filtered with an optional expression.<br>
</p>
 * 
 * 
 * Example:
 * Removes all paragraphs from the DOM
 * <pre>
    $("button").click(function () {
      $("p").remove();
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt; 
  how are 
  &lt;p&gt;you?&lt;/p&gt;
  &lt;button&gt;Call remove() on paragraphs</pre>
 * 
 * Example:
 * Removes all paragraphs that contain "Hello" from the DOM
 * <pre>

    $("button").click(function () {
      $("p").remove(":contains('Hello')");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p class="hello"&gt;Hello&lt;/p&gt;
  how are 
  &lt;p&gt;you?&lt;/p&gt;

  &lt;button&gt;Call remove(":contains('Hello')") on paragraphs</pre>
 * 
 * 
 * @param expr A string of characters.String. A jQuery expression to filter the set of elements to be removed..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.remove = function (expr) {
  return new jQuery();
};
/** <p>
 * Clone matched DOM Elements and select the clones.</p>
 * <p>
 * This is useful for moving copies of the elements to another location in the DOM.<br>
</p>
 * 
 * 
 * Example:
 * Clones all b elements (and selects the clones) and prepends them to all paragraphs.
 * <pre>$("b").clone().prependTo("p");</pre>
 * 
 * HTML:
 * <pre>&lt;b&gt;Hello&lt;/b&gt;&lt;p&gt;, how are you?&lt;/p&gt;</pre>
 * 
 * Result:
 * <pre>&lt;b&gt;Hello&lt;/b&gt;&lt;p&gt;&lt;b&gt;Hello&lt;/b&gt;, how are you?&lt;/p&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.clone = function () {
  return new jQuery();
};
/** <p>
 * Clone matched DOM Elements, and all their event handlers, and select the clones.</p>
 * <p>
 * This is useful for moving copies of the elements, and their events, to another location in the DOM.<br>
</p>
 * 
 * 
 * Example:
 * Create a button that's able to clone itself - and have the clones themselves be clonable.
 * <pre>

    $("button").click(function(){
      $(this).clone(true).insertAfter(this);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Clone Me!&lt;/button&gt;</pre>
 * 
 * 
 * @param true true or false.Boolean. Set to true to enable cloning of event handlers..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.clone = function (aTrue) {
  return new jQuery();
};
/** <p>
 * Return a style property on the first matched element.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * To access the background color of a clicked div.
 * <pre>
    $("div").click(function () {
      var color = $(this).css("background-color");
      $("#result").html("That div is &lt;span style='color:" +
                         color + ";'&gt;" + color + "&lt;/span&gt;.");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;span id="result"&gt;&amp;nbsp;&lt;/span&gt;
  &lt;div style="background-color:blue;"&gt;&lt;/div&gt;
  &lt;div style="background-color:rgb(15,99,30);"&gt;&lt;/div&gt;

  &lt;div style="background-color:#123456;"&gt;&lt;/div&gt;
  &lt;div style="background-color:#f11;"&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param name A string of characters.String. The name of the property to access..
 * @return A string of characters.String
 * @since 1.0
 */
jQuery.css = function (name) {
  return "";
};
/** <p>
 * Set a key/value object as style properties to all matched elements.</p>
 * <p>
 * This is the best way to set several style properties on all matched elements.<br>
</p>
 * 
 * 
 * Example:
 * To set the color of all paragraphs to red and background to blue:
 * <pre>
    $("p").hover(function () {
      $(this).css({ backgroundColor:"yellow", fontWeight:"bolder" });
    }, function () {
      var cssObj = {
        backgroundColor: "#ddd",
        fontWeight: "",
        color: "rgb(0,40,244)"

      }
      $(this).css(cssObj);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Move the mouse over a paragraph.
  &lt;/p&gt;
  &lt;p&gt;
    Like this one or the one above.
  &lt;/p&gt;</pre>
 * 
 * Example:
 * If the property name includes a "-", put it between quotation marks:
 * <pre>

    $("p").hover(function () {
      $(this).css({ "background-color":"yellow", "font-weight":"bolder" });
    }, function () {
      var cssObj = {
        "background-color": "#ddd",
        "font-weight": "",
        color: "rgb(0,40,244)"

      }
      $(this).css(cssObj);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Move the mouse over a paragraph.
  &lt;/p&gt;
  &lt;p&gt;
    Like this one or the one above.
  &lt;/p&gt;</pre>
 * 
 * 
 * @param properties A Javascript object that contains key/value pairs in the form of properties and values.Map. Key/value pairs to set as style properties..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.css = function (properties) {
  return new jQuery();
};
/** <p>
 * Set a single style property to a value on all matched elements.</p>
 * <p>
 * If a number is provided, it is automatically converted into a pixel value.<br>
</p>
 * 
 * 
 * Example:
 * To change the color of any paragraph to red on mouseover event.
 * <pre>

    $("p").mouseover(function () {
      $(this).css("color","red");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Just roll the mouse over me.
  &lt;/p&gt;

  &lt;p&gt;
    Or me to see a color change.
  &lt;/p&gt;</pre>
 * 
 * Example:
 * To highlight a clicked word in the paragraph.
 * <pre>
    var words = $("p:first").text().split(" ");
    var text = words.join("&lt;/span&gt; &lt;span&gt;");
    $("p:first").html("&lt;span&gt;" + text + "&lt;/span&gt;");
    $("span").click(function () {
      $(this).css("background-color","yellow");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Once upon a time there was a man
    who lived in a pizza parlor. This
    man just loved pizza and ate it all 
    the time.  He went on to be the
    happiest man in the world.  The end.
  &lt;/p&gt;</pre>
 * 
 * 
 * @param name A string of characters.String. The name of the property to set..
 * @param value String or Number. The value to set the property to..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.css = function (name, value) {
  return new jQuery();
};
/** <p>
 * Get the current offset of the first matched element relative to the viewport.</p>
 * <p>
 * The returned object contains two &lt;a href='Types#Integer'&gt;Integer&lt;/a&gt; properties, top and left. The method works only with visible elements. <br>
</p>
 * 
 * 
 * Example:
 * Access the offset of the second paragraph:
 * <pre>var p = $("p:last");
var offset = p.offset();
p.html( "left: " + offset.left + ", top: " + offset.top );</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;&lt;p&gt;2nd Paragraph&lt;/p&gt;</pre>
 * 
 * Example:
 * Click to see the offset.
 * <pre>
    $("*", document.body).click(function (e) {
      var offset = $(this).offset();
      e.stopPropagation();
      $("#result").text(this.tagName + " coords ( " + offset.left + ", " +
                                      offset.top + " )");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div id="result"&gt;Click an element.&lt;/div&gt;
  &lt;p&gt;
    This is the best way to &lt;span&gt;find&lt;/span&gt; an offset.
  &lt;/p&gt;

  &lt;div class="abs"&gt;
  &lt;/dov&gt;
  </pre>
 * 
 * 
 * @return Object{top,left}
 * @since 1.2
 */
jQuery.offset = function () {
  return ;
};
/** <p>
 * Get the current computed, pixel, height of the first matched element.</p>
 * <p>
 * In jQuery 1.2, this method is able to find the height of the window and document.<br>
</p>
 * 
 * 
 * Example:
 * Show various heights.  Note the values are from the iframe so might be smaller than you expected.  The yellow highlight shows the iframe body.
 * <pre>
    function showHeight(ele, h) {
      $("div").text("The height for the " + ele + 
                    " is " + h + "px.");
    }
    $("#getp").click(function () { 
      showHeight("paragraph", $("p").height()); 
    });
    $("#getd").click(function () { 
      showHeight("document", $(document).height()); 
    });
    $("#getw").click(function () { 
      showHeight("window", $(window).height()); 
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="getp"&gt;Get Paragraph Height&lt;/button&gt;
  &lt;button id="getd"&gt;Get Document Height&lt;/button&gt;
  &lt;button id="getw"&gt;Get Window Height&lt;/button&gt;

  &lt;div&gt;&amp;nbsp;&lt;/div&gt;
  &lt;p&gt;
    Sample paragraph to test height
  &lt;/p&gt;</pre>
 * 
 * 
 * @return Integer
 * @since 1.0
 */
jQuery.height = function () {
  return ;
};
/** <p>
 * Set the CSS height of every matched element.</p>
 * <p>
 * If no explicit unit was specified (like 'em' or '%') then "px" is concatenated to the value.<br>
</p>
 * 
 * 
 * Example:
 * To set the height of each div on click to 30px plus a color change.
 * <pre>

    $("div").one('click', function () {
      $(this).height(30)
             .css({cursor:"auto", backgroundColor:"green"});
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param val String or Number. Set the CSS 'height' property to the specified value..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.height = function (val) {
  return new jQuery();
};
/** <p>
 * Get the current computed, pixel, width of the first matched element.</p>
 * <p>
 * In jQuery 1.2, this method is able to find the width of the window and document.<br>
</p>
 * 
 * 
 * Example:
 * Show various widths.  Note the values are from the iframe so might be smaller than you expected.  The yellow highlight shows the iframe body.
 * <pre>
    function showWidth(ele, w) {
      $("div").text("The width for the " + ele + 
                    " is " + w + "px.");
    }
    $("#getp").click(function () { 
      showWidth("paragraph", $("p").width()); 
    });
    $("#getd").click(function () { 
      showWidth("document", $(document).width()); 
    });
    $("#getw").click(function () { 
      showWidth("window", $(window).width()); 
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="getp"&gt;Get Paragraph Width&lt;/button&gt;
  &lt;button id="getd"&gt;Get Document Width&lt;/button&gt;
  &lt;button id="getw"&gt;Get Window Width&lt;/button&gt;

  &lt;div&gt;&amp;nbsp;&lt;/div&gt;
  &lt;p&gt;
    Sample paragraph to test width
  &lt;/p&gt;</pre>
 * 
 * 
 * @return Integer
 * @since 1.0
 */
jQuery.width = function () {
  return ;
};
/** <p>
 * Set the CSS width of every matched element.</p>
 * <p>
 * If no explicit unit was specified (like 'em' or '%') then "px" is concatenated to the value.<br>
</p>
 * 
 * 
 * Example:
 * To set the width of each div on click to 30px plus a color change.
 * <pre>

    $("div").one('click', function () {
      $(this).width(30)
             .css({cursor:"auto", "background-color":"blue"});
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param val String, Number. Set the CSS 'width' property to the specified value..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.width = function (val) {
  return new jQuery();
};
/** <p>
 * Binds a function to be executed whenever the DOM is ready to be traversed and manipulated.</p>
 * <p>
 * &lt;p&gt;This is probably the most important function included in the event module, as it can greatly improve the response times of your web applications.&lt;/p&gt;&lt;p&gt;In a nutshell, this is a solid replacement for using window.onload, and attaching a function to that. By using this method, your bound function will be called the instant the DOM is ready to be read and manipulated, which is when what 99.99% of all JavaScript code needs to run.&lt;/p&gt;&lt;p&gt;There is one argument passed to the ready event handler: A reference to the jQuery function. You can name that argument whatever you like, and can therefore stick with the $ alias without risk of naming collisions.&lt;/p&gt;&lt;p&gt;Please ensure you have no code in your &lt;body&gt; onload event handler, otherwise $(document).ready() may not fire.&lt;/p&gt;&lt;p&gt;You can have as many $(document).ready events on your page as you like. The functions are then executed in the order they were added.&lt;/p&gt;<br>
</p>
 * 
 * 
 * Example:
 * Display a message when the DOM is loaded.
 * <pre>$("p").text("The DOM is now loaded and can be manipulated.");</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
  &lt;/p&gt;</pre>
 * 
 * Example:
 * To run code when the DOM loads, write:
 * <pre>$(document).ready(function(){
  // Your code here...
});</pre>
 * 
 * Example:
 * To use both the shortcut for $(document).ready() and the argument to write failsafe jQuery code using the $ alias, without relying on the global alias, write:
 * <pre>jQuery(function($) {
  // Your code using failsafe $ alias here...
});</pre>
 * 
 * Example:
 * Commonly written as:
 * <pre>$(function() {
  // Your code here...
});</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. The function to be executed when the DOM is ready.

&lt;pre&gt;function callback(jQueryReference) {
  this; // document
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.ready = function (fn) {
  return new jQuery();
};
/** <p>
 * Binds a handler to a particular event (like click) for each matched element.  Can also bind custom events.</p>
 * <p>
 * The event handler is passed an event object that you can use to prevent default behaviour. To stop both default action and event bubbling, your handler has to return false. Note that this will prevent handlers on parent elements from running but not other jQuery handlers on the same element.

In most cases, you can define your event handlers as anonymous functions (see first example). In cases where that is not possible, you can pass additional data as the second parameter (and the handler function as the third), see second example.<br>
</p>
 * 
 * 
 * Example:
 * Handle click and double-click for the paragraph.  Note: the coordinates are window relative so in this case relative to the demo iframe.
 * <pre>
    $("p").bind("click", function(e){
      var str = "( " + e.pageX + ", " + e.pageY + " )";
      $("span").text("Click happened! " + str);
    });
    $("p").bind("dblclick", function(){
      $("span").text("Double-click happened in " + this.tagName);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Click or double click here.&lt;/p&gt;
  &lt;span&gt;&lt;/span&gt;</pre>
 * 
 * Example:
 * To display each paragraph's text in an alert box whenever it is clicked:
 * <pre>$("p").bind("click", function(){
  alert( $(this).text() );
});</pre>
 * 
 * Example:
 * You can pass some extra data before the event handler:
 * <pre>function handler(event) {
  alert(event.data.foo);
}
$("p").bind("click", {foo: "bar"}, handler)</pre>
 * 
 * Example:
 * To cancel a default action and prevent it from bubbling up, return false:
 * <pre>$("form").bind("submit", function() { return false; })</pre>
 * 
 * Example:
 * To cancel only the default action by using the preventDefault method.
 * <pre>$("form").bind("submit", function(event){
  event.preventDefault();
});</pre>
 * 
 * Example:
 * Stop only an event from bubbling by using the stopPropagation method.
 * <pre>$("form").bind("submit", function(event){
  event.stopPropagation();
});</pre>
 * 
 * Example:
 * Can bind custom events too.
 * <pre>

    $("p").bind("myCustomEvent", function(e, myName, myValue){
      $(this).text(myName + ", hi there!");
      $("span").stop().css("opacity", 1)
               .text("myName = " + myName)
               .fadeIn(30).fadeOut(1000);
    });
    $("button").click(function () {
      $("p").trigger("myCustomEvent", [ "John" ]);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Has an attached custom event.&lt;/p&gt;
  &lt;button&gt;Trigger custom event&lt;/button&gt;
  &lt;span style="display:none;"&gt;&lt;/span&gt;</pre>
 * 
 * 
 * @param type A string of characters.String. An event type.
 * @param data A simple Javascript object..Object. Additional data passed to the event handler as event.data.
 * @param fn A reference to a Javascript function.Function. A function to bind to the event on each of the set of matched elements

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.bind = function (type, data, fn) {
  return new jQuery();
};
/** <p>
 * Binds a handler to a particular event to be executed &lt;i&gt;once&lt;/i&gt; for each matched element.</p>
 * <p>
 * &lt;p&gt;The handler is executed only once for each element. Otherwise, the same rules as described in &lt;a href='Events/bind'&gt;bind&lt;/a&gt;() apply. The event handler is passed an event object that you can use to prevent default behaviour. To stop both default action and event bubbling, your handler should return false.&lt;/p&gt;&lt;p&gt;In most cases, you can define your event handlers as anonymous functions (see first example). In cases where that is not possible, you can pass additional data as the second paramter (and the handler function as the third), see second example.&lt;/p&gt;<br>
</p>
 * 
 * 
 * Example:
 * Tie a one-time click to each div.
 * <pre>
    var n = 0;
    $("div").one("click", function(){
      var index = $("div").index(this);
      $(this).css({ borderStyle:"inset",
                    cursor:"auto" });
      $("p").text("Div at index #" + index + " clicked." +
                  "  That's " + ++n + " total clicks.");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;
  &lt;p&gt;Click a green square...&lt;/p&gt;</pre>
 * 
 * Example:
 * To display the text of all paragraphs in an alert box the first time each of them is clicked:
 * <pre>$("p").one("click", function(){
  alert( $(this).text() );
});</pre>
 * 
 * 
 * @param type A string of characters.String. An event type.
 * @param data A simple Javascript object..Object. Additional data passed to the event handler as event.data.
 * @param fn A reference to a Javascript function.Function. A function to bind to the specified event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.one = function (type, data, fn) {
  return new jQuery();
};
/** <p>
 * Trigger a type of event on every matched element.</p>
 * <p>
 * &lt;p&gt;This will also cause the default action of the browser with the same name (if one exists) to be executed. For example, passing 'submit' to the trigger() function will also cause the browser to submit the form. This default action can be prevented by returning false from one of the functions bound to the event.&lt;/p&gt;&lt;p&gt;You can also trigger custom events registered with bind.&lt;/p&gt;<br>
</p>
 * 
 * 
 * Example:
 * Clicks to button #2 also trigger a click for button #1.
 * <pre>

    $("button:first").click(function () {
      update($("span:first"));
    });
    $("button:last").click(function () {
      $("button:first").trigger('click');

      update($("span:last"));
    });

    function update(j) {
      var n = parseInt(j.text(), 0);
      j.text(n + 1);
    }
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Button #1&lt;/button&gt;

  &lt;button&gt;Button #2&lt;/button&gt;
  &lt;div&gt;&lt;span&gt;0&lt;/span&gt; button #1 clicks.&lt;/div&gt;
  &lt;div&gt;&lt;span&gt;0&lt;/span&gt; button #2 clicks.&lt;/div&gt;</pre>
 * 
 * Example:
 * To submit the first form without using the submit() function, try:
 * <pre>$("form:first").trigger("submit")</pre>
 * 
 * Example:
 * To pass arbitrary data to an event:
 * <pre>$("p").click( function (event, a, b) {
  // when a normal click fires, a and b are undefined
  // for a trigger like below a refers too "foo" and b refers to "bar"

} ).trigger("click", ["foo", "bar"]);</pre>
 * 
 * Example:
 * This would display a "Hello World!" alert box.
 * <pre>$("p").bind("myEvent", function (event, message1, message2) {
  alert(message1 + ' ' + message2);
});
$("p").trigger("myEvent", ["Hello","World!"]);</pre>
 * 
 * 
 * @param type  A string of characters.String. An event type to trigger..
 * @param data  Array. Additional data to pass as arguments (after the event object) to the event handler..
 * @return A jQuery object.jQuery
 */
jQuery.trigger = function (type , data ) {
  return new jQuery();
};
/** <p>
 * This particular method triggers all bound event handlers on an element (for a specific event type) WITHOUT executing the browsers default actions.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * If you called .triggerHandler() on a focus event - the browsers default focus action would not be triggered, only the event handlers bound to the focus event.
 * <pre>

    $("#old").click(function(){
      $("input").trigger("focus");
    });
    $("#new").click(function(){
      $("input").triggerHandler("focus");
    });
    $("input").focus(function(){
      $("&lt;span&gt;Focused!&lt;/span&gt;").appendTo("body").fadeOut(1000);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="old"&gt;.trigger("focus")&lt;/button&gt;
  &lt;button id="new"&gt;.triggerHandler("focus")&lt;/button&gt;&lt;br/&gt;&lt;br/&gt;

  &lt;input type="text" value="To Be Focused"/&gt;</pre>
 * 
 * 
 * @param type  A string of characters.String. An event type to trigger..
 * @param data  Array. Additional data to pass as arguments (after the event object) to the event handler..
 * @return A jQuery object.jQuery
 */
jQuery.triggerHandler = function (type , data ) {
  return new jQuery();
};
/** <p>
 * This does the opposite of bind, it removes bound events from each of the matched elements.</p>
 * <p>
 * &lt;p&gt;Without any arguments, all bound events are removed.&lt;/p&gt;&lt;p&gt;You can also unbind custom events registered with bind.&lt;/p&gt;&lt;p&gt;If the type is provided, all bound events of that type are removed.&lt;/p&gt;&lt;p&gt;If the function that was passed to bind is provided as the second argument, only that specific event handler is removed.&lt;/p&gt;<br>
</p>
 * 
 * 
 * Example:
 * Can bind and unbind events to the colored button.
 * <pre>

    function aClick() {
      $("div").show().fadeOut("slow");
    }
    $("#bind").click(function () {
      // could use .bind('click', aClick) instead but for variety...
      $("#theone").click(aClick)
                  .text("Can Click!");
    });
    $("#unbind").click(function () {
      $("#theone").unbind('click', aClick)
                  .text("Does nothing...");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="theone"&gt;Does nothing...&lt;/button&gt;
  &lt;button id="bind"&gt;Bind Click&lt;/button&gt;
  &lt;button id="unbind"&gt;Unbind Click&lt;/button&gt;

  &lt;div style="display:none;"&gt;Click!&lt;/div&gt;</pre>
 * 
 * Example:
 * To unbind all events from all paragraphs, write:
 * <pre>$("p").unbind()</pre>
 * 
 * Example:
 * To unbind all click events from all paragraphs, write:
 * <pre>$("p").unbind( "click" )</pre>
 * 
 * Example:
 * To unbind just one previously bound handler, pass the function in as the second argument:
 * <pre>var foo = function () {
  // code to handle some kind of event
};

$("p").bind("click", foo); // ... now foo will be called when paragraphs are clicked ...

$("p").unbind("click", foo); // ... foo will no longer be called.</pre>
 * 
 * 
 * @param type  A string of characters.String. An event type to unbind..
 * @param data  A reference to a Javascript function.Function. A function to unbind from the event on each of the set of matched elements..
 * @return A jQuery object.jQuery
 */
jQuery.unbind = function (type , data ) {
  return new jQuery();
};
/** <p>
 * Simulates hovering (moving the mouse on, and off, an object). This is a custom method which provides an 'in' to a frequent task.</p>
 * <p>
 * Whenever the mouse cursor is moved over a matched element, the first specified function is fired. Whenever the mouse moves off of the element, the second specified function fires. Additionally, checks are in place to see if the mouse is still within the specified element itself (for example, an image inside of a div), and if it is, it will continue to 'hover', and not move out (a common error in using a mouseout event handler).<br>
</p>
 * 
 * 
 * Example:
 * To add a special style to table cells that are being hovered over, try:
 * <pre>
    $("li").hover(
      function () {
        $(this).append($("&lt;span&gt; ***&lt;/span&gt;"));
      }, 
      function () {
        $(this).find("span:last").remove();
      }
    );

</pre>
 * 
 * HTML:
 * <pre>&lt;ul&gt;
    &lt;li&gt;Milk&lt;/li&gt;
    &lt;li&gt;Bread&lt;/li&gt;
    &lt;li&gt;Chips&lt;/li&gt;

    &lt;li&gt;Socks&lt;/li&gt;
  &lt;/ul&gt;</pre>
 * 
 * Example:
 * To add a special style to table cells that are being hovered over, try:
 * <pre>$("td").hover(
  function () {
    $(this).addClass("hover");
  },
  function () {
    $(this).removeClass("hover");
  }
);</pre>
 * 
 * 
 * @param over A reference to a Javascript function.Function. The function to fire when the mouse is moved over a matched element.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @param out A reference to a Javascript function.Function. The function to fire when the mouse is moved off of a matched element.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.hover = function (over, out) {
  return new jQuery();
};
/** <p>
 * Toggle between two function calls every other click.</p>
 * <p>
 * &lt;p&gt;Whenever a matched element is clicked, the first specified function is fired, when clicked again, the second is fired. All subsequent clicks continue to rotate through the two functions.&lt;/p&gt;&lt;p&gt;Use unbind("click") to remove.&lt;/p&gt;<br>
</p>
 * 
 * 
 * Example:
 * Click to toggle highlight on the list item.
 * <pre>
    $("li").toggle(
      function () {
        $(this).css("list-style-type", "disc")
               .css("color", "blue");
      },
      function () {
        $(this).css({"list-style-type":"", "color":""});
      }
    );

</pre>
 * 
 * HTML:
 * <pre>&lt;ul&gt;
    &lt;li&gt;Go to the store&lt;/li&gt;
    &lt;li&gt;Pick up dinner&lt;/li&gt;
    &lt;li&gt;Debug crash&lt;/li&gt;

    &lt;li&gt;Take a jog&lt;/li&gt;
  &lt;/ul&gt;</pre>
 * 
 * Example:
 * To toggle a style on table cells:
 * <pre>$("td").toggle(
  function () {
    $(this).addClass("selected");
  },
  function () {
    $(this).removeClass("selected");
  }
);</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. The function to execute on every even click.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @param fn A reference to a Javascript function.Function. The function to execute on every odd click.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.toggle = function (fn, fn) {
  return new jQuery();
};
/** <p>
 * Triggers the blur event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to that blur event to be executed, and calls the browser's default blur action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the blur event. The blur event usually fires when an element loses focus either via the pointing device or by tabbing navigation<br>
</p>
 * 
 * 
 * Example:
 * To triggers the blur event on all paragraphs:
 * <pre>$("p").blur();</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.blur = function () {
  return new jQuery();
};
/** <p>
 * Bind a function to the blur event of each matched element.</p>
 * <p>
 * The blur event fires when an element loses focus either via the pointing device or by tabbing navigation.<br>
</p>
 * 
 * 
 * Example:
 * To pop up an alert saying "Hello World!" every time any paragraph's blur event triggers:
 * <pre>$("p").blur( function () { alert("Hello World!"); } );</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the blur event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.blur = function (fn) {
  return new jQuery();
};
/** <p>
 * Triggers the change event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to that change event to be executed, and calls the browser's default change action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the change event. The change event usually fires when a control loses the input focus and its value has been modified since gaining focus.<br>
</p>
 * 
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.change = function () {
  return new jQuery();
};
/** <p>
 * Binds a function to the change event of each matched element.</p>
 * <p>
 * The change event fires when a control loses the input focus and its value has been modified since gaining focus.<br>
</p>
 * 
 * 
 * Example:
 * Attaches a change even to the select that gets the text for each selected option and writes them in the div.  It then triggers the event for the initial text draw.
 * <pre>
    $("select").change(function () {
          var str = "";
          $("select option:selected").each(function () {
                str += $(this).text() + " ";
              });
          $("div").text(str);
        })
        .change();
</pre>
 * 
 * HTML:
 * <pre>&lt;select name="sweets" multiple="multiple"&gt;
    &lt;option&gt;Chocolate&lt;/option&gt;
    &lt;option selected="selected"&gt;Candy&lt;/option&gt;

    &lt;option&gt;Taffy&lt;/option&gt;
    &lt;option selected="selected"&gt;Carmel&lt;/option&gt;
    &lt;option&gt;Fudge&lt;/option&gt;
    &lt;option&gt;Cookie&lt;/option&gt;

  &lt;/select&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * To add a validity test to all text input elements:
 * <pre>$("input[@type='text']").change( function() {
  // check input for validity here
});</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the change event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.change = function (fn) {
  return new jQuery();
};
/** <p>
 * Triggers the click event of each matched element.</p>
 * <p>
 * Causes all of the functions that have been bound to that click event to be executed.<br>
</p>
 * 
 * 
 * Example:
 * To trigger the click event on all of the paragraphs on the page:
 * <pre>$("p").click();</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.click = function () {
  return new jQuery();
};
/** <p>
 * Binds a function to the click event of each matched element.</p>
 * <p>
 * The click event fires when the pointing device button is clicked over an element. A click is defined as a mousedown and mouseup over the same screen location. The sequence of these events is:&lt;ul&gt;&lt;li&gt;mousedown&lt;/li&gt;&lt;li&gt;mouseup&lt;/li&gt;&lt;li&gt;click&lt;/li&gt;&lt;/ul&gt;<br>
</p>
 * 
 * 
 * Example:
 * To hide paragraphs on a page when they are clicked:
 * <pre>
    $("p").click(function () { 
      $(this).slideUp(); 
    });
    $("p").hover(function () {
      $(this).addClass("hilite");
    }, function () {
      $(this).removeClass("hilite");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;First Paragraph&lt;/p&gt;

  &lt;p&gt;Second Paragraph&lt;/p&gt;
  &lt;p&gt;Yet one more Paragraph&lt;/p&gt;</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the click event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.click = function (fn) {
  return new jQuery();
};
/** <p>
 * Triggers the dblclick event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to that dblclick event to be executed, and calls the browser's default dblclick action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the dblclick event. The dblclick event usually fires when the pointing device button is double clicked over an element.<br>
</p>
 * 
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.dblclick = function () {
  return new jQuery();
};
/** <p>
 * Binds a function to the dblclick event of each matched element.</p>
 * <p>
 * The dblclick event fires when the pointing device button is double clicked over an element<br>
</p>
 * 
 * 
 * Example:
 * To bind a "Hello World!" alert box the dblclick event on every paragraph on the page:
 * <pre>$("p").dblclick( function () { alert("Hello World!"); });</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. The function to bind to the dblclick event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}

&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.dblclick = function (fn) {
  return new jQuery();
};
/** <p>
 * Triggers the error event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to that error event to be executed, and calls the browser's default error action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the error event. The error event usually fires when an element loses focus either via the pointing device or by tabbing navigation.<br>
</p>
 * 
 * 
 * 
 * @return A jQuery object.jQuery
 */
jQuery.error = function () {
  return new jQuery();
};
/** <p>
 * Binds a function to the error event of each matched element.</p>
 * <p>
 * &lt;p&gt;There is no public standard for the error event. In most browsers, the window object's error event is triggered when a JavaScript error occurs on the page. An image object's error event is triggered when it is set an invalid src attribute - either a non-existent file, or one with corrupt image data.&lt;/p&gt;&lt;p&gt;If the event is thrown by the window object, the event handler will be passed three parameters: &lt;ol&gt;&lt;li&gt;A message describing the event ("varName is not defined", "missing operator in expression", etc.),&lt;/li&gt;&lt;li&gt;the full URL of the document containing the error, and&lt;/li&gt;&lt;li&gt;the line number on which the error occured.&lt;/li&gt;&lt;/ol&gt;&lt;/p&gt;

&lt;p&gt;If the event handler returns true, it signifies that the event was handled, and the browser raises no errors.&lt;/p&gt;&lt;p&gt;For more information, see: &lt;ul&gt;&lt;li&gt;[http://msdn2.microsoft.com/en-us/library/ms536930.aspx msdn - onerror Event]&lt;/li&gt;&lt;li&gt;[http://developer.mozilla.org/en/docs/DOM:window.onerror Gecko DOM Reference - onerror Event]&lt;/li&gt;&lt;li&gt;[http://developer.mozilla.org/en/docs/DOM:event Gecko DOM Reference - Event object]&lt;/li&gt;&lt;li&gt;[http://en.wikipedia.org/wiki/DOM_Events Wikipedia: DOM Events]&lt;/ul&gt;&lt;/p&gt;<br>
</p>
 * 
 * 
 * Example:
 * To keep a server-side log of JavaScript errors, you might want to:
 * <pre>$(window).error(function(msg, url, line){
  jQuery.post("js_error_log.php", { msg: msg, url: url, line: line });
});</pre>
 * 
 * Example:
 * To hide JavaScript errors from the user, you can try:
 * <pre>$(window).error(function(){
  return true;
});</pre>
 * 
 * Example:
 * To hide the "broken image" icons for your IE users, you can try:
 * <pre>$("img").error(function(){
  $(this).hide();
});</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. An event handler function to bind to the error event.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.error = function (fn) {
  return new jQuery();
};
/** <p>
 * Triggers the focus event of each matched element. </p>
 * <p>
 * This causes all of the functions that have been bound to the focus event to be executed. Note that this does not execute the focus method of the underlying elements.<br>
</p>
 * 
 * 
 * Example:
 * To focus on a login input box with id 'login' on page startup, try:
 * <pre>$(document).ready(function(){
  $("#login").focus();
});</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 */
jQuery.focus = function () {
  return new jQuery();
};
/** <p>
 * Binds a function to the focus event of each matched element.</p>
 * <p>
 * The focus event fires when an element receives focus either via the pointing device or by tab navigation.<br>
</p>
 * 
 * 
 * Example:
 * To stop people from writing in text input boxes, try:
 * <pre>$("input[@type=text]").focus(function(){
  $(this).blur();
});</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the focus event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.focus = function (fn) {
  return new jQuery();
};
/** <p>
 * Triggers the keydown event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to the keydown event to be executed, and calls the browser's default keydown action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the keydown event. The keydown event usually fires when a key on the keyboard is pressed.<br>
</p>
 * 
 * 
 * 
 * @return A jQuery object.jQuery
 */
jQuery.keydown = function () {
  return new jQuery();
};
/** <p>
 * Bind a function to the keydown event of each matched element.</p>
 * <p>
 * The keydown event fires when a key on the keyboard is pressed.<br>
</p>
 * 
 * 
 * Example:
 * To perform actions in response to keyboard presses on a page, try:
 * <pre>$(window).keydown(function(event){
  switch (event.keyCode) {
    // ...
    // different keys do different things
    // Different browsers provide different codes
    // see here for details: http://unixpapa.com/js/key.html    
    // ...
  }
});</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the keydown event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.keydown = function (fn) {
  return new jQuery();
};
/** <p>
 * Triggers the keypress event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to the keypress event to be executed, and calls the browser's default keypress action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the keypress event. The keypress event usually fires when a key on the keyboard is pressed.

<br>
</p>
 * 
 * 
 * 
 * @return A jQuery object.jQuery
 */
jQuery.keypress = function () {
  return new jQuery();
};
/** <p>
 * Binds a function to the keypress event of each matched element.</p>
 * <p>
 * The keypress event fires when a key on the keyboard is "clicked". A keypress is defined as a keydown and keyup on the same key. The sequence of these events is: &lt;ul&gt;&lt;li&gt;keydown&lt;/li&gt;&lt;li&gt;keyup&lt;/li&gt;&lt;li&gt;keypress&lt;/li&gt;&lt;/ul&gt;<br>
</p>
 * 
 * 
 * Example:
 * Show spaces and letters when typed.
 * <pre>
    $("input").keypress(function (e) {
      if (e.which == 32 || (65 &lt;= e.which &amp;&amp; e.which &lt;= 65 + 25)
                        || (97 &lt;= e.which &amp;&amp; e.which &lt;= 97 + 25)) {
        var c = String.fromCharCode(e.which);
        $("p").append($("&lt;span/&gt;"))
              .children(":last")
              .append(document.createTextNode(c));
      } else if (e.which == 8) {
        // backspace in IE only be on keydown
        $("p").children(":last").remove();
      }
      $("div").text(e.which);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;input type="text" /&gt;
  &lt;p&gt;Add text - &lt;/p&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the keypress event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}

&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.keypress = function (fn) {
  return new jQuery();
};
/** <p>
 * Triggers the keyup event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to the keyup event to be executed, and calls the browser's default keyup action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the keyup event. The keyup event usually fires when a key on the keyboard is released.<br>
</p>
 * 
 * 
 * 
 * @return A jQuery object.jQuery
 */
jQuery.keyup = function () {
  return new jQuery();
};
/** <p>
 * Bind a function to the keyup event of each matched element.</p>
 * <p>
 * The keyup event fires when a key on the keyboard is released.<br>
</p>
 * 
 * 
 * Example:
 * To perform an action when the escape key has been released:
 * <pre>$(document).keyup(function(event){
    if (event.keyCode == 27) {
        alert('escaped!');
    }
});</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the keyup event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.keyup = function (fn) {
  return new jQuery();
};
/** <p>
 * Binds a function to the load event of each matched element.</p>
 * <p>
 * When bound to the window element, the event fires when the user agent finishes loading all content within a document, including window, frames, objects and images. For elements, it fires when the target element and all of its content has finished loading.<br>
</p>
 * 
 * 
 * Example:
 * Run a function when the page is fully loaded including graphics.
 * <pre>
    $(window).load(function () {
      // run code
    });
</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the load event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.load  = function (fn) {
  return new jQuery();
};
/** <p>
 * Binds a function to the mousedown event of each matched element.</p>
 * <p>
 * The mousedown event fires when the pointing device button is pressed over an element.<br>
</p>
 * 
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the mousedown event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.mousedown  = function (fn) {
  return new jQuery();
};
/** <p>
 * Bind a function to the mousemove event of each matched element.</p>
 * <p>
 * The mousemove event fires when the pointing device is moved while it is over an element. The event handler is passed one variable - the event object. Its .clientX and .clientY properties represent the coordinates of the mouse.<br>
</p>
 * 
 * 
 * Example:
 * Show the mouse coordinates when the mouse is moved over the yellow div.  Coordinates are relative to the window which in this case is the iframe.
 * <pre>
    $("div").mousemove(function(e){
      var pageCoords = "( " + e.pageX + ", " + e.pageY + " )";
      var clientCoords = "( " + e.clientX + ", " + e.clientY + " )";
      $("span:first").text("( e.pageX, e.pageY ) - " + pageCoords);
      $("span:last").text("( e.clientX, e.clientY ) - " + clientCoords);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;   
    Try scrolling too.
    &lt;span&gt;Move the mouse over the div.&lt;/span&gt;
    &lt;span&gt;&amp;nbsp;&lt;/span&gt;
  &lt;/p&gt;

  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the mousmove event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.mousemove = function (fn) {
  return new jQuery();
};
/** <p>
 * Bind a function to the mouseout event of each matched element.</p>
 * <p>
 * The mouseout event fires when the pointing device is moved away from an element.<br>
</p>
 * 
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the mouseout event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.mouseout = function (fn) {
  return new jQuery();
};
/** <p>
 * Bind a function to the mouseover event of each matched element.</p>
 * <p>
 * The mouseout event fires when the pointing device is moved onto an element.<br>
</p>
 * 
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the mouseover event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.mouseover = function (fn) {
  return new jQuery();
};
/** <p>
 * Bind a function to the mouseup event of each matched element.</p>
 * <p>
 * The mouseup event fires when the pointing device button is released over an element.<br>
</p>
 * 
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the mouseup event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.mouseup = function (fn) {
  return new jQuery();
};
/** <p>
 * Bind a function to the resize event of each matched element.</p>
 * <p>
 * The resize event fires when a document view is resized<br>
</p>
 * 
 * 
 * Example:
 * To make resizing the web page window a pain in the neck, try:
 * <pre>$(window).resize(function(){
  alert("Stop it!");
});</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the resize event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.resize = function (fn) {
  return new jQuery();
};
/** <p>
 * Bind a function to the scroll event of each matched element.</p>
 * <p>
 * The scroll event fires when a document view is scrolled.<br>
</p>
 * 
 * 
 * Example:
 * To do something when your page is scrolled:
 * <pre>
    $("p").clone().appendTo(document.body);
    $("p").clone().appendTo(document.body);
    $("p").clone().appendTo(document.body);
    $(window).scroll(function () { 
      $("span").css("display", "inline").fadeOut("slow"); 
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;Try scrolling the iframe.&lt;/div&gt;
  &lt;p&gt;Paragraph - &lt;span&gt;Scroll happened!&lt;/span&gt;&lt;/p&gt;</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the scroll event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}

&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.scroll = function (fn) {
  return new jQuery();
};
/** <p>
 * Trigger the select event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to that select event to be executed, and calls the browser's default select action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the select event.<br>
</p>
 * 
 * 
 * Example:
 * To trigger the select event on all input elements, try:
 * <pre>$("input").select();</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 */
jQuery.select = function () {
  return new jQuery();
};
/** <p>
 * Bind a function to the select event of each matched element.</p>
 * <p>
 * The select event fires when a user selects some text in a text field, including input and textarea.<br>
</p>
 * 
 * 
 * Example:
 * To do something when text in input boxes is selected:
 * <pre>
    $(document).select( function () { 
      $("div").text("Something was selected").show().fadeOut(1000); 
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Click and drag the mouse to select text in the inputs.
  &lt;/p&gt;

  &lt;input type="text" value="Some text" /&gt;
  &lt;input type="text" value="to test on" /&gt;

  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the select event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.select = function (fn) {
  return new jQuery();
};
/** <p>
 * Trigger the submit event of each matched element.</p>
 * <p>
 * This causes all of the functions that have been bound to that submit event to be executed, and calls the browser's default submit action on the matching element(s). This default action can be prevented by returning false from one of the functions bound to the submit event.<br>
</p>
 * 
 * 
 * Example:
 * To trigger the submit event on the first form on the page, try:
 * <pre>$("form:first").submit();</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 */
jQuery.submit = function () {
  return new jQuery();
};
/** <p>
 * Bind a function to the submit event of each matched element.</p>
 * <p>
 * The select event fires when a form is submitted<br>
</p>
 * 
 * 
 * Example:
 * If you'd like to prevent forms from being submitted unless a flag variable is set, try:
 * <pre>

    $("form").submit(function() {
      if ($("input:first").val() == "correct") {
        $("span").text("Validated...").show();
        return true;
      }
      $("span").text("Not valid!").show().fadeOut(1000);
      return false;
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Type 'correct' to validate.&lt;/p&gt;
  &lt;form action="javascript:alert('success!');"&gt;
    &lt;div&gt;
      &lt;input type="text" /&gt;

      &lt;input type="submit" /&gt;
    &lt;/div&gt;
  &lt;/form&gt;
  &lt;span&gt;&lt;/span&gt;</pre>
 * 
 * Example:
 * If you'd like to prevent forms from being submitted unless a flag variable is set, try:
 * <pre>$("form").submit( function () {
  return this.some_flag_variable;
} );</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. A function to bind to the submit event on each of the matched elements.
&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.submit = function (fn) {
  return new jQuery();
};
/** <p>
 * Binds a function to the unload event of each matched element.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * To display an alert when a page is unloaded:
 * <pre>$(window).unload( function () { alert("Bye now!"); } );</pre>
 * 
 * 
 * @param fn A reference to a Javascript function.Function. function to bind to the unload event on each of the matched elements.

&lt;pre&gt;function callback(eventObject) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 */
jQuery.unload = function (fn) {
  return new jQuery();
};
/** <p>
 * Displays each of the set of matched elements if they are hidden.</p>
 * <p>
 * Same as &lt;a href='Effects/show#speedcallback'&gt;show( speed, [callback] )&lt;/a&gt; without animations. Doesn't change anything if the selected elements are all visible. It doesn't matter if the element is hidden via a hide() call, or via a display:none in a stylesheet.<br>
</p>
 * 
 * 
 * Example:
 * Shows all paragraphs.
 * <pre>$("p").show()</pre>
 * 
 * HTML:
 * <pre>&lt;p style="display:none"&gt;Hello&lt;/p&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.show = function () {
  return new jQuery();
};
/** <p>
 * Show all matched elements using a graceful animation and firing an optional callback after completion.</p>
 * <p>
 * The height, width, and opacity of each of the matched elements are changed dynamically according to the specified speed.<br>
</p>
 * 
 * 
 * Example:
 * Animates all hidden paragraphs to show slowly, completing the animation within 600 milliseconds.
 * <pre>
    $("button").click(function () {
      $("p").show("slow");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Show it&lt;/button&gt;

  &lt;p style="display: none"&gt;Hello&lt;/p&gt;</pre>
 * 
 * Example:
 * Animates all hidden divs to show fastly in order, completing each animation within 200 milliseconds. Once each animation is done, it starts the next one.
 * <pre>
    $("#showr").click(function () {
      $("div:eq(0)").show("fast", function () {
        // use callee so don't have to name the function
        $(this).next().show("fast", arguments.callee); 
      });
    });
    $("#hidr").click(function () {
      $("div").hide(2000);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="showr"&gt;Show&lt;/button&gt;
  &lt;button id="hidr"&gt;Hide&lt;/button&gt;
  &lt;div&gt;Hello,&lt;/div&gt;

  &lt;div&gt;how&lt;/div&gt;
  &lt;div&gt;are&lt;/div&gt;
  &lt;div&gt;you?&lt;/div&gt;</pre>
 * 
 * Example:
 * Animates all span and input elements to show normally. Once the animation is done, it changes the text.
 * <pre>
    function doIt() {
      $("span,div").show("normal");
    }
    $("button").click(doIt); // can pass in function name
    $("form").submit(function () {
      if ($("input").val() == "yes") {
        $("p").show(4000, function () {
          $(this).text("Ok, DONE! (now showing)");
        });
      }
      $("span,div").hide("normal");
      return false; // to stop the submit
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Do it!&lt;/button&gt;
  &lt;span&gt;Are you sure? (type 'yes' if you are) &lt;/span&gt;
  &lt;div&gt;
    &lt;form&gt;

      &lt;input type="text" /&gt;
    &lt;/form&gt;
  &lt;/div&gt;
  &lt;p style="display:none;"&gt;I'm hidden...&lt;/p&gt;</pre>
 * 
 * 
 * @param speed String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executes once for each element animated against.

&lt;pre&gt;function callback() {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.show = function (speed, callback) {
  return new jQuery();
};
/** <p>
 * Hides each of the set of matched elements if they are shown.</p>
 * <p>
 * Same as &lt;a href='Effects/hide#speedcallback'&gt;hide( speed, [callback] )&lt;/a&gt; without animations. Doesn't change anything if the selected elements are all hidden.<br>
</p>
 * 
 * 
 * Example:
 * Hides all paragraphs then the link on click.
 * <pre>

    $("p").hide();
    $("a").click(function () {
      $(this).hide();
      return false;
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Hello&lt;/p&gt;
  &lt;a href="#"&gt;Click to hide me too&lt;/a&gt;
  &lt;p&gt;Here is another paragraph&lt;/p&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.hide = function () {
  return new jQuery();
};
/** <p>
 * Hide all matched elements using a graceful animation and firing an optional callback after completion.</p>
 * <p>
 * The height, width, and opacity of each of the matched elements are changed dynamically according to the specified speed.<br>
</p>
 * 
 * 
 * Example:
 * Animates all shown paragraphs to hide slowly, completing the animation within 600 milliseconds.
 * <pre>
    $("button").click(function () {
      $("p").hide("slow");
    });    
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Hide 'em&lt;/button&gt;

  &lt;p&gt;Hiya&lt;/p&gt;
  &lt;p&gt;Such interesting text, eh?&lt;/p&gt;</pre>
 * 
 * Example:
 * Animates all spans (words in this case) to hide fastly, completing each animation within 200 milliseconds. Once each animation is done, it starts the next one.
 * <pre>
    $("#hidr").click(function () {
      $("span:last-child").hide("fast", function () {
        // use callee so don't have to name the function
        $(this).prev().hide("fast", arguments.callee); 
      });
    });
    $("#showr").click(function () {
      $("span").show(2000);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="hidr"&gt;Hide&lt;/button&gt;
  &lt;button id="showr"&gt;Show&lt;/button&gt;
  &lt;div&gt;

    &lt;span&gt;Once&lt;/span&gt; &lt;span&gt;upon&lt;/span&gt; &lt;span&gt;a&lt;/span&gt; 
    &lt;span&gt;time&lt;/span&gt; &lt;span&gt;there&lt;/span&gt; &lt;span&gt;were&lt;/span&gt; 
    &lt;span&gt;three&lt;/span&gt; &lt;span&gt;programmers...&lt;/span&gt;

  &lt;/div&gt;</pre>
 * 
 * Example:
 * Hides the divs when clicked over 2 seconds, then removes the div element when its hidden.  Try clicking on more than one box at a time.
 * <pre>
    for (var i = 0; i &lt; 5; i++) {
      $("&lt;div&gt;").appendTo(document.body);
    }
    $("div").click(function () {
      $(this).hide(2000, function () {
        $(this).remove();
      });
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param speed String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executes once for each element animated against.

&lt;pre&gt;function callback() {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.hide = function (speed, callback) {
  return new jQuery();
};
/** <p>
 * Toggles each of the set of matched elements.</p>
 * <p>
 * If they are shown, toggle makes them hidden. If they are hidden, toggle makes them shown.<br>
</p>
 * 
 * 
 * Example:
 * Toggles all paragraphs.
 * <pre>

    $("button").click(function () {
      $("p").toggle();
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Toggle&lt;/button&gt;
  &lt;p&gt;Hello&lt;/p&gt;
  &lt;p style="display: none"&gt;Good Bye&lt;/p&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.toggle = function () {
  return new jQuery();
};
/** <p>
 * Reveal all matched elements by adjusting their height and firing an optional callback after completion.</p>
 * <p>
 * Only the height is adjusted for this animation, causing all matched elements to be revealed in a "sliding" manner.<br>
</p>
 * 
 * 
 * Example:
 * Animates all divs to slide down and show themselves over 600 milliseconds.
 * <pre>
    $(document.body).click(function () {
      if ($("div:first").is(":hidden")) {
        $("div").slideDown("slow");
      } else {
        $("div").hide();
      }
    });

</pre>
 * 
 * HTML:
 * <pre>Click me!
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Animates all inputs to slide down, completing the animation within 1000 milliseconds. Once the animation is done, the input look is changed especially if it is the middle input which gets the focus.
 * <pre>
    $("div").click(function () {
      $(this).css({ borderStyle:"inset", cursor:"wait" });
      $("input").slideDown(1000,function(){
        $(this).css("border", "2px red inset")
               .filter(".middle")
                 .css("background", "yellow")
                 .focus();
        $("div").css("visibility", "hidden");
      });
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;Push!&lt;/div&gt;
  &lt;input type="text" /&gt;
  &lt;input type="text" class="middle" /&gt;

  &lt;input type="text" /&gt;</pre>
 * 
 * 
 * @param speed String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executes once for each element animated against.

&lt;pre&gt;function callback() {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.slideDown = function (speed, callback) {
  return new jQuery();
};
/** <p>
 * Hide all matched elements by adjusting their height and firing an optional callback after completion.</p>
 * <p>
 * Only the height is adjusted for this animation, causing all matched elements to be hidden in a "sliding" manner.<br>
</p>
 * 
 * 
 * Example:
 * Animates all divs to slide up, completing the animation within 400 milliseconds.
 * <pre>
    $(document.body).click(function () {
      if ($("div:first").is(":hidden")) {
        $("div").show("fast");
      } else {
        $("div").slideUp();
      }
    });

</pre>
 * 
 * HTML:
 * <pre>Click me!
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Animates all paragraph to slide up, completing the animation within 200 milliseconds. Once the animation is done, it displays an alert.
 * <pre>
    $("button").click(function () {
      $(this).parent().slideUp("slow", function () {
        $("#msg").text($("button", this).text() + " has completed.");
      });
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;
    &lt;button&gt;Hide One&lt;/button&gt;
    &lt;input type="text" value="One" /&gt;

  &lt;/div&gt;
  &lt;div&gt;
    &lt;button&gt;Hide Two&lt;/button&gt;
    &lt;input type="text" value="Two" /&gt;

  &lt;/div&gt;
  &lt;div&gt;
    &lt;button&gt;Hide Three&lt;/button&gt;
    &lt;input type="text" value="Three" /&gt;

  &lt;/div&gt;
  &lt;div id="msg"&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param speed String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executes once for each element animated against.

&lt;pre&gt;function callback() {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.slideUp = function (speed, callback) {
  return new jQuery();
};
/** <p>
 * Toggle the visibility of all matched elements by adjusting their height and firing an optional callback after completion.</p>
 * <p>
 * Only the height is adjusted for this animation, causing all matched elements to be hidden or shown in a "sliding" manner.<br>
</p>
 * 
 * 
 * Example:
 * Animates all paragraphs to slide up or down, completing the animation within 600 milliseconds.
 * <pre>
    $("button").click(function () {
      $("p").slideToggle("slow");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Toggle&lt;/button&gt;

  &lt;p&gt;
    This is the paragraph to end all paragraphs.  You
    should feel &lt;em&gt;lucky&lt;/em&gt; to have seen such a paragraph in
    your life.  Congratulations!
  &lt;/p&gt;</pre>
 * 
 * Example:
 * Animates divs between dividers with a toggle that makes some appear and some disappear.
 * <pre>
    $("button").click(function () {
      $("div:not(.still)").slideToggle("slow", function () {
        var n = parseInt($("span").text(), 10);
        $("span").text(n + 1);
      });
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Toggle&lt;/button&gt; There have been &lt;span&gt;0&lt;/span&gt; toggled divs.
  &lt;div&gt;&lt;/div&gt;&lt;div class="still"&gt;&lt;/div&gt;

  &lt;div style="display:none;"&gt;&lt;/div&gt;&lt;div class="still"&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;&lt;div class="still"&gt;&lt;/div&gt;
  &lt;div class="hider"&gt;&lt;/div&gt;&lt;div class="still"&gt;&lt;/div&gt;

  &lt;div class="hider"&gt;&lt;/div&gt;&lt;div class="still"&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param speed String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executes once for each element animated against.

&lt;pre&gt;function callback() {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.slideToggle = function (speed, callback) {
  return new jQuery();
};
/** <p>
 * Fade in all matched elements by adjusting their opacity and firing an optional callback after completion.</p>
 * <p>
 * Only the opacity is adjusted for this animation, meaning that all of the matched elements should already have some form of height and width associated with them.<br>
</p>
 * 
 * 
 * Example:
 * Animates hidden divs to fade in one by one, completing each animation within 600 milliseconds.
 * <pre>
    $(document.body).click(function () {
      $("div:hidden:first").fadeIn("slow");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;span&gt;Click here...&lt;/span&gt;

  &lt;div id="one"&gt;&lt;/div&gt;
  &lt;div id="two"&gt;&lt;/div&gt;
  &lt;div id="three"&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Fades a red block in over the text. Once the animation is done, it quickly fades in more text on top.
 * <pre>
    $("a").click(function () {
      $("div").fadeIn(3000, function () {
        $("span").fadeIn(100);
      });
      return false;
    }); 

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Let it be known that the party of the first part
    and the party of the second part are henceforth
    and hereto directed to assess the allegations
    for factual correctness... (&lt;a href="#"&gt;click!&lt;/a&gt;)
    &lt;div&gt;&lt;span&gt;CENSORED!&lt;/span&gt;&lt;/div&gt;

  &lt;/p&gt;</pre>
 * 
 * 
 * @param speed String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executes once for each element animated against.

&lt;pre&gt;function callback() {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.fadeIn = function (speed, callback) {
  return new jQuery();
};
/** <p>
 * Fade out all matched elements by adjusting their opacity and firing an optional callback after completion.</p>
 * <p>
 * Only the opacity is adjusted for this animation, meaning that all of the matched elements should already have some form of height and width associated with them.<br>
</p>
 * 
 * 
 * Example:
 * Animates all paragraphs to fade out, completing the animation within 600 milliseconds.
 * <pre>

    $("p").click(function () {
      $("p").fadeOut("slow");
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    If you click on this paragraph
    you'll see it just fade away.
  &lt;/p&gt;</pre>
 * 
 * Example:
 * Fades out spans in one section that you click on.
 * <pre>

    $("span").click(function () {
      $(this).fadeOut(1000, function () {
        $("div").text("'" + $(this).text() + "' has faded!");
        $(this).remove();
      });
    });
    $("span").hover(function () {
      $(this).addClass("hilite");
    }, function () {
      $(this).removeClass("hilite");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;h3&gt;Find the modifiers - &lt;div&gt;&lt;/div&gt;&lt;/h3&gt;
  &lt;p&gt;
    If you &lt;span&gt;really&lt;/span&gt; want to go outside
    &lt;span&gt;in the cold&lt;/span&gt; then make sure to wear
    your &lt;span&gt;warm&lt;/span&gt; jacket given to you by
    your &lt;span&gt;favorite&lt;/span&gt; teacher.
  &lt;/p&gt;</pre>
 * 
 * 
 * @param speed String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executes once for each element animated against.
&lt;pre&gt;function callback() {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.fadeOut = function (speed, callback) {
  return new jQuery();
};
/** <p>
 * Fade the opacity of all matched elements to a specified opacity and firing an optional callback after completion.</p>
 * <p>
 * Only the opacity is adjusted for this animation, meaning that all of the matched elements should already have some form of height and width associated with them.<br>
</p>
 * 
 * 
 * Example:
 * Animates first paragraph to fade to an opacity of 0.33 (33%, about one third visible), completing the animation within 600 milliseconds.
 * <pre>
    $("p:first").click(function () {
      $(this).fadeTo("slow", 0.33);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
    Click this paragraph to see it fade.
  &lt;/p&gt;

  &lt;p&gt;
    Compare to this one that won't fade.
  &lt;/p&gt;</pre>
 * 
 * Example:
 * Fade div to a random opacity on each click, completing the animation within 200 milliseconds.
 * <pre>
    $("div").click(function () {
      $(this).fadeTo("fast", Math.random());
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;And this is the library that John built...&lt;/p&gt;

  &lt;div id="one"&gt;&lt;/div&gt;
  &lt;div id="two"&gt;&lt;/div&gt;
  &lt;div id="three"&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Find the right answer!  The fade will take 250 milliseconds and change various styles when it completes.
 * <pre>
    var getPos = function (n) {
      return (Math.floor(n) * 90) + "px";
    };
    $("p").each(function (n) {
      var r = Math.floor(Math.random() * 3);
      var tmp = $(this).text();
      $(this).text($("p:eq(" + r + ")").text());
      $("p:eq(" + r + ")").text(tmp);
      $(this).css("left", getPos(n));
    });
    $("div").each(function (n) {
                  $(this).css("left", getPos(n));
                })
            .css("cursor", "pointer")
            .click(function () {
                  $(this).fadeTo(250, 0.25, function () {
                        $(this).css("cursor", "")
                               .prev().css({"font-weight": "bolder",
                                            "font-style": "italic"});
                      });
                });

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Wrong&lt;/p&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;p&gt;Wrong&lt;/p&gt;
  &lt;div&gt;&lt;/div&gt;

  &lt;p&gt;Right!&lt;/p&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param speed String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param opacity Number . The opacity to fade to (a number from 0 to 1)..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executed once for each element animated against.

&lt;pre&gt;function callback() {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.fadeTo = function (speed, opacity, callback) {
  return new jQuery();
};
/** <p>
 * A function for making your own, custom animations.</p>
 * <p>
 * The key aspect of this function is the object of style properties that will be animated, and to what end. Each key within the object represents a style property that will also be animated (for example: "height", "top", or "opacity").

Note that properties should be specified using camel case eg. marginLeft instead of margin-left.

The value associated with the key represents to what end the property will be animated. If a number is provided as the value, then the style property will be transitioned from its current state to that new number. Otherwise if the string "hide", "show", or "toggle" is provided, a default animation will be constructed for that property.  Only properties that take numeric values are supported (e.g. backgroundColor is not supported by animate()).

As of jQuery 1.2 you can now animate properties by em and % (where applicable). Additionally, in jQuery 1.2, you can now do relative animations - specifying a "''+=''" or "''-=''" in front of the property value to move the element positively, or negatively, relative to the current position.<br>
</p>
 * 
 * 
 * Example:
 * Click the button to animate the div with a number of different properties.
 * <pre>

    // Using multiple unit types within one animation.
    $("#go").click(function(){
      $("#block").animate({ 
        width: "70%",
        opacity: 0.4,
        marginLeft: "0.6in",
        fontSize: "3em", 
        borderWidth: "10px"
      }, 1500 );
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;button id="go"&gt;&amp;raquo; Run&lt;/button&gt;

  &lt;div id="block"&gt;Hello!&lt;/div&gt;</pre>
 * 
 * Example:
 * Shows a div animate with a relative move.  Click several times on the buttons to see the relative animations queued up.
 * <pre>
    $("#right").click(function(){
      $(".block").animate({"left": "+=50px"}, "slow");
    });

    $("#left").click(function(){
      $(".block").animate({"left": "-=50px"}, "slow");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="left"&gt;&amp;laquo;&lt;/button&gt; &lt;button id="right"&gt;&amp;raquo;&lt;/button&gt;
&lt;div class="block"&gt;&lt;/div&gt;
</pre>
 * 
 * Example:
 * Animates all paragraphs to toggle both height and opacity, completing the animation within 600 milliseconds.
 * <pre>$("p").animate({
      "height": "toggle", "opacity": "toggle"

    }, "slow");</pre>
 * 
 * Example:
 * Animates all paragraph to a left style of 50 and opacity of 1 (opaque, visible), completing the animation within 500 milliseconds.
 * <pre>$("p").animate({
      "left": "50", "opacity": 1
    }, 500);
</pre>
 * 
 * Example:
 * An example of using an 'easing' function to provide a different style of animation. This will only work if you have a plugin that provides this easing function.  Note, this code will do nothing unless the paragraph element is hidden.
 * <pre>$("p").animate({
      "opacity": "show"

    }, "slow", "easein");</pre>
 * 
 * 
 * @param params Options. A set of style attributes that you wish to animate, and to what end..
 * @param duration String, Number . A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000)..
 * @param easing String . The name of the easing effect that you want to use (Plugin Required). There are two built-in values, "linear" and "swing"..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the animation completes, executes once for each element animated against..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.animate = function (params, duration, easing, callback) {
  return new jQuery();
};
/** <p>
 * A function for making your own, custom animations.</p>
 * <p>
 * The key aspect of this function is the object of style properties that will be animated, and to what end. Each key within the object represents a style property that will also be animated (for example: "height", "top", or "opacity").

Note that properties should be specified using camel case eg. marginLeft instead of margin-left.

The value associated with the key represents to what end the property will be animated. If a number is provided as the value, then the style property will be transitioned from its current state to that new number. Otherwise if the string "hide", "show", or "toggle" is provided, a default animation will be constructed for that property. <br>
</p>
 * 
 *Options:<br>
 * - duration(String, Number), default: "normal"
 *		A string representing one of the three predefined speeds ("slow", "normal", or "fast") or the number of milliseconds to run the animation (e.g. 1000).
 * - easing(A string of characters.String), default: "swing"
 *		The name of the easing effect that you want to use (Plugin Required). There are two built-in values, "linear" and "swing".
 * - complete(A reference to a Javascript function.Function), default: 
 *		A function to be executed whenever the animation completes, executes once for each element animated against.
 * - step(Callback), default: 
 *		
 * - queue(true or false.Boolean), default: true
 *		Setting this to false will make the animation skip the queue and will begin running immediately. (Added in jQuery 1.2)
 * 
 * Example:
 * The first button shows how an unqueued animation works.  It expands the div out to 90% width '''while''' the font-size is increasing. Once the font-size change is complete, the border animation will begin.

The second button starts a traditional chained animation, where each animation will start once the previous animation on the element has completed.
 * <pre>

    $("#go1").click(function(){
      $("#block1").animate( { width:"90%" }, { queue:false, duration:3000 } )
         .animate( { fontSize:"24px" }, 1500 )
         .animate( { borderRightWidth:"15px" }, 1500);
    });

    $("#go2").click(function(){
      $("#block2").animate( { width:"90%"}, 1000 )
         .animate( { fontSize:"24px" } , 1000 )
         .animate( { borderLeftWidth:"15px" }, 1000);
    });

    $("#go3").click(function(){
      $("#go1").add("#go2").click();
    });

    $("#go4").click(function(){
      $("div").css({width:"", fontSize:"", borderWidth:""});
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="go1"&gt;&amp;raquo; Animate Block1&lt;/button&gt;
  &lt;button id="go2"&gt;&amp;raquo; Animate Block2&lt;/button&gt;
  &lt;button id="go3"&gt;&amp;raquo; Animate Both&lt;/button&gt;

  &lt;button id="go4"&gt;&amp;raquo; Reset&lt;/button&gt;
  &lt;div id="block1"&gt;Block1&lt;/div&gt;
  &lt;div id="block2"&gt;Block2&lt;/div&gt;</pre>
 * 
 * Example:
 * Animates all paragraphs to toggle both height and opacity, completing the animation within 600 milliseconds.
 * <pre>$("p").animate({
      "height": "toggle", "opacity": "toggle"

    }, { duration: "slow" });</pre>
 * 
 * Example:
 * Animates all paragraph to a left style of 50 and opacity of 1 (opaque, visible), completing the animation within 500 milliseconds.  It also will do it ''outside'' the queue, meaning it will automatically start without waiting for its turn.
 * <pre>$("p").animate({
      left: "50px", opacity: 1
    }, { duration: 500, queue: false });</pre>
 * 
 * Example:
 * An example of using an 'easing' function to provide a different style of animation. This will only work if you have a plugin that provides this easing function.
 * <pre>$("p").animate({
      "opacity": "show"

    }, { "duration": "slow", "easing": "easein" });</pre>
 * 
 * 
 * @param params Options. A set of style attributes that you wish to animate, and to what end..
 * @param options Options . A set of options with which to configure the animation..
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.animate = function (params, options) {
  return new jQuery();
};
/** <p>
 * Stops all the currently running animations on all the specified elements. </p>
 * <p>
 * If any animations are queued to run, then they will begin immediately.<br>
</p>
 * 
 * 
 * Example:
 * Click the Go button once to start the animation, then click the STOP button to stop it where it's currently positioned.  Another option is to click several buttons to queue them up and see that stop just kills the currently playing one.
 * <pre>
    // Start animation
    $("#go").click(function(){
      $(".block").animate({left: '+=100px'}, 2000);
    });

    // Stop animation when button is clicked
    $("#stop").click(function(){
      $(".block").stop();
    });

    // Start animation in the opposite direction
    $("#back").click(function(){
      $(".block").animate({left: '-=100px'}, 2000);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="go"&gt;Go&lt;/button&gt; 
  &lt;button id="stop"&gt;STOP!&lt;/button&gt;
  &lt;button id="back"&gt;Back&lt;/button&gt;
  &lt;div class="block"&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.stop = function () {
  return new jQuery();
};
/** <p>
 * Returns a reference to the first element's queue (which is an array of functions).</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Show the length of the queue.
 * <pre>

    $("#show").click(function () {
      var n = $("div").queue("fx");
      $("span").text("Queue length is: " + n.length);
    });
    function runIt() {
      $("div").show("slow");
      $("div").animate({left:'+=200'},2000);
      $("div").slideToggle(1000);
      $("div").slideToggle("fast");
      $("div").animate({left:'-=200'},1500);
      $("div").hide("slow");
      $("div").show(1200);
      $("div").slideUp("normal", runIt);
    }
    runIt();

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="show"&gt;Show Length of Queue&lt;/button&gt;
  &lt;span&gt;&lt;/span&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @return Array&lt;Function&gt;
 * @since 1.2
 */
jQuery.queue = function () {
  return ;
};
/** <p>
 * Adds a new function, to be executed, onto the end of the queue of all matched elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Queue a custom function.
 * <pre>
    $(document.body).click(function () {
      $("div").show("slow");
      $("div").animate({left:'+=200'},2000);
      $("div").queue(function () {
        $(this).addClass("newcolor");
        $(this).dequeue();
      });
      $("div").animate({left:'-=200'},500);
      $("div").queue(function () {
        $(this).removeClass("newcolor");
        $(this).dequeue();
      });
      $("div").slideUp();
    });

</pre>
 * 
 * HTML:
 * <pre>Click here...
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to add to the queue.

&lt;pre&gt;function callback() {
  this; // dom element
  // to continue the queue you must call
  jQuery(this).dequeue();
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.queue = function (callback) {
  return new jQuery();
};
/** <p>
 * Replaces the queue of all matched element with this new queue (the array of functions).</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Set a queue array to delete the queue.
 * <pre>
    $("#start").click(function () {
      $("div").show("slow");
      $("div").animate({left:'+=200'},5000);
      $("div").queue(function () {
        $(this).addClass("newcolor");
        $(this).dequeue();
      });
      $("div").animate({left:'-=200'},1500);
      $("div").queue(function () {
        $(this).removeClass("newcolor");
        $(this).dequeue();
      });
      $("div").slideUp();
    });
    $("#stop").click(function () {
      $("div").queue("fx", []);
      $("div").stop();
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button id="start"&gt;Start&lt;/button&gt;
  &lt;button id="stop"&gt;Stop&lt;/button&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param queue Array&lt;Function&gt;. The queue to replace all the queues with.  The functions have the same parameters and this value as queue(callback)..
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.queue = function (queue) {
  return new jQuery();
};
/** <p>
 * Removes a queued function from the front of the queue and executes it.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Use dequeue to end a custom queue function which allows the queue to keep going.
 * <pre>

    $("button").click(function () {
      $("div").animate({left:'+=200px'}, 2000);
      $("div").animate({top:'0px'}, 600);
      $("div").queue(function () {
        $(this).toggleClass("red");
        $(this).dequeue();
      });
      $("div").animate({left:'10px', top:'30px'}, 700);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Start&lt;/button&gt;

  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.dequeue = function () {
  return new jQuery();
};
/** <p>
 * Load a remote page using an HTTP request.</p>
 * <p>
 * This is jQuery's low-level AJAX implementation. See $.get, $.post etc. for higher-level abstractions that are often easier to understand and use, but don't offer as much functionality (such as error callbacks).

'''Warning: All POST are converted to GET when 'script' is the dataType.(because it loads script as a dom script tag)'''

$.ajax() returns the XMLHttpRequest that it creates. In most cases you won't need that object to manipulate directly, but it is available if you need to abort the request manually.

'''Note:''' If you specify the dataType option described below, make sure
the server sends the correct MIME type in the response (eg. xml as "text/xml").
Sending the wrong MIME type can lead to unexpected problems in your script.
See &lt;a href='Specifying_the_Data_Type_for_AJAX_Requests'&gt;Specifying the Data Type for AJAX Requests&lt;/a&gt; for more information.

$.ajax() takes one argument, an object of key/value pairs, that are used to initialize and handle the request. See below for a full list of the key/values that can be used.

As of jQuery 1.2, you can load JSON data located on another domain if you specify a [http://bob.pythonmac.org/archives/2005/12/05/remote-json-jsonp/ JSONP] callback, which can be done like so: "myurl?callback=?". jQuery automatically replaces the ? with the correct method name to call, calling your specified callback. Or, if you set the dataType to "jsonp" a callback will be automatically added to your Ajax request.<br>
</p>
 * 
 *Options:<br>
 * - async(true or false.Boolean), default: true
 *		By default, all requests are sent asynchronous (e.g. this is set to true by default). If you need synchronous requests, set this option to false. Note that synchronous requests may temporarily lock the browser, disabling any actions while the request is active.
 * - beforeSend(A reference to a Javascript function.Function), default: 
 *		A pre-callback to modify the XMLHttpRequest object before it is sent. Use this to set custom headers etc. The XMLHttpRequest is passed as the only argument. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.

&lt;pre&gt;function (XMLHttpRequest) {
  this; // the options for this ajax request
}
&lt;/pre&gt;
 * - cache(true or false.Boolean), default: true
 *		Added in jQuery 1.2, if set to false it will force the pages that you request to not be cached by the browser.
 * - complete(A reference to a Javascript function.Function), default: 
 *		A function to be called when the request finishes (after success and error callbacks are executed). The function gets passed two arguments: The XMLHttpRequest object and a string describing the type of success of the request. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.
&lt;pre&gt;function (XMLHttpRequest, textStatus) {
  this; // the options for this ajax request
}
&lt;/pre&gt;
 * - contentType(A string of characters.String), default: "application/x-www-form-urlencoded"
 *		When sending data to the server, use this content-type. Default is "application/x-www-form-urlencoded", which is fine for most cases.
 * - data(Object, String), default: 
 *		Data to be sent to the server. It is converted to a query string, if not already a string. It's appended to the url for GET-requests. See processData option to prevent this automatic processing. Object must be Key/Value pairs. If value is an Array, jQuery serializes multiple values with same key i.e. {foo:["bar1", "bar2"]} becomes '&amp;foo=bar1&amp;foo=bar2'.
 * - dataType(A string of characters.String), default: Intelligent Guess (xml or html)
 *		The type of data that you're expecting back from the server. If none is specified, jQuery will intelligently pass either responseXML or responseText to your success callback, based on the MIME type of the response. The available types (and the result passed as the first argument to your success callback) are:
*"xml": Returns a XML document that can be processed via jQuery.
*"html": Returns HTML as plain text; included script tags are evaluated.
*'''warning "script" will turn posts into gets'''
*"script": Evaluates the response as JavaScript and returns it as plain text. Disables caching unless option "cache" is used.
*"json": Evaluates the response as JSON and returns a JavaScript Object.
*"jsonp": Loads in a JSON block using [http://bob.pythonmac.org/archives/2005/12/05/remote-json-jsonp/ JSONP]. Will add an extra "?callback=?" to the end of your URL to specify the callback. (Added in jQuery 1.2)
*"text": A plain text string.
 * - error(A reference to a Javascript function.Function), default: 
 *		A function to be called if the request fails. The function gets passed three arguments: The XMLHttpRequest object, a string describing the type of error that occurred and an optional exception object, if one occurred. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.

&lt;pre&gt;function (XMLHttpRequest, textStatus, errorThrown) {
  // typically only one of textStatus or errorThrown 
  // will have info
  this; // the options for this ajax request
}
&lt;/pre&gt;
 * - global(true or false.Boolean), default: true
 *		Whether to trigger global AJAX event handlers for this request. The default is true. Set to false to prevent the global handlers like ajaxStart or ajaxStop from being triggered. This can be used to control various &lt;a href='Ajax_Events'&gt;Ajax Events&lt;/a&gt;.
 * - ifModified(true or false.Boolean), default: false
 *		Allow the request to be successful only if the response has changed since the last request. This is done by checking the Last-Modified header. Default value is false, ignoring the header.
 * - jsonp(A string of characters.String), default: 
 *		Override the callback function name in a jsonp request.  This value will be used instead of 'callback' in the 'callback=?' part of the query string in the url for a GET or the data for a POST.  So {jsonp:'onJsonPLoad'} would result in 'onJsonPLoad=?' passed to the server.
 * - processData(true or false.Boolean), default: true
 *		By default, data passed in to the data option as an object (technically, anything other than a string) will be processed and transformed into a query string, fitting to the default content-type "application/x-www-form-urlencoded". If you want to send DOMDocuments, or other non-processed data, set this option to false.
 * - success(A reference to a Javascript function.Function), default: 
 *		A function to be called if the request succeeds. The function gets passed two arguments: The data returned from the server, formatted according to the 'dataType' parameter, and a string describing the status. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.
&lt;pre&gt;function (data, textStatus) {
  // data could be xmlDoc, jsonObj, html, text, etc...
  this; // the options for this ajax request
}
&lt;/pre&gt;
 * - timeout(A valid numeric.Number), default: 
 *		Set a local timeout in ms for the request. This will override the global timeout, if one is set via &lt;a href='Ajax/jQuery.ajaxSetup'&gt;$.ajaxSetup&lt;/a&gt;. For example, you could use this property to give a single request a longer timeout than all other requests that you've set to time out in one second. See &lt;a href='Ajax/jQuery.ajaxSetup'&gt;$.ajaxSetup&lt;/a&gt;() for global timeouts.
 * - type(A string of characters.String), default: "GET"
 *		The type of request to make ("POST" or "GET"), default is "GET". Note: Other HTTP request methods, such as PUT and DELETE, can also be used here, but they are not supported by all browsers.
 * - url(A string of characters.String), default: The current page
 *		The URL to request.
 * 
 * Example:
 * Load and execute a JavaScript file.
 * <pre> $.ajax({
   type: "GET",
   url: "test.js",
   dataType: "script"

 });</pre>
 * 
 * Example:
 * Save some data to the server and notify the user once its complete.
 * <pre> $.ajax({
   type: "POST",
   url: "some.php",
   data: "name=John&amp;location=Boston",
   success: function(msg){
     alert( "Data Saved: " + msg );
   }
 });</pre>
 * 
 * Example:
 * Retrieve the latest version of an HTML page.
 * <pre>$.ajax({
  url: "test.html",
  cache: false,
  success: function(html){
    $("#results").append(html);
  }
});</pre>
 * 
 * Example:
 * Loads data synchronously. Blocks the browser while the requests is active.
It is better to block user interaction by other means when synchronization is
necessary.
 * <pre> var html = $.ajax({
  url: "some.php",
  async: false
 }).responseText;</pre>
 * 
 * Example:
 * Sends an xml document as data to the server. By setting the processData
option to false, the automatic conversion of data to strings is prevented.
 * <pre> var xmlDocument = [create xml document];
 $.ajax({
   url: "page.php",
   processData: false,
   data: xmlDocument,
   success: handleResponse
 });</pre>
 * 
 * 
 * @param options Options. A set of key/value pairs that configure the Ajax request. All options are optional. A default can be set for any option with &lt;a href='Ajax/jQuery.ajaxSetup'&gt;$.ajaxSetup&lt;/a&gt;()..
 * @return An XMLHttpRequest object (referencing a HTTP request).XMLHttpRequest
 * @since 1.0
 */
jQuery.ajax = function (options) {
  return new XMLHttpRequest();
};
/** <p>
 * Load HTML from a remote file and inject it into the DOM.</p>
 * <p>
 * A GET request will be performed by default - but if you pass in any extra parameters then a POST will occur.

In jQuery 1.2 you can now specify a jQuery selector in the URL. Doing so will filter the incoming HTML document, only injecting the elements that match the selector. The syntax looks something like "url #some &gt; selector". See the examples for more information.<br>
</p>
 * 
 * 
 * Example:
 * Load a piece of the documentation sidebar navigation into a custom unordered list.
 * <pre>$("#links").load("/Main_Page #p-Getting-Started li");</pre>
 * 
 * HTML:
 * <pre>&lt;b&gt;jQuery Links:&lt;/b&gt;
&lt;ul id="links"&gt;&lt;/ul&gt;</pre>
 * 
 * Example:
 * Load the feeds.html file into the div with the ID of feeds.
 * <pre>$("#feeds").load("feeds.html");</pre>
 * 
 * Result:
 * <pre>&lt;div id="feeds"&gt;&lt;b&gt;45&lt;/b&gt; feeds found.&lt;/div&gt;</pre>
 * 
 * Example:
 * Same as above, but will POST the additional parameters to the server and a callback that is executed when the server is finished responding.
 * <pre> $("#feeds").load("feeds.php", {limit: 25}, function(){
   alert("The last 25 entries in the feed have been loaded");
 });</pre>
 * 
 * 
 * @param url A string of characters.String. The URL of the HTML page to load..
 * @param data A Javascript object that contains key/value pairs in the form of properties and values.Map. Key/value pairs that will be sent to the server..
 * @param callback Callback. The function called when the ajax request is complete (not necessarily success).

&lt;pre&gt;function (responseText, textStatus, XMLHttpRequest) {
  this; // dom element
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.load = function (url, data, callback) {
  return new jQuery();
};
/** <p>
 * Load a remote page using an HTTP GET request.</p>
 * <p>
 * This is an easy way to send a simple GET request to a server without having to use the more complex $.ajax function. It allows a single callback function to be specified that will be executed when the request is complete (and only if the response has a successful response code). If you need to have both error and success callbacks, you may want to use $.ajax.<br>
</p>
 * 
 * 
 * Example:
 * Request the test.php page, but ignore the return results.
 * <pre> $.get("test.php");</pre>
 * 
 * Example:
 * Request the test.php page and send some additional data along (while still ignoring the return results).
 * <pre> $.get("test.php", { name: "John", time: "2pm" } );</pre>
 * 
 * Example:
 * Alert out the results from requesting test.php (HTML or XML, depending on what was returned).
 * <pre> $.get("test.php", function(data){
   alert("Data Loaded: " + data);
 });</pre>
 * 
 * Example:
 * Alert out the results from requesting test.cgi with an additional payload of data (HTML or XML, depending on what was returned).
 * <pre> $.get("test.cgi", { name: "John", time: "2pm" },
   function(data){
     alert("Data Loaded: " + data);
   });</pre>
 * 
 * 
 * @param url A string of characters.String. The URL of the page to load..
 * @param data A Javascript object that contains key/value pairs in the form of properties and values.Map. Key/value pairs that will be sent to the server..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the data is loaded successfully.

&lt;pre&gt;function (data, textStatus) {
  // data could be xmlDoc, jsonObj, html, text, etc...
  this; // the options for this ajax request
}
&lt;/pre&gt;.
 * @return An XMLHttpRequest object (referencing a HTTP request).XMLHttpRequest
 * @since 1.0
 */
jQuery.get = function (url, data, callback) {
  return new XMLHttpRequest();
};
/** <p>
 * Load JSON data using an HTTP GET request.</p>
 * <p>
 * As of jQuery 1.2, you can load JSON data located on another domain if you specify a [http://bob.pythonmac.org/archives/2005/12/05/remote-json-jsonp/ JSONP] callback, which can be done like so: "myurl?callback=?". jQuery automatically replaces the ? with the correct method name to call, calling your specified callback.


Note: Keep in mind, that lines after this function will be executed before callback.<br>
</p>
 * 
 * 
 * Example:
 * Loads the four most recent cat pictures from the Flickr JSONP API.
 * <pre>$.getJSON("http://api.flickr.com/services/feeds/photos_public.gne?tags=cat&amp;tagmode=any&amp;format=json&amp;jsoncallback=?",
        function(data){
          $.each(data.items, function(i,item){
            $("&lt;img/&gt;").attr("src", item.media.m).appendTo("#images");
            if ( i == 3 ) return false;
          });
        });</pre>
 * 
 * HTML:
 * <pre>&lt;div id="images"&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Load the JSON data from test.js and access a name from the returned JSON data.
 * <pre> $.getJSON("test.js", function(json){
   alert("JSON Data: " + json.users[3].name);
 });</pre>
 * 
 * Example:
 * Load the JSON data from test.js, passing along additional data, and access a name from the returned JSON data.
 * <pre> $.getJSON("test.js", { name: "John", time: "2pm" }, function(json){
   alert("JSON Data: " + json.users[3].name);
 });</pre>
 * 
 * Example:
 * Alert out the results from requesting test.php (HTML or XML, depending on what was returned).
 * <pre> $.getIfModified("test.php", function(data){
   alert("Data Loaded: " + data);
 });</pre>
 * 
 * Example:
 * Alert out the results from requesting test.php with an additional payload of data (HTML or XML, depending on what was returned).
 * <pre> $.getIfModified("test.cgi", { name: "John", time: "2pm" },
   function(data){
     alert("Data Loaded: " + data);
   });</pre>
 * 
 * Example:
 * list the result of a consultation of pages,php in HTML as an array. by Manuel Gonzalez.
 * <pre>

var id=$("#id").attr("value");
  $.getJSON("pages.php",{id:id},dates);
function dates(datos)
{
	
 $("#list").html("Name:"+datos[1].name+"&lt;br&gt;"+"Last Name:"+datos[1].lastname+"&lt;br&gt;"+"Address:"+datos[1].address);
}

</pre>
 * 
 * 
 * @param url A string of characters.String. The URL of the page to load..
 * @param data A Javascript object that contains key/value pairs in the form of properties and values.Map. Key/value pairs that will be sent to the server..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the data is loaded successfully.

&lt;pre&gt;function (data, textStatus) {
  // data will be a jsonObj
  this; // the options for this ajax request
}
&lt;/pre&gt;.
 * @return An XMLHttpRequest object (referencing a HTTP request).XMLHttpRequest
 * @since 1.0
 */
jQuery.getJSON = function (url, data, callback) {
  return new XMLHttpRequest();
};
/** <p>
 * Loads, and executes, a local JavaScript file using an HTTP GET request.</p>
 * <p>
 * Before jQuery 1.2, getScript was only able to load scripts from the same domain as the original page. As of 1.2, you can now load JavaScript files from any domain.

Warning: Safari 2 and older is unable to evaluate scripts in a global context synchronously. If you load functions via getScript, make sure to call them after a delay.<br>
</p>
 * 
 * 
 * Example:
 * We load the new [http://jquery.com/plugins/project/color official jQuery Color Animation plugin] dynamically and bind some color animations to occur once the new functionality is loaded.
 * <pre>$.getScript("http://dev.jquery.com/view/trunk/plugins/color/jquery.color.js", function(){
  $("#go").click(function(){
    $(".block").animate( { backgroundColor: 'pink' }, 1000)
      .animate( { backgroundColor: 'blue' }, 1000);
  });
});</pre>
 * 
 * HTML:
 * <pre>&lt;button id="go"&gt;&amp;raquo; Run&lt;/button&gt;

&lt;div class="block"&gt;&lt;/div&gt;
</pre>
 * 
 * Example:
 * Load the test.js JavaScript file and execute it.
 * <pre> $.getScript("test.js");</pre>
 * 
 * Example:
 * Load the test.js JavaScript file and execute it, displaying an alert message when the execution is complete.
 * <pre> $.getScript("test.js", function(){
   alert("Script loaded and executed.");
 });</pre>
 * 
 * 
 * @param url A string of characters.String. The URL of the page to load..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the data is loaded successfully.
&lt;pre&gt;function (data, textStatus) {
  // data should be javascript
  this; // the options for this ajax request
}
&lt;/pre&gt;.
 * @return An XMLHttpRequest object (referencing a HTTP request).XMLHttpRequest
 * @since 1.0
 */
jQuery.getScript = function (url, callback) {
  return new XMLHttpRequest();
};
/** <p>
 * Load a remote page using an HTTP POST request.</p>
 * <p>
 * This is an easy way to send a simple POST request to a server without having to use the more complex $.ajax function. It allows a single callback function to be specified that will be executed when the request is complete (and only if the response has a successful response code). If you need to have both error and success callbacks, you may want to use $.ajax.<br>
</p>
 * 
 * 
 * Example:
 * Request the test.php page, but ignore the return results.
 * <pre> $.post("test.php");</pre>
 * 
 * Example:
 * Request the test.php page and send some additional data along (while still ignoring the return results).
 * <pre> $.post("test.php", { name: "John", time: "2pm" } );</pre>
 * 
 * Example:
 * Alert out the results from requesting test.php (HTML or XML, depending on what was returned).
 * <pre> $.post("test.php", function(data){
   alert("Data Loaded: " + data);
 });</pre>
 * 
 * Example:
 * Alert out the results from requesting test.php with an additional payload of data (HTML or XML, depending on what was returned).
 * <pre> $.post("test.cgi", { name: "John", time: "2pm" },
   function(data){
     alert("Data Loaded: " + data);
   });</pre>
 * 
 * 
 * @param url A string of characters.String. The URL of the page to load..
 * @param data A Javascript object that contains key/value pairs in the form of properties and values.Map. Key/value pairs that will be sent to the server..
 * @param callback A reference to a Javascript function.Function. A function to be executed whenever the data is loaded successfully.

&lt;pre&gt;function (data, textStatus) {
  // data could be xmlDoc, jsonObj, html, text, etc...
  this; // the options for this ajax request
}
&lt;/pre&gt;.
 * @return An XMLHttpRequest object (referencing a HTTP request).XMLHttpRequest
 * @since 1.0
 */
jQuery.post = function (url, data, callback) {
  return new XMLHttpRequest();
};
/** <p>
 * Attach a function to be executed whenever an AJAX request completes. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.</p>
 * <p>
 * The XMLHttpRequest and settings used for that request are passed as arguments to the callback.<br>
</p>
 * 
 * 
 * Example:
 * Show a message when an AJAX request completes.
 * <pre> $("#msg").ajaxComplete(function(request, settings){
   $(this).append("&lt;li&gt;Request Complete.&lt;/li&gt;");
 });</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute.

&lt;pre&gt;function (event, XMLHttpRequest, ajaxOptions) {
  this; // dom element listening
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.ajaxComplete = function (callback) {
  return new jQuery();
};
/** <p>
 * Attach a function to be executed whenever an AJAX request fails. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.</p>
 * <p>
 * The XMLHttpRequest and settings used for that request are passed as arguments to the callback. A third argument, an exception object, is passed if an exception occured while processing the request.<br>
</p>
 * 
 * 
 * Example:
 * Show a message when an AJAX request fails.
 * <pre> $("#msg").ajaxError(function(request, settings){
   $(this).append("&lt;li&gt;Error requesting page " + settings.url + "&lt;/li&gt;");
 });</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute.

&lt;pre&gt;function (event, XMLHttpRequest, ajaxOptions, thrownError) {
  // thrownError only passed if an error was caught
  this; // dom element listening
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.ajaxError = function (callback) {
  return new jQuery();
};
/** <p>
 * Attach a function to be executed before an AJAX request is sent. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.</p>
 * <p>
 * The XMLHttpRequest and settings used for that request are passed as arguments to the callback.<br>
</p>
 * 
 * 
 * Example:
 * Show a message before an AJAX request is sent.
 * <pre> $("#msg").ajaxSend(function(evt, request, settings){
   $(this).append("&lt;li&gt;Starting request at " + settings.url + "&lt;/li&gt;");
 });</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute.

&lt;pre&gt;function (event, XMLHttpRequest, ajaxOptions) {
  this; // dom element listening
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.ajaxSend = function (callback) {
  return new jQuery();
};
/** <p>
 * Attach a function to be executed whenever an AJAX request begins and there is none already active. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Show a loading message whenever an AJAX request starts (and none is already active).
 * <pre> $("#loading").ajaxStart(function(){
   $(this).show();
 });</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute.

&lt;pre&gt;function () {
  this; // dom element listening
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.ajaxStart = function (callback) {
  return new jQuery();
};
/** <p>
 * Attach a function to be executed whenever all AJAX requests have ended. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Hide a loading message after all the AJAX requests have stopped.
 * <pre> $("#loading").ajaxStop(function(){
   $(this).hide();
 });</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute.
&lt;pre&gt;function () {
  this; // dom element listening
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.ajaxStop = function (callback) {
  return new jQuery();
};
/** <p>
 * Attach a function to be executed whenever an AJAX request completes successfully. This is an &lt;a href='Ajax_Events'&gt;Ajax Event&lt;/a&gt;.</p>
 * <p>
 * The event object, XMLHttpRequest, and settings used for that request are passed as arguments to the callback.<br>
</p>
 * 
 * 
 * Example:
 * Show a message when an AJAX request completes successfully.
 * <pre> $("#msg").ajaxSuccess(function(evt, request, settings){
   $(this).append("&lt;li&gt;Successful Request!&lt;/li&gt;");
 });</pre>
 * 
 * 
 * @param callback A reference to a Javascript function.Function. The function to execute.

&lt;pre&gt;function (event, XMLHttpRequest, ajaxOptions) {
  this; // dom element listening
}
&lt;/pre&gt;.
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.ajaxSuccess = function (callback) {
  return new jQuery();
};
/** <p>
 * Setup global settings for AJAX requests.</p>
 * <p>
 * See &lt;a href='Ajax/jQuery.ajax'&gt;$.ajax&lt;/a&gt; for a description of all available options.<br>
</p>
 * 
 * 
 * Example:
 * Sets the defaults for AJAX requests to the url "/xmlhttp/", disables global handlers and uses POST instead of GET. The following AJAX requests then sends some data without having to set anything else.
 * <pre> $.ajaxSetup({
   url: "/xmlhttp/",
   global: false,
   type: "POST"

 });
 $.ajax({ data: myData });</pre>
 * 
 * 
 * @param options Options. A set of key/value pairs that configure the default Ajax request. All options are optional..
 * @return 
 * @since 1.1
 */
jQuery.ajaxSetup = function (options) {
  return ;
};
/** <p>
 * Serializes a set of input elements into a string of data. This will serialize all given elements.</p>
 * <p>
 * As of jQuery 1.2 the serialize method correctly serializes forms. For older versions of jQuery, the [http://www.malsup.com/jquery/form/ Form Plugin's] fieldSerialize method should be used.<br>
</p>
 * 
 * 
 * Example:
 * Serialize a form to a query string, that could be sent to a server in an Ajax request.
 * <pre>
    function showValues() {
      var str = $("form").serialize();
      $("#results").text(str);
    }

    $(":checkbox, :radio").click(showValues);
    $("select").change(showValues);
    showValues();

</pre>
 * 
 * HTML:
 * <pre>&lt;form&gt;
    &lt;select name="single"&gt;
      &lt;option&gt;Single&lt;/option&gt;
      &lt;option&gt;Single2&lt;/option&gt;

    &lt;/select&gt;
    &lt;select name="multiple" multiple="multiple"&gt;
      &lt;option selected="selected"&gt;Multiple&lt;/option&gt;
      &lt;option&gt;Multiple2&lt;/option&gt;

      &lt;option selected="selected"&gt;Multiple3&lt;/option&gt;
    &lt;/select&gt;&lt;br/&gt;
    &lt;input type="checkbox" name="check" value="check1"/&gt; check1
    &lt;input type="checkbox" name="check" value="check2" checked="checked"/&gt; check2
    &lt;input type="radio" name="radio" value="radio1" checked="checked"/&gt; radio1
    &lt;input type="radio" name="radio" value="radio2"/&gt; radio2
  &lt;/form&gt;

  &lt;p&gt;&lt;tt id="results"&gt;&lt;/tt&gt;&lt;/p&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.0
 */
jQuery.serialize = function () {
  return new jQuery();
};
/** <p>
 * Serializes all forms and form elements (like the &lt;a href='Ajax/serialize'&gt;.serialize()&lt;/a&gt; method) but returns a JSON data structure for you to work with.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Get the values from a form, iterate through them, and append them to a results display.
 * <pre>
    function showValues() {
      var fields = $(":input").serializeArray();
      $("#results").empty();
      jQuery.each(fields, function(i, field){
        $("#results").append(field.value + " ");
      });
    }

    $(":checkbox, :radio").click(showValues);
    $("select").change(showValues);
    showValues();

</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;&lt;b&gt;Results:&lt;/b&gt; &lt;span id="results"&gt;&lt;/span&gt;&lt;/p&gt;
  &lt;form&gt;
    &lt;select name="single"&gt;

      &lt;option&gt;Single&lt;/option&gt;
      &lt;option&gt;Single2&lt;/option&gt;
    &lt;/select&gt;
    &lt;select name="multiple" multiple="multiple"&gt;

      &lt;option selected="selected"&gt;Multiple&lt;/option&gt;
      &lt;option&gt;Multiple2&lt;/option&gt;
      &lt;option selected="selected"&gt;Multiple3&lt;/option&gt;

    &lt;/select&gt;&lt;br/&gt;
    &lt;input type="checkbox" name="check" value="check1"/&gt; check1
    &lt;input type="checkbox" name="check" value="check2" checked="checked"/&gt; check2
    &lt;input type="radio" name="radio" value="radio1" checked="checked"/&gt; radio1
    &lt;input type="radio" name="radio" value="radio2"/&gt; radio2
  &lt;/form&gt;</pre>
 * 
 * 
 * @return A jQuery object.jQuery
 * @since 1.2
 */
jQuery.serializeArray = function () {
  return new jQuery();
};
/** <p>
 * Contains flags for the useragent, read from navigator.userAgent.</p>
 * <p>
 * Available flags are:
* safari
* opera
* msie
* mozilla

This property is available before the DOM is ready, therefore you can use it to add ready events only for certain browsers.

There are situations where object detection is not reliable enough, in such cases it makes sense to use browser detection.

A combination of browser and object detection yields quite reliable results. <br>
</p>
 * 
 * 
 * Example:
 * Show the browser info.
 * <pre>

    jQuery.each(jQuery.browser, function(i, val) {
      $("&lt;div&gt;" + i + " : &lt;span&gt;" + val + "&lt;/span&gt;")
                .appendTo(document.body);
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;Browser info:&lt;/p&gt;</pre>
 * 
 * Example:
 * Returns true if the current useragent is some version of Microsoft's Internet Explorer
 * <pre>$.browser.msie</pre>
 * 
 * Example:
 * Alerts "this is safari!" only for safari browsers
 * <pre>if ($.browser.safari) {
    alert("this is safari!");
 }</pre>
 * 
 * 
 * @return A Javascript object that contains key/value pairs in the form of properties and values.Map
 * @since 1.0
 */
jQuery.browser = [];
/** <p>
 * The version number of the rendering engine for the user's browser.</p>
 * <p>
 * Here are some typical results:
* Internet Explorer: 6.0, 7.0
* Mozilla/Firefox/Flock/Camino: 1.7.12, 1.8.1.3
* Opera: 9.20
* Safari/Webkit: 312.8, 418.9<br>
</p>
 * 
 * 
 * Example:
 * Returns the browser version.
 * <pre>

    $("p").html("The browser version is: &lt;span&gt;" +
                jQuery.browser.version + "&lt;/span&gt;");
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
  &lt;/p&gt;</pre>
 * 
 * Example:
 * Alerts the version of IE that is being used
 * <pre>if ( $.browser.msie )
  alert( $.browser.version );
}</pre>
 * 
 * Example:
 * Often you only care about the "major number," the whole number. This can be accomplished with JavaScript's built-in parseInt() function:
 * <pre>

if (jQuery.browser.msie) {
  alert(parseInt(jQuery.browser.version));
}
</pre>
 * 
 * 
 * @return A string of characters.String
 * @since 1.1.3
 */
jQuery.browser.version = "";
/** <p>
 * States if the current page, in the user's browser, is being rendered using the [http://www.w3.org/TR/REC-CSS2/box.html W3C CSS Box Model].</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Returns the box model for the iframe.
 * <pre>

    $("p").html("The box model for this iframe is: &lt;span&gt;" +
                jQuery.boxModel + "&lt;/span&gt;");
</pre>
 * 
 * HTML:
 * <pre>&lt;p&gt;
  &lt;/p&gt;</pre>
 * 
 * Example:
 * Returns false if the page is in QuirksMode in Internet Explorer
 * <pre>$.boxModel</pre>
 * 
 * Result:
 * <pre>false</pre>
 * 
 * 
 * @return true or false.Boolean
 * @since 1.0
 */
jQuery.boxModel = false;
/** <p>
 * A generic iterator function, which can be used to seamlessly iterate over both objects and arrays.</p>
 * <p>
 * This function is not the same as $().each() - which is used to iterate, exclusively, over a jQuery object. This function can be used to iterate over anything.

The callback has two arguments:the key (objects) or index (arrays) as the first, and the value as the second.

If you wish to break the each() loop at a particular iteration you can do so by making your function return false. Other return values are ignored.<br>
</p>
 * 
 * 
 * Example:
 * Filters the original array of numbers leaving that are not 5 and have an index greater than 3.  Then it removes all 9s while inverting it.
 * <pre>

    var arr = [ "one", "two", "three", "four", "five" ];
    var obj = { one:1, two:2, three:3, four:4, five:5 };

    jQuery.each(arr, function() {
      $("#" + this).text("My id is " + this + ".");
      return (this != "four"); // will stop running to skip "five"

    });

    jQuery.each(obj, function(i, val) {
      $("#" + i).append(document.createTextNode(" - " + val));
    });
</pre>
 * 
 * HTML:
 * <pre>&lt;div id="one"&gt;&lt;/div&gt;
  &lt;div id="two"&gt;&lt;/div&gt;

  &lt;div id="three"&gt;&lt;/div&gt;
  &lt;div id="four"&gt;&lt;/div&gt;
  &lt;div id="five"&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Iterates over items in an array, accessing both the current item and its index.
 * <pre> $.each( [0,1,2], function(i, n){
   alert( "Item #" + i + ": " + n );
 });</pre>
 * 
 * Example:
 * Iterates over the properties in an object, accessing both the current item and its key.
 * <pre>$.each( { name: "John", lang: "JS" }, function(i, n){
   alert( "Name: " + i + ", Value: " + n );
 });</pre>
 * 
 * 
 * @param object A simple Javascript object..Object. The object, or array, to iterate over..
 * @param callback A reference to a Javascript function.Function. The function that will be executed on every object.
&lt;pre&gt;function callback(indexInArray, valueOfElement) {
  var booleanKeepGoing;

  this; // == valueOfElement

  return booleanKeepGoing; // optional, unless false 
                           // and want to stop looping
}
&lt;/pre&gt;.
 * @return A simple Javascript object..Object
 * @since 1.0
 */
jQuery.each = function (object, callback) {
  return new Object();
};
/** <p>
 * Extend one object with one or more others, returning the original, modified, object.</p>
 * <p>
 * This is a great utility for simple inheritance.<br>
</p>
 * 
 * 
 * Example:
 * Merge settings and options, modifying settings.
 * <pre>var settings = { validate: false, limit: 5, name: "foo" };
var options = { validate: true, name: "bar" };
jQuery.extend(settings, options);</pre>
 * 
 * Result:
 * <pre>settings == { validate: true, limit: 5, name: "bar" }</pre>
 * 
 * Example:
 * Merge defaults and options, without modifying the defaults.
 * <pre>var empty = {}
var defaults = { validate: false, limit: 5, name: "foo" };
var options = { validate: true, name: "bar" };
var settings = $.extend(empty, defaults, options);</pre>
 * 
 * Result:
 * <pre>settings == { validate: true, limit: 5, name: "bar" }
empty == { validate: true, limit: 5, name: "bar" }</pre>
 * 
 * 
 * @param target A simple Javascript object..Object. The object to extend..
 * @param object1 A simple Javascript object..Object. The object that will be merged into the first..
 * @param objectN A simple Javascript object..Object. More objects to merge into the first..
 * @return A simple Javascript object..Object
 * @since 1.0
 */
jQuery.extend = function (target, object1, objectN) {
  return new Object();
};
/** <p>
 * Filter items out of an array, by using a filter function.</p>
 * <p>
 * The specified function will be passed two arguments: The current array item and the index of the item in the array. The function must return 'true' to keep the item in the array, false to remove it.<br>
</p>
 * 
 * 
 * Example:
 * Filters the original array of numbers leaving that are not 5 and have an index greater than 3.  Then it removes all 9s while inverting it.
 * <pre>

    var arr = [ 1, 9, 3, 8, 6, 1, 5, 9, 4, 7, 3, 8, 6, 9, 1 ];
    $("div").text(arr.join(", "));

    arr = jQuery.grep(arr, function(n, i){
      return (n != 5 &amp;&amp; i &gt; 4);
    });
    $("p").text(arr.join(", "));

    arr = jQuery.grep(arr, "a != 9");
    $("span").text(arr.join(", "));

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;p&gt;&lt;/p&gt;
  &lt;span&gt;&lt;/span&gt;
  </pre>
 * 
 * Example:
 * Filter an array of numbers to include only numbers bigger then zero.
 * <pre>$.grep( [0,1,2], function(n,i){
   return n &gt; 0;
 });</pre>
 * 
 * Result:
 * <pre>[1, 2]</pre>
 * 
 * Example:
 * Filter an array of numbers to exclude numbers bigger then zero using the third parameter, invert.
 * <pre>$.grep( [0,1,2,3,4,5], "a &gt; 1", true);</pre>
 * 
 * Result:
 * <pre>[0, 1]</pre>
 * 
 * 
 * @param array Array. The Array to find items in..
 * @param callback A reference to a Javascript function.Function. The function to process each item against.  The first argument to the function is the list item, and the second argument is the list index.  The function should return a Boolean value.  Optionally, this argument may be a string rather than a function.  If the argument is a string, it is treated as a short "lambda-form" function, with "a" representing the list item and "i" representing the index.  For example, "a &gt; 0" may be passed instead of "function(a){ return a &gt; 0; }".

&lt;pre&gt;function callback(elementOfArray, indexInArray) {
  var shouldKeepIt;

  this; // unmapped

  return shouldKeepIt;
}
&lt;/pre&gt;.
 * @param invert true or false.Boolean. If "invert" is false, or not provided, then the function returns an array consisting of all elements for which "callback" returns true.  If "invert" is true, then the function returns an array consisting of all elements for which "callback" returns false..
 * @return Array
 * @since 1.0
 */
jQuery.grep = function (array, callback, invert) {
  return ;
};
/** <p>
 * Turns an array-like object into a true array.</p>
 * <p>
 * Array-like objects have a length property and its properties are numbered from 0 to length - 1.  Typically it will be unnecessary to use this function if you are using jQuery which uses this function internally.<br>
</p>
 * 
 * 
 * Example:
 * Turn a collection of HTMLElements into an Array of them.
 * <pre>

    var arr = jQuery.makeArray(document.getElementsByTagName("div"));
    arr.reverse(); // use an Array method on list of dom elements
    $(arr).appendTo(document.body);
</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;First&lt;/div&gt;
  &lt;div&gt;Second&lt;/div&gt;  
  &lt;div&gt;Third&lt;/div&gt;

  &lt;div&gt;Fourth&lt;/div&gt;</pre>
 * 
 * 
 * @param obj A simple Javascript object..Object. Array-like object to turn in to an actual Array..
 * @return Array
 * @since 1.2
 */
jQuery.makeArray = function (obj) {
  return ;
};
/** <p>
 * Translate all items in an array to another array of items.</p>
 * <p>
 * The translation function that is provided to this method is called for each item in the array and is passed one argument: The item to be translated.

The function can then return the translated value, 'null' (to remove the item), or an array of values - which will be flattened into the full array. <br>
</p>
 * 
 * 
 * Example:
 * Maps the original array to a new one and adds 4 to each value.
 * <pre>
    var arr = [ "a", "b", "c", "d", "e" ]
    $("div").text(arr.join(", "));

    arr = jQuery.map(arr, function(n, i){
      return (n.toUpperCase() + i);
    });
    $("p").text(arr.join(", "));

    arr = jQuery.map(arr, "a + a");
    $("span").text(arr.join(", "));

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;&lt;/div&gt;
  &lt;p&gt;&lt;/p&gt;
  &lt;span&gt;&lt;/span&gt;
  </pre>
 * 
 * Example:
 * Maps the original array to a new one and adds 4 to each value.
 * <pre>$.map( [0,1,2], function(n){
   return n + 4;
 });</pre>
 * 
 * Result:
 * <pre>[4, 5, 6]</pre>
 * 
 * Example:
 * Maps the original array to a new one and adds 1 to each value if it is bigger then zero, otherwise it's removed.
 * <pre>$.map( [0,1,2], function(n){
   return n &gt; 0 ? n + 1 : null;
 });</pre>
 * 
 * Result:
 * <pre>[2, 3]</pre>
 * 
 * Example:
 * Maps the original array to a new one, each element is added with it's original value and the value plus one.
 * <pre>$.map( [0,1,2], function(n){
   return [ n, n + 1 ];
 });</pre>
 * 
 * Result:
 * <pre>[0, 1, 1, 2, 2, 3]</pre>
 * 
 * Example:
 * Maps the original array to a new one, each element is squared.
 * <pre>$.map( [0,1,2,3], "a * a" );</pre>
 * 
 * Result:
 * <pre>[0, 1, 4, 9]</pre>
 * 
 * 
 * @param array Array. The Array to translate..
 * @param callback A reference to a Javascript function.Function. The function to process each item against.  The argument to the function is the list item. The function can return any value.  Optionally, this argument may be a string rather than a function. If the argument is a string, it is treated as a short "lambda-form" function, with "a" representing the list item. For example, "a * a" may be passed instead of "function(a){ return a * a; }". 

&lt;pre&gt;function callback(elementOfArray, indexInArray) {
  var replacementValue;

  this; // unmapped

  return replacementValue;
}
&lt;/pre&gt;.
 * @return Array
 * @since 1.0
 */
jQuery.map = function (array, callback) {
  return ;
};
/** <p>
 * Determine the index of the first parameter in the Array (-1 if not found).</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * 
 * <pre>

    var arr = [ 4, "Pete", 8, "John" ];

    $("span:eq(0)").text(jQuery.inArray("John", arr));
    $("span:eq(1)").text(jQuery.inArray(4, arr));
    $("span:eq(2)").text(jQuery.inArray("David", arr));

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;"John" found at &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;4 found at &lt;span&gt;&lt;/span&gt;&lt;/div&gt;

  &lt;div&gt;"David" found at &lt;span&gt;&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param value Any. Value to see if it exists in the array..
 * @param array Array. Array to look through for the value..
 * @return A valid numeric.Number
 * @since 1.2
 */
jQuery.inArray = function (value, array) {
  return 0;
};
/** <p>
 * Remove all duplicate elements from an array of elements.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Removes any duplicate elements from the array of divs.
 * <pre>
    var divs = $("div").get();

    // add 3 elements of class dup too (they are divs)
    divs = divs.concat($(".dup").get());
    $("div:eq(1)").text("Pre-unique there are " + divs.length + " elements.");

    divs = jQuery.unique(divs);
    $("div:eq(2)").text("Post-unique there are " + divs.length + " elements.")
                  .css("color", "red");

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;There are 6 divs in this document.&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;
  &lt;div class="dup"&gt;&lt;/div&gt;
  &lt;div class="dup"&gt;&lt;/div&gt;

  &lt;div class="dup"&gt;&lt;/div&gt;
  &lt;div&gt;&lt;/div&gt;</pre>
 * 
 * Example:
 * Removes any duplicate elements from the array of divs.
 * <pre>$.unique(document.getElementsByTagName("div"));</pre>
 * 
 * Result:
 * <pre>[&lt;div&gt;, &lt;div&gt;, ...]</pre>
 * 
 * 
 * @param array Array. The Array to translate..
 * @return Array
 * @since 1.1.3
 */
jQuery.unique = function (array) {
  return ;
};
/** <p>
 * Determine if the parameter passed is a function.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Test a few parameter examples.
 * <pre>

    function stub() {
    }
    var objs = [
          function () {},
          { x:15, y:20 },
          null,
          stub,
          "function"
        ];

    jQuery.each(objs, function (i) {
      var isFunc = jQuery.isFunction(objs[i]);
      $("span:eq( " + i + ")").text(isFunc);
    });
</pre>
 * 
 * HTML:
 * <pre>
  &lt;div&gt;jQuery.isFunction(objs[0]) = &lt;span&gt;&lt;/span&gt;&lt;/div&gt;

  &lt;div&gt;jQuery.isFunction(objs[1]) = &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;jQuery.isFunction(objs[2]) = &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;jQuery.isFunction(objs[3]) = &lt;span&gt;&lt;/span&gt;&lt;/div&gt;

  &lt;div&gt;jQuery.isFunction(objs[4]) = &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  </pre>
 * 
 * Example:
 * Finds out if the parameter is a funcion.
 * <pre>$.isFunction(function(){});</pre>
 * 
 * Result:
 * <pre>true</pre>
 * 
 * 
 * @param obj A simple Javascript object..Object. Object to test whether or not it is a function..
 * @return boolean
 * @since 1.2
 */
jQuery.isFunction = function (obj) {
  return ;
};
/** <p>
 * Remove the whitespace from the beginning and end of a string.</p>
 * <p>
 * Uses a regular expression to remove whitespace from the given string.<br>
</p>
 * 
 * 
 * Example:
 * Removes the two whitespaces at the start and at the end of the string.
 * <pre>

    $("button").click(function () {
      var str = "     lots of spaces before and after     ";
      alert("'" + str + "'");

      str = jQuery.trim(str);
      alert("'" + str + "' - no longer");
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;button&gt;Show Trim Example&lt;/button&gt;</pre>
 * 
 * Example:
 * Removes the two whitespaces at the start and at the end of the string.
 * <pre> $.trim("  hello, how are you?  ");</pre>
 * 
 * Result:
 * <pre>"hello, how are you?"</pre>
 * 
 * 
 * @param str A string of characters.String. The string to trim..
 * @return A string of characters.String
 * @since 1.0
 */
jQuery.trim = function (str) {
  return "";
};
/** <p>
 * Returns a unique ID for the element.</p>
 * <p>
 * Typically this function will only be used internally.  It is called automatically when necessary when using the other data() functionality.<br>
</p>
 * 
 * 
 * Example:
 * Get the store id of an element.  It is assigned on the data() function call if one hasn't been assigned yet.
 * <pre>
    $(document.body).click(function(e) {
      var id = jQuery.data(e.target);
      $("span").text(id);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;A div&lt;/div&gt;
  &lt;div&gt;Another&lt;/div&gt;
  &lt;p&gt;The id of this div is &lt;span&gt;?&lt;/span&gt;&lt;/p&gt;</pre>
 * 
 * 
 * @param elem The Javascript object representation of a DOM Element.Element. DOM element of interest..
 * @return A valid numeric.Number
 * @since 1.2
 */
jQuery.data = function (elem) {
  return 0;
};
/** <p>
 * Returns value at named data store for the element.</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Get the data named "blah" stored at for an element.
 * <pre>

    $("button").click(function(e) {
      var adiv = $("div").get(0);
      var value;

      switch ($("button").index(this)) {
        case 0 :
          value = jQuery.data(adiv, "blah");
          break;
        case 1 :
          jQuery.data(adiv, "blah", "hello");
          value = "Stored!";
          break;
        case 2 :
          jQuery.data(adiv, "blah", 86);
          value = "Stored!";
          break;
        case 3 :
          jQuery.removeData(adiv);
          value = "Removed!";
          break;
      }

      $("span").text("" + value);
    });

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;A div&lt;/div&gt;
  &lt;button&gt;Get "blah" from the div&lt;/button&gt;
  &lt;button&gt;Set "blah" to "hello"&lt;/button&gt;

  &lt;button&gt;Set "blah" to 86&lt;/button&gt;
  &lt;button&gt;Remove "blah" from the div&lt;/button&gt;
  &lt;p&gt;The "blah" value of this div is &lt;span&gt;?&lt;/span&gt;&lt;/p&gt;</pre>
 * 
 * 
 * @param elem The Javascript object representation of a DOM Element.Element. DOM element of interest..
 * @param name A string of characters.String. Name of the data stored..
 * @return Any
 * @since 1.2
 */
jQuery.data = function (elem, name) {
  return ;
};
/** <p>
 * Stores the value in the named spot and also returns the value.</p>
 * <p>
 * This function can be useful for attaching data to elements without having to create a new expando.  It also isn't limited to a string.  The value can be any format.

To avoid conflicts in plugins, it is usually effective to store one object using the plugin name and put all the necessary information in that object.


&lt;code&gt;
  var obj = jQuery.data($("#target").get(0), "pluginname", {});
  obj[...] = ...
&lt;/code&gt;<br>
</p>
 * 
 * 
 * Example:
 * Store then retrieve a value from the div element.
 * <pre>
    var adiv = $("div").get(0);
    jQuery.data(adiv, "test", { first: 16, last: "pizza!" });
    $("span:first").text(jQuery.data(adiv, "test").first);
    $("span:last").text(jQuery.data(adiv, "test").last);

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;
    The values stored were 
    &lt;span&gt;&lt;/span&gt;
    and
    &lt;span&gt;&lt;/span&gt;
  &lt;/div&gt;</pre>
 * 
 * 
 * @param elem The Javascript object representation of a DOM Element.Element. DOM element of interest..
 * @param name A string of characters.String. Name of the data to store..
 * @param value Any. Value to be stored..
 * @return Any
 * @since 1.2
 */
jQuery.data = function (elem, name, value) {
  return ;
};
/** <p>
 * Remove the expando attribute that allows data storage on an element.</p>
 * <p>
 * This is the complement function to jQuery.data(elem) which is called as necessary by jQuery.data(elem, name, value).<br>
</p>
 * 
 * 
 * Example:
 * Set a data store then remove it.
 * <pre>

    var adiv = $("div").get(0);

    $("span:eq(0)").text("" + jQuery.data(adiv, "test1"));
    jQuery.data(adiv, "test1", "VALUE-1");
    jQuery.data(adiv, "test2", "VALUE-2");
    $("span:eq(1)").text("" + jQuery.data(adiv, "test1"));
    jQuery.removeData(adiv);
    $("span:eq(2)").text("" + jQuery.data(adiv, "test1"));
    $("span:eq(3)").text("" + jQuery.data(adiv, "test2"));

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;value1 before creation: &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;value1 after creation: &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;value1 after removal: &lt;span&gt;&lt;/span&gt;&lt;/div&gt;

  &lt;div&gt;value2 after removal: &lt;span&gt;&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param elem The Javascript object representation of a DOM Element.Element. Element to delete the data store from..
 * @return 
 * @since 1.2
 */
jQuery.removeData = function (elem) {
  return ;
};
/** <p>
 * Removes just this one named data store.</p>
 * <p>
 * This is the complement function to jQuery.data(elem, name, value).<br>
</p>
 * 
 * 
 * Example:
 * Set a data store for 2 names then remove one of them.
 * <pre>
    var adiv = $("div").get(0);

    $("span:eq(0)").text("" + jQuery.data(adiv, "test1"));
    jQuery.data(adiv, "test1", "VALUE-1");
    jQuery.data(adiv, "test2", "VALUE-2");
    $("span:eq(1)").text("" + jQuery.data(adiv, "test1"));
    jQuery.removeData(adiv, "test1");
    $("span:eq(2)").text("" + jQuery.data(adiv, "test1"));
    $("span:eq(3)").text("" + jQuery.data(adiv, "test2"));

</pre>
 * 
 * HTML:
 * <pre>&lt;div&gt;value1 before creation: &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;value1 after creation: &lt;span&gt;&lt;/span&gt;&lt;/div&gt;
  &lt;div&gt;value1 after removal: &lt;span&gt;&lt;/span&gt;&lt;/div&gt;

  &lt;div&gt;value2 after removal: &lt;span&gt;&lt;/span&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param elem The Javascript object representation of a DOM Element.Element. Element to delete the named data store property from..
 * @param name A string of characters.String. The name of the data store property to remove..
 * @return 
 * @since 1.2
 */
jQuery.removeData = function (elem, name) {
  return ;
};
/** <p>
 * Serializes an array of form elements or an object (core of &lt;a href='Ajax/serialize'&gt;.serialize()&lt;/a&gt; method).</p>
 * <p>
 * <br>
</p>
 * 
 * 
 * Example:
 * Serialize a key/value object.
 * <pre>
    var params = { width:1680, height:1050 };
    var str = jQuery.param(params);
    $("#results").text(str);

</pre>
 * 
 * HTML:
 * <pre>&lt;div id="results"&gt;&lt;/div&gt;</pre>
 * 
 * 
 * @param obj Array&lt;Elements&gt;, jQuery, Object. An Array or jQuery object is serialized by name/value pairs.  An object by key/value pairs..
 * @return A string of characters.String
 * @since 1.2
 */
jQuery.param = function (obj) {
  return "";
};


$ = jQuery;
