var com = com || {};
com.zend = com.zend || {};
com.zend.jsdt = com.zend.jsdt || {};
com.zend.jsdt.test = {
		assertTrue : function(a, msg) {
			if (a !== true) {
				throw { 
					name: "assertTrue", 
					message : "\"" + a + "\" is not true. " + (msg !== undefined ? msg : "")
					};
			}
		},
		
		assertEquals : function(a, b, msg) {
			if (a != b) {
				throw { 
					name: "assertEquals", 
					message : "\"" + a + "\" != \"" + b+ "\" " + (msg !== undefined ? msg : "")
					};
			}
		},
		
		assertSame : function(a, b, msg) {
			if (a !== b) {
				throw { 
					name: "assertSame", 
					message : "\"" + a + "\" !== \"" + b+ "\" " + (msg !== undefined ? msg : "")
					};
			}
		},
		
		run : function(suite) {
			var count = 0;
			var success = 0;
			var log = [];
			
			for (var f in this) {
				suite[f] = this[f];
			}
			
			for (var test in suite) {
				if (/^test/.test(test)) {
					count++;
					try {
						suite[test]();
						success++;
						log.push({name : test});
					} catch(e) {
						log.push({name : test, exception : e});
					}
				}
			}
			
			return { successes : success,
					'count' : count,
					testsRun: log };
		}
}
