package org.eclipse.atf.rest.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.atf.rest.ui.internal.Activator;
import org.eclipse.atf.rest.ui.internal.URLViewPart;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;

public class View implements IExecutableExtensionFactory, IExecutableExtension {

	private static final String HTTP = "http";
	private URL url;
	
	public Object create() throws CoreException {
		return new URLViewPart(url);
	}

	public void setInitializationData(IConfigurationElement config,
			String propertyName, Object data) throws CoreException {
		String contributorId = config.getContributor().getName();
		
		if (data instanceof String) {
			String stringData = (String) data;
			if (stringData.startsWith(HTTP)) { // matches http:// and https://
				try {
					url = new URL(stringData);
				} catch (MalformedURLException e) {
					Activator.log(e);
				}
			} else {
				URL bundleEntry = Platform.getBundle(contributorId).getEntry(stringData);
				try {
					url = FileLocator.resolve(bundleEntry);
				} catch (IOException e) {
					Activator.log(e);
				}
			}
		}
		
		if (url != null) {
			ImageRegistry ir = Activator.getDefault().getImageRegistry(); 
			if (ir.get(url.toString()) == null) {
				String iconPath = config.getAttribute("icon");
	
				if (iconPath != null) {
					ImageDescriptor descr = Activator.imageDescriptorFromPlugin(contributorId, iconPath);
					if (descr != null) {
						ir.put(url.toString(), descr);
					}
				}
			}
		}
	}

}
