package org.eclipse.atf.rest.ui.internal;

import java.net.MalformedURLException;

import org.eclipse.atf.rest.core.internal.JSONEventProvider;
import org.eclipse.atf.rest.core.internal.JSONEventsFactory;
import org.eclipse.atf.rest.ui.internal.events.SelectionEventProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.atf.rest.ui"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;
	
	private JSONEventProvider selectionProvider;
	
	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		
		JSONEventsFactory.getDefault().addProvider(selectionProvider = new SelectionEventProvider());
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		JSONEventsFactory.getDefault().addProvider(selectionProvider);
		
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	public static void log(Throwable e) {
		getDefault().getLog().log(new Status(IStatus.ERROR, PLUGIN_ID, e.getMessage(), e));
		
	}

}
