package org.eclipse.atf.rest.ui.internal;

import org.eclipse.atf.rest.core.internal.JSONListener;
import org.eclipse.swt.browser.Browser;

public class BrowserJSONListener implements JSONListener {

	private Browser browser;
	
	public BrowserJSONListener(Browser target) {
		this.browser = target;
	}
	
	public void dispose() {
		browser = null;
	}
	
	public void event(String ns, String json) {
		if ((browser != null) && (!browser.isDisposed())) {
			browser.execute(nsToSafeJSCall(ns)+"("+json+");");
		}
	}
	
	private String nsToSafeJSCall(String ns) {
		StringBuffer sb = new StringBuffer();
		int dot = -1;
		while ((dot = ns.indexOf('.', dot + 1)) > 0) {
			sb.append(ns.substring(0, dot));
			sb.append(" && ");
		}
		sb.append(ns);
		
		return sb.toString();
	}

}
