package org.eclipse.atf.rest.ui.internal;

import java.net.URL;

import org.eclipse.atf.rest.core.internal.JSONEventsFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class URLViewPart extends ViewPart {

	private Browser browser;
	private URL initialURL;
	private BrowserJSONListener listener;
	
	public URLViewPart(URL url) {
		initialURL = url;
	}

	@Override
	public void createPartControl(Composite parent) {
		browser = new Browser(parent, SWT.MOZILLA);
		browser.setUrl(initialURL.toString());
		browser.addTitleListener(new TitleListener() {
			
			public void changed(TitleEvent event) {
				setPartName(event.title);
				
			}
		});
		listener = new BrowserJSONListener(browser);
		JSONEventsFactory.getDefault().addListener(listener);
	
		setTitleImage(Activator.getDefault().getImageRegistry().get(initialURL.toString()));
		
		
	}
	
	@Override
	public void dispose() {
		if ((browser != null) && (!browser.isDisposed())) {
			JSONEventsFactory.getDefault().removeListener(listener);
			listener.dispose();
			browser.dispose();
			browser = null;
		}
	}
	
	@Override
	public void setFocus() {
		browser.setFocus();
	}
}
