package org.eclipse.atf.rest.ui.internal.actions;

import org.eclipse.atf.rest.ui.internal.Activator;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowView implements ILaunchShortcut {

	private String fViewId;
	
	public ShowView(String viewId) {
		this.fViewId = viewId;
	}
	
	public void launch(ISelection selection, String mode) {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (window == null) {
			return;
		}
		
		IWorkbenchPage page = window.getActivePage();
		if (page == null) {
			return;
		}
		
		try {
			page.showView(fViewId);
		} catch (PartInitException e) {
			Activator.log(e);
		}
	}

	public void launch(IEditorPart editor, String mode) {
		// TODO Auto-generated method stub
		
	}

}
