package org.eclipse.atf.rest.ui.internal.events;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.atf.rest.core.internal.JSONEventProvider;
import org.eclipse.atf.rest.core.internal.JSONListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMarkSelection;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SelectionEventProvider implements JSONEventProvider {

	public static final String NS = "org.eclipse.atf.onSelect";

	private Set<JSONListener> fListeners = new HashSet<JSONListener>();
	
	private ISelectionListener selectionListener = new ISelectionListener() {

		public void selectionChanged(IWorkbenchPart part, ISelection selection) {
			doSelectionChanged(selection);
		}
	};

	private void doSelectionChanged(ISelection sel) {
		String arg = null;
		if (sel instanceof ITextSelection) {
			arg = "'" + ((ITextSelection) sel).getText() + "'";
			
		} else if (sel instanceof IMarkSelection) {
			IMarkSelection msel = ((IMarkSelection) sel);
			IDocument doc = msel.getDocument();
			try {
				arg = "'" + doc.get(msel.getOffset(), msel.getLength()) + "'";
			} catch (BadLocationException e) {
				// invalid selection. can happen any time
			}
			
		} else if (sel instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection) sel;
			arg = "[";
			for (Iterator<?> i = ssel.iterator(); i.hasNext(); ) {
				Object o = i.next();
				arg += "'"+o+"'";
				if (i.hasNext()) {
					arg += ",";
				}
			}
			arg += "]";
		}
		
		if (arg != null) {
			fireEvent(arg);
		}
	}
	
	private void fireEvent(String json) {
		JSONListener[] listeners = fListeners.toArray(new JSONListener[] {});
		for (int i = 0; i < listeners.length; i++) {
			listeners[i].event(NS, json);
		}
	}

	public void addListener(JSONListener listener) {
		if (fListeners.size() == 0) {
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener(selectionListener);
		}
		
		fListeners.add(listener);
	}
	
	public void removeListener(JSONListener listener) {
		fListeners.remove(listener);
		
		if (fListeners.size() == 0) {
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener(selectionListener);
		}
	}
	
}
