/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.server.http.command;

import org.eclipse.atf.server.http.core.HttpServerConfiguration;

public class ModifyPublishDirectoryCommand extends ConfigurationCommand {

	protected String pubDir;
	protected String oldPubDir;
	
	
	public ModifyPublishDirectoryCommand(HttpServerConfiguration configuration, String pubDir) {
		super(configuration, "set the publish directory");
		this.pubDir = pubDir;
	}
	/**
	 * Execute the command.
	 */
	public void execute() {
		oldPubDir = configuration.getPublishDirectory();
		configuration.modifyPublishDirectory(pubDir);
	}

	/**
	 * Undo the command.
	 */
	public void undo() {
		configuration.modifyPublishDirectory(oldPubDir);
	}

}
