/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.server.http.command;

import org.eclipse.atf.server.http.core.HttpServerConfiguration;
import org.eclipse.atf.server.http.core.Messages;


public class ModifyURLPrefixCommand extends ConfigurationCommand {

	protected String prefix;
	protected String oldPrefix;
	
	/**
	 * ModifyURLPrefixCommand constructor.
	 * 
	 * @param configuration a HTTP configuration
	 * @param prefix a new prefix
	 * 
	 */
	public ModifyURLPrefixCommand(HttpServerConfiguration configuration, String prefix) {
		super(configuration, Messages.configurationEditorActionModifyPort);
		this.prefix = prefix;
	}
	/**
	 * Execute the command.
	 */
	public void execute() {
		// find old prefix
		oldPrefix = configuration.getServerURLPrefix();
	
		// make the change
		configuration.modifyURLPrefix(prefix);
	}

	/**
	 * Undo the command.
	 */
	public void undo() {
		configuration.modifyURLPrefix(oldPrefix);
	}

}
