/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.server.http.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class HttpCorePlugin extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.atf.server.http.core";
	        
	// The shared instance
	private static HttpCorePlugin plugin;
	
	/**
	 * The constructor
	 */
	public HttpCorePlugin() {
		plugin = this;
	}
	
	/**
     * Returns the singleton instance of this plugin.
     * 
     * @return org.eclipse.atf.server.http.core.ApachePlugin
     */
    public static HttpCorePlugin getInstance() {
        return plugin;
    }

    /**
     * Return the install location preference.
     * 
     * @param id
     *            a runtime type id
     * @return the install location
     */
    public static String getPreference(String id) {
        return getInstance().getPluginPreferences().getString(id);
    }

    /**
     * Set the install location preference.
     * 
     * @param id
     *            the runtimt type id
     * @param value
     *            the location
     */
    public static void setPreference(String id, String value) {
        getInstance().getPluginPreferences().setValue(id, value);
        getInstance().savePluginPreferences();
    }

    /**
     * Convenience method for logging.
     * 
     * @param status
     *            a status object
     */
    public static void log(IStatus status) {
        getInstance().getLog().log(status);
    }

    /**
     * Returns the Http server's home directory.
     * 
     * @return java.lang.String
     */
    protected static String getHttpStateLocation() {
        try {
            return getInstance().getStateLocation().toOSString();
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * Verify the Http server installation directory.
     * 
     * @param installPath
     * @param id
     * @return <code>true</code> if the directory may be a Apache
     *         installation, and <code>false</code> otherwise
     */
    public static boolean verifyInstallPath(IPath installPath, String id) {
        if (installPath == null)
            return false;

        String dir = installPath.toOSString();
        if (!dir.endsWith(File.separator))
            dir += File.separator;

        return true;
    }

    /*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static HttpCorePlugin getDefault() {
		return plugin;
	}
	
	/**
     * Return a <code>java.io.File</code> object that corresponds to the
     * specified <code>IPath</code> in the plugin directory.
     * 
     * @return a file
     */
    protected static File getPlugin() {
        try {
            URL installURL = getInstance().getBundle().getEntry("/");
            URL localURL = Platform.asLocalURL(installURL);
            return new File(localURL.getFile());
        } catch (IOException ioe) {
            return null;
        }
    }

    public static void log(String message) {
        log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, message, null));
    }

    public static void log(Throwable e) {
        log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
    }

}
