/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
package org.eclipse.atf.server.http.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;

/**
 * 
 */
public class HttpLaunchConfigurationDelegate extends LaunchConfigurationDelegate {

    public HttpLaunchConfigurationDelegate() {
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {

    	//Simply retrieve the Server instance and change the state to STARTED
        IServer server = ServerUtil.getServer(configuration);
        if(server != null) {
        	if(server instanceof Server) {
        		((Server)server).setServerState(IServer.STATE_STARTED);
        	}
        }
    }
}
