/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
package org.eclipse.atf.server.http.core;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class PublishTask extends PublishTaskDelegate {
    public PublishOperation[] getTasks(IServer server, List modules) {
        if (modules == null)
            return null;

        HttpServerBehaviour apacheServer = (HttpServerBehaviour) server.loadAdapter(HttpServerBehaviour.class, null);

        List tasks = new ArrayList();
        int size = modules.size();
        for (int i = 0; i < size; i++) {
            IModule[] module = (IModule[]) modules.get(i);
            IModule m = module[module.length - 1];
            tasks.add(new PublishOperation2(apacheServer, m));
        }

        return (PublishOperation[]) tasks.toArray(new PublishOperation[tasks.size()]);
    }
}
