/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.server.http.editor;

import java.beans.PropertyChangeListener;

import org.eclipse.atf.server.http.command.ModifyPublishDirectoryCommand;
import org.eclipse.atf.server.http.core.HttpServer;
import org.eclipse.atf.server.http.core.HttpServerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ConfigurationPublishDirectorySection extends ServerEditorSection {

	protected HttpServerConfiguration httpConfiguration;
	protected boolean updating;
	protected Text publishDirText;
	protected PropertyChangeListener listener;
	
	public ConfigurationPublishDirectorySection() {
		super();
	}
	
	/*protected void addChangeListener() {
		listener = new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent event) {
				if (HttpServerConfiguration.MODIFY_URL_PREFIX_PROPERTY.equals(event.getPropertyName())) {
					String oldValue = (String) event.getOldValue();
					String newValue = (String) event.getNewValue();
					changeURLPrefix(oldValue, newValue);
				}
			}
		};
		httpConfiguration.addPropertyChangeListener(listener);
	}
	
	protected void changeURLPrefix(String oldValue, String newValue) {
		//urlPrefixText.setText(newValue);
	}*/
	
	public void createSection(Composite parent) {
		super.createSection(parent);
	
		FormToolkit toolkit = getFormToolkit(parent.getDisplay());
		Section section = toolkit.createSection(parent, ExpandableComposite.TWISTIE | ExpandableComposite.EXPANDED
				| ExpandableComposite.TITLE_BAR | Section.DESCRIPTION | ExpandableComposite.FOCUS_TITLE);
		section.setText("Publish Directory");
		section.setDescription("Specify directory to publish content to.");
		section.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_FILL));
		
		Composite composite = toolkit.createComposite(section);
		GridLayout layout = new GridLayout();
		layout.marginHeight = 8;
		layout.marginWidth = 8;
		composite.setLayout(layout);
		composite.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.FILL_HORIZONTAL));
		toolkit.paintBordersFor(composite);
		section.setClient(composite);
		
		createLabel(toolkit, composite, "Directory:");
		
		publishDirText = toolkit.createText(composite, "");
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		publishDirText.setLayoutData(data);
		
		initialize();
		
	}
	
	protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
		Label label = toolkit.createLabel(parent, text);
		label.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		return label;
	}
	
	public void dispose() {
		if (httpConfiguration != null)
			httpConfiguration.removePropertyChangeListener(listener);
	}
	
	/* (non-Javadoc)
	 * Initializes the editor part with a site and input.
	 */
	public void init(IEditorSite site, IEditorInput input) {
		super.init(site, input);
		
		HttpServer s = (HttpServer) server.getAdapter(HttpServer.class);
		try {
			httpConfiguration = s.getHttpServerConfiguration();
		} catch (Exception e) {
			// ignore
		}
		//addChangeListener();
		//initialize();
	}

	/**
	 * Initialize the fields in this editor.
	 */
	protected void initialize() {
		
		String pubDir = httpConfiguration.getPublishDirectory();

		if(pubDir != null)
			publishDirText.setText(pubDir);
		
		publishDirText.setEnabled(!readOnly);
		
		publishDirText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (updating)
					return;
				updating = true;
				execute(new ModifyPublishDirectoryCommand(httpConfiguration, publishDirText.getText()));
				updating = false;
			}
		});
		
	}
}
