/*******************************************************************************
Copyright (c) 2006, 2007 Zend Corporation, IBM Corporation and others. * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
package org.eclipse.atf.server.http.ui.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

/**
 * Wizard fragment
 */
public class HttpRuntimeWizardFragment extends CompositeWizardFragment {

	protected HttpRuntimeComposite comp;

	/**
	 * ServerWizardFragment constructor
	 */
	public HttpRuntimeWizardFragment() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.atf.server.http.ui.CompositeWizardFragment#getComposite()
	 */
	public Composite getComposite() {
		return comp;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.wst.server.ui.task.WizardFragment#createComposite()
	 */
	public Composite createComposite(Composite parent, IWizardHandle wizard) {
		comp = new HttpRuntimeComposite(parent, wizard);
		return comp;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.wst.server.ui.wizard.WizardFragment#enter()
	 */
	public void enter() {
		if (comp != null) {
			IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy) getTaskModel().getObject(TaskModel.TASK_RUNTIME);
			comp.setRuntime(runtime);
		} else {
			System.out.println("comp is null");
		}
	}

	public boolean isComplete() {
		
		if (comp == null)
			return super.isComplete();
		
		IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy) getTaskModel().getObject(TaskModel.TASK_RUNTIME);
		if (runtime == null)
			return false;
		IStatus status = runtime.validate(null);
		return (status == null || status.getSeverity() != IStatus.ERROR);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.wst.server.ui.wizard.WizardFragment#exit()
	 */
	public void exit() {
		try {
			if (comp != null) {
				comp.performOk();
			}
		} catch (Exception e) {
		}
	}
}
