/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.ui.dialog;

import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.atf.templates.model.PagePart;
import org.eclipse.atf.templates.model.VariableRef;
import org.eclipse.atf.templates.model.VariableRefGroup;
import org.eclipse.atf.templates.model.dialog.DialogModel;
import org.eclipse.atf.templates.ui.variablerenderer.IVariableRenderer;
import org.eclipse.atf.templates.ui.variablerenderer.IVariableRendererRegistry;
import org.eclipse.atf.templates.ui.variablerenderer.factory.IVariableRendererFactory;
import org.eclipse.atf.templates.ui.variablerenderer.factory.VariableRendererFactoryRegistry;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.IVariableRegistry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;


public class ModelDrivenDialog extends Dialog implements IVariableRendererRegistry{

	protected DialogModel dialogModel;
	protected IVariableRegistry varReg;
	
	protected HashMap varRendererReg = new HashMap();
	
	public ModelDrivenDialog(Shell parentShell, DialogModel dialogModel, IVariableRegistry varReg) {
		super(parentShell);
		
		setShellStyle( super.getShellStyle() | SWT.RESIZE );
		
		this.dialogModel = dialogModel;
		this.varReg = varReg;
	}
	
	protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (dialogModel.getTitle() != null)
            shell.setText( dialogModel.getTitle() );
        
        //minimum size
        shell.setMinimumSize( 350, 175 );
    }
	
	protected void createButtonsForButtonBar(Composite parent) {
		super.createButtonsForButtonBar(parent);
		getButton(IDialogConstants.OK_ID).setText("Insert"); 
	}

	/*
	 * @see Dialog#createDialogArea(Composite)
	 */
	protected Control createDialogArea(Composite parent) {
		
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setFont(parent.getFont());
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		//composite.setLayout( new RowLayout(SWT.VERTICAL) );
		
		Composite composite2 = null;
		
		for (Iterator iter = dialogModel.parts(); iter.hasNext();) {
			PagePart part = (PagePart) iter.next();
			
			//stupid check, needs to fix design
			if( part instanceof VariableRef ) {
				if(composite2 == null) {
					composite2 = new Composite(composite, SWT.NONE);
					composite2.setFont(composite.getFont());
					GridLayout layout = new GridLayout();
					layout.numColumns = 2;
					composite2.setLayout(layout);
					composite2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				}
				createControl( (VariableRef)part, composite2 );
			}
			else if ( part instanceof VariableRefGroup ){
				createControl( (VariableRefGroup)part, composite );
			}
		}
		
		return composite;
	}
	
	protected void createControl( VariableRef ref, Composite parent ){
				
		IVariable variable = varReg.lookupVariable(ref.getName());
		IVariableRendererFactory rendererFactory = VariableRendererFactoryRegistry.getInstance().getVariableRendererFactory(variable.getType());
		if(rendererFactory == null)
			return;
		IVariableRenderer renderer = rendererFactory.createRenderer();
		renderer.createVariableParts(parent, variable, null);
		
		registerVariableRenderer( variable, renderer );
		
	}
	
	protected void createControl( VariableRefGroup refGroup, Composite parent ){
	
		Group group = new Group( parent, SWT.SHADOW_ETCHED_IN );
		group.setText( refGroup.getDisplayName() );
		
		//group.setLayout( new RowLayout(SWT.VERTICAL));
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		group.setLayout(layout);
		group.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		for (Iterator iter = refGroup.refs(); iter.hasNext();) {
			createControl( (VariableRef)iter.next(), group );
			
		}
		
	}

	/*
	 * IVariableRendererRegistry interface
	 */
	public void registerVariableRenderer(IVariable variable, IVariableRenderer renderer) {
		varRendererReg.put( variable, renderer );
		
	}

	public IVariableRenderer lookupVariable(IVariable variable) {
		return (IVariableRenderer)varRendererReg.get( variable );
	}

	public Iterator renderers() {
		return varRendererReg.values().iterator();
	}

	public Iterator variables(){
		return varRendererReg.keySet().iterator();
	}

}
