/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.ui.variablerenderer;

import org.eclipse.atf.templates.ui.wizard.ModelDrivenWizardPage;
import org.eclipse.atf.templates.variable.BooleanVariable;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.VariableListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;


public class BooleanVariableRenderer implements IVariableRenderer {

	protected Button value = null;
	
	public void createVariableParts(Composite parent, IVariable variable, ModelDrivenWizardPage page) {
		if(!(variable instanceof BooleanVariable))
			return;
		final BooleanVariable booleanVar = (BooleanVariable)variable;
		
		value = new Button( parent, SWT.CHECK);
		value.setText( booleanVar.getDisplayName() );
		value.setSelection( booleanVar.getBooleanValue() );
		
		Label filler = new Label(parent, SWT.NONE);
		GridData gData = new GridData(GridData.FILL_HORIZONTAL);
		filler.setLayoutData(gData);
		
		value.addSelectionListener( new SelectionListener() {

			public void widgetSelected(SelectionEvent e) {
				booleanVar.setBooleanValue(((Button)e.widget).getSelection());
				
			}

			public void widgetDefaultSelected(SelectionEvent e) {}
			
			
		});
		
		final VariableListener listener = new VariableListener(){

			public void variableChanged(IVariable source) {
				if( value.getSelection() != booleanVar.getBooleanValue() )
					value.setSelection(booleanVar.getBooleanValue());
			}
			
		};
		
		booleanVar.addListener( listener );
		
		value.addDisposeListener( new DisposeListener(){

			public void widgetDisposed(DisposeEvent e) {
				booleanVar.removeListener( listener );
			} 
			
		});

	}

	public Control getControl() {
		return value;
	}
}
