/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.ui.variablerenderer;

import org.eclipse.atf.templates.ui.wizard.ModelDrivenWizard;
import org.eclipse.atf.templates.ui.wizard.ModelDrivenWizardPage;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.ProjectVariable;
import org.eclipse.atf.templates.variable.VariableListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;


public class ProjectVariableRenderer implements IVariableRenderer {

	protected Combo value = null;
	
	public void createVariableParts(Composite parent, IVariable variable, ModelDrivenWizardPage page) {
		
		final ProjectVariable projectVar = (ProjectVariable)variable;
		
		Label label = new Label(parent, SWT.NONE);
		label.setText( projectVar.getDisplayName() + ":" );
		
		value = new Combo( parent, SWT.DROP_DOWN | SWT.READ_ONLY );
		
		//create list of valid projects
		IProject [] allProjects = ProjectVariable.getAllProjects();
		
		//have the variable filter internally the valid projects
		IProject [] validProjects = projectVar.filterValidProjects( allProjects );
		
		String [] projectNames = new String[ validProjects.length ];
		for (int i = 0; i < projectNames.length; i++) {
			projectNames[i] = validProjects[i].getName();
		}
		
		//set the list of valid projects
		value.setItems( projectNames );		
		
		GridData gData = new GridData(GridData.FILL_HORIZONTAL);
		value.setLayoutData(gData);
		
		value.addModifyListener( new ModifyListener(){

			public void modifyText(ModifyEvent e) {
				IProject selectedProject = ProjectVariable.getProjectNamed( value.getText() );
				projectVar.setProjectValue( selectedProject );
			}
			
		});
		
		//make the selected here so the variable gets notified
		//also add the logic to check the selected Project and if it passes the valid check
		if( projectVar.isDefaultSelected() ){
			//get the selection and check if it is a valid project
			
			IProject selectedProject = ((ModelDrivenWizard)page.getWizard()).getInitiallySelectedProject();
			if(selectedProject != null && projectVar.isProjectValid(selectedProject)) {
				value.setText( selectedProject.getName() );
			}
			
			else{
				if( projectNames.length > 0 )
					value.setText( projectNames[0] );
			}
			
		}
		else{
			if( projectNames.length > 0 )
				value.setText( projectNames[0] );
		}
		
		final VariableListener listener = new VariableListener(){

			public void variableChanged(IVariable source) {
				if( !value.getText().equals(projectVar.getProjectValue().getName()) )
					value.setText( projectVar.getProjectValue().getName() );
			}
			
		};
		
		projectVar.addListener( listener );
		
		value.addDisposeListener( new DisposeListener(){

			public void widgetDisposed(DisposeEvent e) {
				projectVar.removeListener( listener );
			} 
			
		});
	}
	
	public Control getControl() {
		return value;
	}

}
