/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.ui.variablerenderer;

import org.eclipse.atf.templates.ui.wizard.ModelDrivenWizardPage;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.StringOptionsVariable;
import org.eclipse.atf.templates.variable.VariableListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;


public class StringOptionsVariableRenderer implements IVariableRenderer {

	protected Combo value = null;
	
	public void createVariableParts(Composite parent, IVariable variable, ModelDrivenWizardPage page) {
		final StringOptionsVariable optionsVar = (StringOptionsVariable)variable;
		
		Label label = new Label(parent, SWT.NONE);
		label.setText( optionsVar.getDisplayName() + ":" );
		
		value = new Combo( parent, SWT.DROP_DOWN );
		value.setItems( optionsVar.getOptions() );
		value.setText( optionsVar.getStringValue() );
		GridData gData = new GridData(GridData.FILL_HORIZONTAL);
		value.setLayoutData(gData);
		
		value.addModifyListener( new ModifyListener(){

			public void modifyText(ModifyEvent e) {
				optionsVar.setStringValue( value.getText() );
				
			}
			
		});
		
		
		final VariableListener listener = new VariableListener(){

			public void variableChanged(IVariable source) {
				if( !value.getText().equals(optionsVar.getStringValue()) )
					value.setText( optionsVar.getStringValue() );
			}
			
		};
		
		optionsVar.addListener( listener );
		
		value.addDisposeListener( new DisposeListener(){

			public void widgetDisposed(DisposeEvent e) {
				optionsVar.removeListener( listener );
			} 
			
		});

	}
	
	public Control getControl() {
		return value;
	}

}