/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.ui.variablerenderer;

import org.eclipse.atf.templates.ui.wizard.ModelDrivenWizardPage;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.StringVariable;
import org.eclipse.atf.templates.variable.VariableListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


public class StringVariableRenderer implements IVariableRenderer {

	protected Text value = null;
	
	public void createVariableParts(Composite parent, IVariable variable, ModelDrivenWizardPage page) {
		
		if(!(variable instanceof StringVariable))
			return;
		final StringVariable strVar = (StringVariable)variable;
		
		Label label = new Label(parent, SWT.NONE);
		label.setText( strVar.getDisplayName() + ":" );
		
		value = new Text( parent, SWT.SINGLE | SWT.BORDER );
		value.setText( strVar.getStringValue() );
		GridData gData = new GridData(GridData.FILL_HORIZONTAL);
		value.setLayoutData(gData);
		
		value.addKeyListener( new KeyListener(){
			
			public void keyPressed(KeyEvent e) {}

			public void keyReleased(KeyEvent e) {
				strVar.setStringValue( ((Text)e.widget).getText() );
			}
			
		});
		
		final VariableListener listener = new VariableListener(){

			public void variableChanged(IVariable source) {
				if( !value.getText().equals(strVar.getStringValue()) )
					value.setText( strVar.getStringValue() );
			}
			
		};
		
		strVar.addListener( listener );
		
		value.addDisposeListener( new DisposeListener(){

			public void widgetDisposed(DisposeEvent e) {
				strVar.removeListener( listener );
			} 
			
		});
		
	}
	
	public Control getControl() {
		return value;
	}

}
