/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class FileTemplate implements Template {

	protected URL path;

	public FileTemplate(URL path) {
		this.path = path;
	}

	public URL getPath(){
		return path;
	}
	
	public String getContent() {

		try {
			InputStreamReader reader = new InputStreamReader(path.openStream());
			StringBuffer buffer = new StringBuffer();

			int ch;
			while ((ch = reader.read()) != -1) {

				buffer.append((char) ch);
			}

			return buffer.toString();

		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
		
		return "";
	}
}
