/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;


public class TemplateFactory {

	protected static final String ATTR_VALUE = "value";
	protected static final String ATTR_PATH = "path";
	
	protected static TemplateFactory instance = new TemplateFactory();
	
	public static TemplateFactory getInstance(){
		return instance;
	}
	
	protected TemplateFactory(){
		
	}
	
	public Template createTemplate( IConfigurationElement templateElement ){
		
		Template template;
		
		String path = templateElement.getAttribute( ATTR_PATH );
		
		//resove path to IFile
		String pluginID = templateElement.getDeclaringExtension().getNamespace();
		
		Bundle bundle = Platform.getBundle( pluginID );
		template = new FileTemplate( Platform.find(bundle, new Path(path)) );
		
		return template;
	}
}
