/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model;

import java.util.ArrayList;
import java.util.Iterator;

public class VariableRefGroup implements PagePart {
	protected String name;
	protected String displayName;
	
	protected ArrayList variableRefs = new ArrayList();
	
	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getDisplayName() {
		return displayName;
	}
	
	public void addVariableRefs( VariableRef ref ){
		variableRefs.add( ref );
	}
	
	public Iterator refs(){
		return variableRefs.iterator();
	}
}
