/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model.dialog;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.atf.templates.model.PagePart;


public class DialogModel {
	
	protected String name;
	protected String title;
	protected String description;
	
	protected ArrayList parts = new ArrayList();
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public void addPart( PagePart part ){
		parts.add( part );
	}
	
	public Iterator parts(){
		return parts.iterator();
	}

	
}
