/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model.dialog;

import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.atf.templates.Template;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.IVariableRegistry;


public class SnippetModel implements IVariableRegistry{

	protected String targetSnippet;

	protected DialogModel dialogModel;
	protected Template template;
	
	protected HashMap variableRegistry = new HashMap();
	
	public String getTargetSnippet() {
		return targetSnippet;
	}

	public void setTargetSnippet(String targetSnippet) {
		this.targetSnippet = targetSnippet;
	}
		
	public DialogModel getDialogModel() {
		return dialogModel;
	}

	public void setDialogModel(DialogModel dialogModel) {
		this.dialogModel = dialogModel;
	}

	public Template getTemplate() {
		return template;
	}

	public void setTemplate(Template template) {
		this.template = template;
	}

	public void reset(){
		for (Iterator iter = variables(); iter.hasNext();) {
			IVariable variable = (IVariable) iter.next();
			variable.reset();
		}
	}
	
	/*
	 * VariableRegistry interface
	 */
	public void registerVariable(IVariable variable) {
		variableRegistry.put( variable.getName(), variable );
	}

	public IVariable lookupVariable(String name) {
		return (IVariable)variableRegistry.get( name );
	}
	
	public Iterator variables(){
		return variableRegistry.values().iterator();
	}
}
