/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model.dialog.factory;

import org.eclipse.atf.templates.model.VariableRef;
import org.eclipse.atf.templates.model.VariableRefGroup;
import org.eclipse.atf.templates.model.dialog.DialogModel;
import org.eclipse.core.runtime.IConfigurationElement;


public class DialogModelFactory {
	protected static final String ATTR_NAME = "name";
	protected static final String ATTR_DISPLAYNAME = "displayName";
	protected static final String ATTR_TITLE = "title";
	
	protected static final String TAG_DESCRIPTION = "description";
	
	protected static final String TAG_VARIABLEREF = "variableRef";
	protected static final String TAG_VARIABLEGROUP = "variableRefGroup";
	
	protected static DialogModelFactory instance = new DialogModelFactory();
	
	public static DialogModelFactory getInstance(){
		return instance;
	}
	
	protected DialogModelFactory(){
		
	}
	
	public DialogModel createDialogModel( IConfigurationElement modelElement ){
		
		DialogModel dialogModel = new DialogModel();
		
		//name
		dialogModel.setName(modelElement.getAttribute(ATTR_NAME));
		
		//title
		dialogModel.setTitle(modelElement.getAttribute(ATTR_TITLE));
		
		//description
		IConfigurationElement descriptionElement = modelElement.getChildren(TAG_DESCRIPTION)[0]; //should be one
		dialogModel.setDescription(descriptionElement.getValue());
		
		IConfigurationElement[] pageParts = modelElement.getChildren();

		for( int i=0; i<pageParts.length; i++ ){
			
			if( pageParts[i].getName().equals(TAG_VARIABLEREF) ){
				dialogModel.addPart( createVariableRef(pageParts[i]) );
				
			}
			else if( pageParts[i].getName().equals(TAG_VARIABLEGROUP) ){
				dialogModel.addPart( createVariableRefGroup(pageParts[i]) );				
			}
		}
		
		return dialogModel;
	}
	
	protected VariableRef createVariableRef( IConfigurationElement refElement ){
		VariableRef ref = new VariableRef();
		
		ref.setName( refElement.getAttribute(ATTR_NAME) );
		
		return ref;
	}
	
	protected VariableRefGroup createVariableRefGroup( IConfigurationElement refGroupElement ){
		VariableRefGroup refGroup = new VariableRefGroup();
		
		refGroup.setName( refGroupElement.getAttribute(ATTR_NAME) );
		refGroup.setDisplayName( refGroupElement.getAttribute(ATTR_DISPLAYNAME) );
		
		IConfigurationElement [] refElementArray = refGroupElement.getChildren(); //should only contain VariableRef elements
		
		for (int i = 0; i < refElementArray.length; i++) {
			refGroup.addVariableRefs( createVariableRef(refElementArray[i]) );
		}
		
		return refGroup;
	}
}
