/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model.dialog.factory;

import org.eclipse.atf.templates.Template;
import org.eclipse.atf.templates.TemplateFactory;
import org.eclipse.atf.templates.model.dialog.DialogModel;
import org.eclipse.atf.templates.model.dialog.SnippetModel;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.factory.IVariableFactory;
import org.eclipse.atf.templates.variable.factory.VariableFactoryRegistry;
import org.eclipse.core.runtime.IConfigurationElement;


public class SnippetModelFactory {

	protected static final String ATTR_TARGETSNIPPET = "targetSnippet";
	
	protected static final String TAG_VARIABLES = "variables";
	
	protected static final String TAG_DIALOG = "dialog";
	
	protected static final String TAG_TEMPLATE = "template";

	protected static SnippetModelFactory instance = new SnippetModelFactory();

	public static SnippetModelFactory getInstance() {
		return instance;
	}

	protected SnippetModelFactory() {

	}

	public SnippetModel createSnippetModel(IConfigurationElement modelElement) {

		SnippetModel snippetModel = new SnippetModel();

		snippetModel.setTargetSnippet(modelElement
				.getAttribute(ATTR_TARGETSNIPPET));
				
		//ADDING VARIABLES
		IConfigurationElement variablesElement = modelElement.getChildren( TAG_VARIABLES )[0];
		IConfigurationElement [] variableElementArray = variablesElement.getChildren(); //should all be variable elements
		
		VariableFactoryRegistry varFactoryRegistry = VariableFactoryRegistry.getInstance();
		for (int i = 0; i < variableElementArray.length; i++) {
			//search the VarFactoryRegistry for the Factory for this variable type
			IVariableFactory varFactory = varFactoryRegistry.getVariableFactory( variableElementArray[i] );
			
			//factory could be null, so need to check
			if( varFactory != null ){
				IVariable variable = varFactory.createVariable( variableElementArray[i] );
				snippetModel.registerVariable( variable );
				variable.setVariableRegistry( snippetModel );
				
			}
			
		}
				
		//ADDING DIALOG		
		IConfigurationElement dialogElement = modelElement.getChildren( TAG_DIALOG )[0]; //must have at least one
		DialogModel dialogModel = DialogModelFactory.getInstance().createDialogModel( dialogElement );
		snippetModel.setDialogModel( dialogModel );

		//TEMPLATE
		IConfigurationElement templateElement = modelElement.getChildren(TAG_TEMPLATE)[0]; //must have at least one
		Template template = TemplateFactory.getInstance().createTemplate( templateElement );
		snippetModel.setTemplate( template );

		return snippetModel;
	}
}
