/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model.factory;

import org.eclipse.atf.templates.model.wizard.PageModel;
import org.eclipse.atf.templates.model.wizard.WizardModel;
import org.eclipse.atf.templates.operation.IOperation;
import org.eclipse.atf.templates.operation.factory.IOperationFactory;
import org.eclipse.atf.templates.operation.factory.OperationFactoryRegistry;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.factory.IVariableFactory;
import org.eclipse.atf.templates.variable.factory.VariableFactoryRegistry;
import org.eclipse.core.runtime.IConfigurationElement;


public class WizardModelFactory {

	protected static final String ATTR_TARGETWIZARD = "targetWizard";
	
	protected static final String ATTR_TITLE = "title";

	protected static final String TAG_VARIABLES = "variables";
	
	protected static final String TAG_PAGES = "pages";
	
	protected static final String TAG_FINISH = "finish";
	
	protected static final String TAG_OPERATION = "operation";

	protected static WizardModelFactory instance = new WizardModelFactory();

	public static WizardModelFactory getInstance() {
		return instance;
	}

	protected WizardModelFactory() {

	}

	public WizardModel createWizardModel(IConfigurationElement modelElement) {

		WizardModel wizardModel = new WizardModel();

		wizardModel.setTargetWizard(modelElement
				.getAttribute(ATTR_TARGETWIZARD));
		
		wizardModel.setTitle(modelElement
				.getAttribute(ATTR_TITLE));

		
		//ADDING VARIABLES
		IConfigurationElement variablesElement = modelElement.getChildren( TAG_VARIABLES )[0];
		IConfigurationElement [] variableElementArray = variablesElement.getChildren(); //should all be variable elements
		
		VariableFactoryRegistry varFactoryRegistry = VariableFactoryRegistry.getInstance();
		for (int i = 0; i < variableElementArray.length; i++) {
			//search the VarFactoryRegistry for the Factory for this variable type
			IVariableFactory varFactory = varFactoryRegistry.getVariableFactory( variableElementArray[i] );
			
			//factory could be null, so need to check
			if( varFactory != null ){
				IVariable variable = varFactory.createVariable( variableElementArray[i] );
				wizardModel.registerVariable( variable );
				variable.setVariableRegistry( wizardModel );
				
			}
			
		}
		
		
		//ADDING PAGES		
		IConfigurationElement pagesElement = modelElement.getChildren( TAG_PAGES )[0]; //must have at least one
		IConfigurationElement[] pageElementArray = pagesElement.getChildren(); //should all be page elements

		for (int i = 0; i < pageElementArray.length; i++) {
			PageModel pageModel = PageModelFactory.getInstance()
					.createPageModel(pageElementArray[i]);

			wizardModel.addPage(pageModel);
		}

		//FINISH OPERATIONS
		IConfigurationElement finishElement = modelElement.getChildren(TAG_FINISH)[0];
		
		//create and add Operations
		OperationFactoryRegistry opsFactoryRegistry = OperationFactoryRegistry.getInstance();
		IConfigurationElement [] operationElementArray = finishElement.getChildren( TAG_OPERATION );
		
		for (int i = 0; i < operationElementArray.length; i++) {
			//search the OperationFactoryRegistry for the Factory for this operation type
			IOperationFactory opsFactory = opsFactoryRegistry.getOperationFactory( operationElementArray[i] );
			
			//factory could be null, so need to check
			if( opsFactory != null ){
				IOperation operation = opsFactory.createOperation( operationElementArray[i] );
				wizardModel.addOperation(operation);
			}
			
		}
		
//		IConfigurationElement [] operationElements = finishElement.getChildren(); //should all be operation elements
//		
//		for (int i = 0; i < operationElements.length; i++) {
//			IOperation operation = OperationFactory.getInstance()
//					.createOperation(operationElements[i]);
//
//			wizardModel.addOperation(operation);
//		}

		return wizardModel;
	}
}
