/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model.wizard;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.atf.templates.model.IValidator;
import org.eclipse.atf.templates.model.PagePart;
import org.eclipse.atf.templates.model.VariableRef;
import org.eclipse.atf.templates.model.VariableRefGroup;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.IVariableRegistry;


public class PageModel {
	
	protected String name;
	protected String title;
	protected String description;
	
	protected IValidator validator = null;
	
	protected ArrayList parts = new ArrayList();
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public void addPart( PagePart part ){
		parts.add( part );
		
		pageVariables = null; //set to null so the next time it is recalculated
	}
	
	public Iterator parts(){
		return parts.iterator();
	}

	public IValidator getValidator() {
		return validator;
	}

	public void setValidator(IValidator validator) {
		this.validator = validator;
	}

	private ArrayList pageVariables = null;
	public Iterator pageVariables( IVariableRegistry varReg ){
		
		if( pageVariables != null )
			return pageVariables.iterator();
		
		else{
			pageVariables = new ArrayList();
			for (Iterator iter = parts.iterator(); iter.hasNext();) {
				PagePart part = (PagePart) iter.next();
				
//				stupid check, need to fix design
				if( part instanceof VariableRef ){
					IVariable variable = varReg.lookupVariable( ((VariableRef)part).getName() );
					pageVariables.add( variable );
				}
				else if ( part instanceof VariableRefGroup ){
					for (Iterator iter2 = ((VariableRefGroup)part).refs(); iter.hasNext();) {
						pageVariables.add( (VariableRef)iter2.next() );
					}
				}
			}
			
			return pageVariables.iterator();
		}
	}
}
