/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.atf.templates.operation.IOperation;
import org.eclipse.atf.templates.variable.IVariable;
import org.eclipse.atf.templates.variable.IVariableRegistry;


public class WizardModel implements IVariableRegistry{

	protected String targetWizard;
	protected String title = "";

	protected ArrayList pages = new ArrayList();
	protected ArrayList operations = new ArrayList();
	
	protected HashMap variableRegistry = new HashMap();
	
	public String getTargetWizard() {
		return targetWizard;
	}

	public void setTargetWizard(String targetWizard) {
		this.targetWizard = targetWizard;
	}
	
	public String getTitle(){
		return title;
	}
	
	public void setTitle( String title ){
		this.title = title;
	}
	
	public void addPage( PageModel pageModel ){
		pages.add( pageModel );
	}
	
	public Iterator pages(){
		return pages.iterator();
	}
	
	public void addOperation( IOperation operation ){
		operations.add( operation );
	}
	
	public Iterator operations(){
		return operations.iterator();
	}
	
	public int operationCount(){
		return operations.size();
	}
	
	public void reset(){
		for (Iterator iter = variables(); iter.hasNext();) {
			IVariable variable = (IVariable) iter.next();
			variable.reset();
		}
	}
	
	/*
	 * VariableRegistry interface
	 */
	public void registerVariable(IVariable variable) {
		variableRegistry.put( variable.getName(), variable );
	}

	public IVariable lookupVariable(String name) {
		return (IVariable)variableRegistry.get( name );
	}
	
	public Iterator variables(){
		return variableRegistry.values().iterator();
	}
}
