/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.templates.model.wizard;

import java.util.HashMap;

import org.eclipse.atf.templates.TemplatesPlugin;
import org.eclipse.atf.templates.model.factory.WizardModelFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;


/**
 * 
 * @author Gino Bustelo
 *
 * This class reads the wizardModel extensions and keeps a map of target
 * wizard id to WizardModel.
 */
public class WizardModelRegistry {
	
	protected static final String PLUGIN_POINT = "wizardModel";
	protected static final String TAG_MODEL = "model";
	
	protected static WizardModelRegistry instance = new WizardModelRegistry();
	
	public static WizardModelRegistry getInstance(){
		return instance;
	}
	
	protected WizardModelRegistry(){
		init();
	}
	
	protected HashMap models = new HashMap();
	
	/**
	 * Read in all the wizardModel defined in extensions and add them to the
	 * internal map.
	 */
	protected void init(){
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(TemplatesPlugin.ID, 
				PLUGIN_POINT);
		
		if (point == null)
			return;
		IExtension[] extensions = point.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] elements =
				extensions[i].getConfigurationElements();
			for (int j = 0; j < elements.length; j++) {
				if (elements[j].getName().equals(TAG_MODEL)) {
					
					WizardModel model = WizardModelFactory.getInstance().createWizardModel(elements[j]);
					if (model != null) {
						models.put( model.getTargetWizard(), model );
					}
				}
			}
		}
	}
	
	/*
	 * Returns the WizardModel mapped to the provide wizard id (if any).
	 */
	public WizardModel getWizardModel( String targetWizard ){
		return (WizardModel)models.get( targetWizard );
	}

}
