/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.templates.operation;

import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.RuntimeManager;
import org.eclipse.atf.runtime.adapter.RuntimeInstallerAdapter;
import org.eclipse.atf.templates.TemplatesPlugin;
import org.eclipse.atf.templates.util.VariableSubtitutionHelper;
import org.eclipse.atf.templates.variable.IVariableRegistry;
import org.eclipse.atf.templates.variable.ProjectVariable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This operation installs the specified Runtime if necessary.
 */
public class InstallRuntimeOperation implements IOperation {

	protected String project = "";
	protected String runtime = "";
	
	public IStatus execute(IVariableRegistry varReg) {

		//validate the inputs to the operation
		VariableSubtitutionHelper substitutionHelper = VariableSubtitutionHelper.getInstance();
		
		String projectName = null;
		try {
			projectName = substitutionHelper.substitute( project, varReg );
		} catch ( Exception e ) {
			e.printStackTrace();
			IStatus status = new Status(IStatus.ERROR, TemplatesPlugin.getDefault().getBundle().getSymbolicName(), IStatus.ERROR, 
					"ERROR: InstallRuntimeOperation - could not resolve the value of project!", e);
			
			
			return status;
		}
		
		IProject destProject = ProjectVariable.getProjectNamed( projectName );
		
		IRuntime runtimeToInstall = RuntimeManager.getInstance().getRuntime( runtime );
		
		
		
		IStatus status;
		try{
			//get the runtime installer adapter for the project and delegate
			RuntimeInstallerAdapter installerAdapter = (RuntimeInstallerAdapter)destProject.getAdapter( RuntimeInstallerAdapter.class );
			
			if( !installerAdapter.isInstalled( runtimeToInstall ))
				status = installerAdapter.installRuntime( runtimeToInstall );
			else
				status = new Status( Status.OK, TemplatesPlugin.ID, Status.OK, "Runtime already installed.", null );
			
		}
		catch( NullPointerException npe ){
			status = new Status( Status.ERROR, TemplatesPlugin.ID, Status.OK, "ERROR: InstallRuntimeOperation - no Runtime installer available for this type of project.", npe );
		}
		catch( Exception e ){
			status = new Status( Status.ERROR, TemplatesPlugin.ID, Status.OK, "ERROR: InstallRuntimeOperation - problems during Runtime installation.", e );
		}
		
		//wrap the status if there is a problem
		if( !status.isOK() ){
			IStatus innerStatus = status;
			status = new MultiStatus( TemplatesPlugin.ID, Status.ERROR, 
					new IStatus[]{innerStatus}, 
					"ERROR: InstallRuntimeOperation - Runtime installation failed, go to Preferences to correct the problem.", null );
		}
					
		return status;
	}

	public void setProject(String project) {
		this.project = project;
	}

	public void setRuntime(String runtime) {
		this.runtime = runtime;
	}
	
	

}
